/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.sync.util;

import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.AbstractResource;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManager;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.impl.sync.SynchronizationSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.sync.util.BlockingThreadCache;
import com.sap.jvm.profiling.snapshot.impl.sync.util.BlockingThreadCacheIterator;
import com.sap.jvm.profiling.snapshot.resource.SnapshotResource;
import com.sap.jvm.profiling.sync.event.SyncEnteredEvent;
import com.sap.jvm.profiling.sync.event.SyncExitEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public final class BlockingThreadCache2
extends AbstractResource
implements SnapshotResource,
BlockingThreadCache {
    private static final int VERSION = 0;
    private long writeWork;
    private final HashMap<Long, ArrayList<ExitValue>> exitEvents;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockingThreadCache2(ResourceName name, ProgressReporter reporter) throws IOException {
        super(name);
        SnapshotResourceManager manager = SnapshotResourceManagerFactory.get(name.getSession());
        SynchronizationSnapshotImpl snapshot = (SynchronizationSnapshotImpl)manager.getSnapshot(name);
        ProfilingReader reader = snapshot.getEventReader(reporter);
        reporter.setWork(I18n._s((String)"Checking for blocking threads ... (<%> %)"), reader.getNrOfPacketsToRead());
        this.exitEvents = new HashMap();
        try {
            ProfilingPacket packet;
            while ((packet = reader.nextPacket()) != null) {
                reporter.reportNextOrThrow();
                if (!(packet instanceof SyncExitEvent)) continue;
                SyncExitEvent syncExitEvent = (SyncExitEvent)packet;
                long timestamp = syncExitEvent.getTimeStamp() - syncExitEvent.getCumulatedSafepointTime();
                long objectId = syncExitEvent.getObjectId();
                char threadIndex = syncExitEvent.getThreadIndex();
                ArrayList<ExitValue> list = this.exitEvents.get(objectId);
                if (list == null) {
                    list = new ArrayList();
                    this.exitEvents.put(objectId, list);
                }
                list.add(new ExitValue(threadIndex, syncExitEvent.getLockCount(), syncExitEvent.getStackTraceIndex(), timestamp, syncExitEvent.getId(), objectId));
            }
        }
        finally {
            reader.close();
        }
        for (List list : this.exitEvents.values()) {
            Collections.sort(list);
            this.writeWork += (long)list.size();
        }
        for (List list : this.exitEvents.values()) {
            int size = list.size();
            boolean neededSwap = true;
            for (int run = 1; run < size && neededSwap; ++run) {
                long prevTimestamp = ((ExitValue)list.get(run - 1)).timestamp;
                neededSwap = false;
                for (int i = run; i < size; ++i) {
                    long currTimestamp = ((ExitValue)list.get(i)).timestamp;
                    if (prevTimestamp > currTimestamp) {
                        neededSwap = true;
                        list.set(i - 1, ((ExitValue)list.get(i - 1)).forNewTimestamp(currTimestamp));
                        list.set(i, ((ExitValue)list.get(i)).forNewTimestamp(prevTimestamp));
                        continue;
                    }
                    prevTimestamp = currTimestamp;
                }
            }
        }
    }

    public BlockingThreadCache2(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        super(name);
        reader.readVersion(0);
        this.writeWork = reader.readInt64();
        reporter.setWork(I18n._s((String)"Reading the blocking threads information .... (<%> %)"), this.writeWork);
        int nrOfObjectIds = reader.readInt32();
        this.exitEvents = new HashMap();
        for (int i = 0; i < nrOfObjectIds; ++i) {
            long objectId = reader.readInt64();
            int nrOfValues = reader.readInt32();
            ArrayList<ExitValue> values = new ArrayList<ExitValue>(nrOfValues);
            for (int j = 0; j < nrOfValues; ++j) {
                reporter.reportNextOrThrow();
                values.add(new ExitValue(reader));
            }
            this.exitEvents.put(objectId, values);
        }
    }

    public static BlockingThreadCache2 create(ResourceName name, ProgressReporter reporter) throws IOException {
        return new BlockingThreadCache2(name, reporter);
    }

    @Override
    public BlockingThreadCacheIterator iterator(long objectId, long startBlockedTime, long endBlockedTime, char blockerThread, long lockCountBefore, SyncEnteredEvent exitEvent) {
        ArrayList<ExitValue> list = this.exitEvents.get(objectId);
        if (list == null || startBlockedTime >= endBlockedTime) {
            return new Iterator(null, 0L, 0L, 0);
        }
        int from = 0;
        int to = list.size();
        while (from < to - 1) {
            int mid = (from + to) / 2;
            if (list.get(mid).timestamp > startBlockedTime) {
                to = mid;
                continue;
            }
            from = mid;
        }
        while (list.get(from).timestamp <= startBlockedTime) {
            if (++from != list.size()) continue;
            return new Iterator(null, 0L, 0L, 0);
        }
        assert (from == 0 || list.get(from - 1).timestamp <= startBlockedTime);
        return new Iterator(list, startBlockedTime, endBlockedTime, from);
    }

    public ResourceName[] getDependents() {
        return null;
    }

    public boolean isModifiable() {
        return false;
    }

    @Override
    public long calculateWriteWork() {
        return this.writeWork;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt64(this.writeWork);
        reporter.setWork(I18n._s((String)"Writing the blocking threads information .... (<%> %)"), this.writeWork);
        writer.writeInt32(this.exitEvents.size());
        for (Map.Entry<Long, ArrayList<ExitValue>> entry : this.exitEvents.entrySet()) {
            writer.writeInt64(entry.getKey().longValue());
            ArrayList<ExitValue> values = entry.getValue();
            writer.writeInt32(values.size());
            for (ExitValue value : values) {
                reporter.reportNextOrThrow();
                value.write(writer);
            }
        }
    }

    public final class Iterator
    implements BlockingThreadCacheIterator {
        private ArrayList<ExitValue> list;
        private long startBlockedTime;
        private long endBlockedTime;
        private int index;
        private long startTimestamp;

        private Iterator(ArrayList<ExitValue> list, long startBlockedTime, long endBlockedTime, int initialIndex) {
            this.list = list;
            this.startBlockedTime = startBlockedTime;
            this.endBlockedTime = endBlockedTime;
            this.index = initialIndex - 1;
        }

        @Override
        public boolean next() {
            ++this.index;
            if (this.list == null) {
                return false;
            }
            if (this.index >= this.list.size()) {
                this.list = null;
                return false;
            }
            if (this.list.get(this.index).timestamp > this.endBlockedTime) {
                this.list = null;
                return false;
            }
            this.startTimestamp = this.index > 0 ? Math.max(this.startBlockedTime, this.list.get(this.index - 1).timestamp) : this.startBlockedTime;
            return true;
        }

        @Override
        public char getThread() {
            this.checkValidity();
            return this.list.get(this.index).threadIndex;
        }

        @Override
        public long getBlockedTime() {
            this.checkValidity();
            return Math.min(this.endBlockedTime, this.list.get(this.index).timestamp) - this.startTimestamp;
        }

        @Override
        public int getStackTraceIndex() {
            this.checkValidity();
            return this.list.get(this.index).stackId;
        }

        @Override
        public long getId() {
            this.checkValidity();
            return this.list.get(this.index).id;
        }

        private void checkValidity() {
            if (this.index >= this.list.size()) {
                throw new NoSuchElementException("Index " + this.index + " is too big for list (size " + this.list.size() + ").");
            }
        }
    }

    private static final class ExitValue
    implements Comparable<ExitValue> {
        private final char threadIndex;
        private final long lockCount;
        private final int stackId;
        private final long timestamp;
        private final long id;
        private final long objectId;

        public ExitValue(char threadIndex, long lockCount, int stackId, long timestamp, long id, long objectId) {
            this.threadIndex = threadIndex;
            this.lockCount = lockCount;
            this.stackId = stackId;
            this.timestamp = timestamp;
            this.id = id;
            this.objectId = objectId;
        }

        public ExitValue(ResourceReader reader) throws IOException {
            this.threadIndex = reader.readUint16();
            this.lockCount = reader.readInt64();
            this.stackId = reader.readInt32();
            this.timestamp = reader.readInt64();
            this.id = reader.readInt64();
            this.objectId = reader.readInt64();
        }

        @Override
        public int compareTo(ExitValue o) {
            return this.lockCount == o.lockCount ? 0 : (this.lockCount > o.lockCount ? 1 : -1);
        }

        public void write(ResourceWriter writer) throws IOException {
            writer.writeUint16(this.threadIndex);
            writer.writeInt64(this.lockCount);
            writer.writeInt32(this.stackId);
            writer.writeInt64(this.timestamp);
            writer.writeInt64(this.id);
            writer.writeInt64(this.objectId);
        }

        public ExitValue forNewTimestamp(long newTimestamp) {
            return new ExitValue(this.threadIndex, this.lockCount, this.stackId, newTimestamp, this.id, this.objectId);
        }
    }
}

