/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.sync.util;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.ThreadInfo;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.impl.resource.RootIterator;
import com.sap.jvm.profiling.snapshot.impl.resource.StackExtractor;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.sync.SynchronizationSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.sync.util.SynchronizationEventIteratorImpl;
import com.sap.jvm.profiling.snapshot.sync.BlockingThreadIterator;
import com.sap.jvm.profiling.snapshot.sync.ReentrantLockObject;
import com.sap.jvm.profiling.snapshot.sync.SynchronizationBlockingEventIterator;
import com.sap.jvm.profiling.snapshot.sync.SynchronizationSnapshot;
import com.sap.jvm.profiling.snapshot.sync.TimeAndCount;
import java.io.IOException;

public final class SynchronizationBlockingEventIteratorImpl
implements SynchronizationBlockingEventIterator,
ValueIterator<TimeAndCount> {
    private final SynchronizationEventIteratorImpl outerIter;
    private BlockingThreadIterator innerIter = null;
    private final ProgressReporter reporter;
    public final StackExtractor extractor;

    private SynchronizationBlockingEventIteratorImpl(SynchronizationSnapshot snapshot, ResourceName name, ProgressReporter reporter, String message) throws IOException {
        this.outerIter = new SynchronizationEventIteratorImpl(name, reporter, message, true);
        this.extractor = this.outerIter.getBlockingStackExtractor();
        this.reporter = reporter;
    }

    public SynchronizationBlockingEventIteratorImpl(SynchronizationSnapshot snapshot, ProgressReporter reporter, String message) throws IOException {
        this(snapshot, snapshot.asResourceName(), reporter, message);
    }

    public SynchronizationBlockingEventIteratorImpl(ResourceName name, ProgressReporter reporter, String message) throws IOException {
        this((SynchronizationSnapshotImpl)SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name), name, reporter, message);
    }

    @Override
    public long getBlockedTime() {
        return this.innerIter.getBlockedTime();
    }

    @Override
    public char getThreadIndex() {
        return this.innerIter.getThread();
    }

    @Override
    public ProfilingReader getEventReader() {
        return this.outerIter.getEventReader();
    }

    @Override
    public ResourceName getResourceName() {
        assert (this.outerIter.getBlockingResourceName() != null);
        return this.outerIter.getBlockingResourceName();
    }

    @Override
    public ThreadInfo getThreadInfo() {
        return this.outerIter.getThreadInfo(this.getThreadIndex());
    }

    @Override
    public int nextOrRead() throws IOException {
        if (this.innerIter != null) {
            if (this.innerIter.next()) {
                return 0;
            }
            this.innerIter = null;
            return 1;
        }
        assert (this.innerIter == null);
        int result = this.outerIter.nextOrRead();
        if (result == 0) {
            if (this.outerIter.getEnteredEvent() != null) {
                this.innerIter = this.outerIter.getBlockingThreadIterator();
            }
            return 1;
        }
        assert (result != 0);
        return result;
    }

    @Override
    public TimeAndCount getEmptyValue() {
        return this.outerIter.getEmptyValue();
    }

    @Override
    public TimeAndCount getValue() {
        assert (this.innerIter != null);
        if (this.innerIter == null) {
            return TimeAndCount.EMPTY;
        }
        return new TimeAndCount(this.getBlockedTime(), 1L);
    }

    @Override
    public boolean next() throws IOException, OperationCanceledException {
        int result;
        while ((result = this.nextOrRead()) != 2) {
            if (result != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getBottomRoot() {
        return this.extractor.getBottomRoot();
    }

    @Override
    public RootIterator getBottomToTopRootIterator() {
        return this.extractor.getBottomToTopRootIterator();
    }

    @Override
    public MethodFilter getInlineFilter() {
        return this.extractor.getInlineFilter();
    }

    @Override
    public ClassObject getInlinedAwayClass() {
        return this.extractor.getInlinedAwayClass();
    }

    @Override
    public ClassLoaderObject getInlinedAwayClassLoader() {
        return this.extractor.getInlinedAwayClassLoader();
    }

    @Override
    public MethodObject getInlinedAwayMethod() {
        return this.extractor.getInlinedAwayMethod();
    }

    @Override
    public PackageName getInlinedAwayPackage() {
        return this.extractor.getInlinedAwayPackage();
    }

    @Override
    public MethodFilter getMethodFilter() {
        return this.extractor.getMethodFilter();
    }

    @Override
    public StackFrames getStack() {
        return this.extractor.getStack();
    }

    @Override
    public int getStackIndex() {
        return this.innerIter.getStackIndex();
    }

    @Override
    public int getTopNonSelfRoot() {
        return this.extractor.getTopNonSelfRoot();
    }

    @Override
    public int getTopSelfRoot() {
        return this.extractor.getTopSelfRoot();
    }

    @Override
    public RootIterator getTopToBottomRootIterator() {
        return this.extractor.getTopToBottomRootIterator();
    }

    @Override
    public boolean hasSelfRoot() {
        return this.extractor.hasSelfRoot();
    }

    @Override
    public boolean isInlinedAwayCalled(int index) {
        return this.extractor.isInlinedAwayCalled(index);
    }

    @Override
    public boolean isInlinedAwayCalling(int index) {
        return this.extractor.isInlinedAwayCalling(index);
    }

    @Override
    public boolean isSelfRoot(int root) {
        return this.extractor.isSelfRoot(root);
    }

    @Override
    public boolean isTopOfStack(int index) {
        return this.extractor.isTopOfStack(index);
    }

    @Override
    public int getTopOfStackIndex() {
        return this.extractor.getTopOfStackIndex();
    }

    public ProfilingSession getSession() {
        return this.outerIter.getSession();
    }

    @Override
    public ResourceName getDependent() {
        return null;
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @Override
    public MonitorObject getMonitorObject() {
        return this.outerIter.getMonitorObject();
    }

    @Override
    public ReentrantLockObject getReentrantLockObject() {
        return this.outerIter.getReentrantLockObject();
    }

    @Override
    public long getId() {
        return this.innerIter.getId();
    }

    @Override
    public ProgressReporter getReporter() {
        return this.reporter;
    }
}

