/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.sync.util;

import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.ThreadInfo;
import com.sap.jvm.profiling.core.event.ObjectIdentificationEvent;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.core.type.ThreadManager;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.elements.SwitchToBlocking;
import com.sap.jvm.profiling.snapshot.filter.MonitorFilter;
import com.sap.jvm.profiling.snapshot.filter.ReentrantLockFilter;
import com.sap.jvm.profiling.snapshot.filter.SynchronizationEventFilter;
import com.sap.jvm.profiling.snapshot.impl.resource.AbstractValueIterator;
import com.sap.jvm.profiling.snapshot.impl.resource.StackExtractor;
import com.sap.jvm.profiling.snapshot.impl.sync.util.BlockingThreadCache;
import com.sap.jvm.profiling.snapshot.impl.sync.util.BlockingThreadCacheIterator;
import com.sap.jvm.profiling.snapshot.impl.sync.util.SynchronizationTraceNameExtractor;
import com.sap.jvm.profiling.snapshot.sync.BlockingThreadIterator;
import com.sap.jvm.profiling.snapshot.sync.Elements;
import com.sap.jvm.profiling.snapshot.sync.ReentrantLockObject;
import com.sap.jvm.profiling.snapshot.sync.SynchronizationEventIterator;
import com.sap.jvm.profiling.snapshot.sync.SynchronizationSnapshot;
import com.sap.jvm.profiling.snapshot.sync.TimeAndCount;
import com.sap.jvm.profiling.sync.event.MonitorEnterEvent;
import com.sap.jvm.profiling.sync.event.MonitorEnteredEvent;
import com.sap.jvm.profiling.sync.event.MonitorExitEvent;
import com.sap.jvm.profiling.sync.event.MonitorNotifyAllEvent;
import com.sap.jvm.profiling.sync.event.MonitorNotifyEvent;
import com.sap.jvm.profiling.sync.event.MonitorWaitEnterEvent;
import com.sap.jvm.profiling.sync.event.MonitorWaitExitEvent;
import com.sap.jvm.profiling.sync.event.ReentrantLockEnterEvent;
import com.sap.jvm.profiling.sync.event.ReentrantLockEnteredEvent;
import com.sap.jvm.profiling.sync.event.ReentrantLockExitEvent;
import com.sap.jvm.profiling.sync.event.SyncEnterEvent;
import com.sap.jvm.profiling.sync.event.SyncEnteredEvent;
import com.sap.jvm.profiling.sync.event.SyncExitEvent;
import com.sap.jvm.profiling.sync.event.SynchronizationEventHandler;
import com.sap.jvm.profiling.sync.response.DisableSynchronizationTraceResponse;
import com.sap.jvm.profiling.sync.response.EnableSynchronizationTraceResponse;
import com.sap.jvm.profiling.util.splitarray.SplitArrayObject;
import java.io.IOException;

public final class SynchronizationEventIteratorImpl
extends AbstractValueIterator<TimeAndCount>
implements SynchronizationEventIterator,
SynchronizationEventHandler {
    private final ProfilingReader reader;
    private final ThreadManager threadManager;
    private BlockingThreadCache blockingThreadCache;
    private SyncEnterEvent currentEnterEvent;
    private SyncEnteredEvent currentEnteredEvent;
    private final ProgressReporter reporter;
    private final ThreadFilter blockedThreadFilter;
    private final ThreadFilter blockingThreadFilter;
    private final MonitorFilter monitorFilter;
    private final ReentrantLockFilter reentrantLockFilter;
    private final SynchronizationEventFilter blockedEventFilter;
    private final SynchronizationEventFilter blockingEventFilter;
    private final StackExtractor blockingExtractor;
    private final ResourceName blockingResourceName;
    private long[] startBlockedTimes;
    private SyncEnterEvent[] enterEvents;
    private boolean[] isBlockedStartBeforeSnapshotEnd;
    private BlockingThreadIterator blockingThreadIterator = null;
    private SyncEnteredEvent cachedEnteredEvent = null;
    private long cachedBlockedTime = -1L;
    private long filteredBlockedTime = -1L;
    private final SplitArrayObject<ClassObject> objectId2ClassObject;
    private int stackIndex = -1;
    private final SynchronizationSnapshot snapshot;
    private long nrOfWaitEvents = 0L;

    public SynchronizationEventIteratorImpl(ResourceName name, ProgressReporter reporter, String message, boolean createBlockingThreadCache) throws IOException {
        super(SynchronizationTraceNameExtractor.getBlockedMethodFilter(name), SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name), reporter);
        this.blockedThreadFilter = SynchronizationTraceNameExtractor.getBlockedThreadFilter(name);
        this.blockingThreadFilter = SynchronizationTraceNameExtractor.getBlockingThreadFilter(name);
        this.monitorFilter = SynchronizationTraceNameExtractor.getMonitorFilter(name);
        this.reentrantLockFilter = SynchronizationTraceNameExtractor.getReentranLockFilter(name);
        this.blockedEventFilter = SynchronizationTraceNameExtractor.getBlockedEventFilter(name);
        this.blockingEventFilter = SynchronizationTraceNameExtractor.getBlockingEventFilter(name);
        if (name.indexOf(SwitchToBlocking.class) == -1) {
            this.blockingResourceName = null;
            this.blockingExtractor = null;
        } else {
            this.blockingResourceName = SynchronizationTraceNameExtractor.getBlockingMethodFilter(name);
            this.blockingExtractor = new StackExtractor(this.blockingResourceName, true);
        }
        this.snapshot = (SynchronizationSnapshot)SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        if (createBlockingThreadCache || this.blockingThreadFilter != null || this.blockingEventFilter != null || this.blockingExtractor != null) {
            ResourceName cacheName = this.snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateBlockingThreadCache());
            this.blockingThreadCache = (BlockingThreadCache)name.getResourceManager().get(cacheName, reporter);
        }
        this.reader = this.getEventReader();
        this.threadManager = this.reader.getThreadManager();
        this.reporter = reporter;
        reporter.setWork(message, this.reader.getNrOfPacketsToRead());
        this.reader.registerSynchronizationEventHandler((SynchronizationEventHandler)this);
        this.startBlockedTimes = new long[32768];
        this.enterEvents = new SyncEnterEvent[32768];
        this.isBlockedStartBeforeSnapshotEnd = new boolean[32768];
        this.objectId2ClassObject = new SplitArrayObject();
    }

    @Override
    protected ResourceName getDependentForIt() {
        return null;
    }

    @Override
    public TimeAndCount getEmptyValue() {
        return TimeAndCount.EMPTY;
    }

    @Override
    public int getStackIndex() {
        return this.stackIndex;
    }

    @Override
    public char getThreadIndex() {
        if (this.getEnterEvent() != null) {
            return this.getEnterEvent().getThreadIndex();
        }
        return this.getEnteredEvent().getThreadIndex();
    }

    @Override
    public TimeAndCount getValue() {
        long nrOfCounts = this.getEnterEvent() == null ? 0L : this.getBlockCount();
        long duration = this.getEnteredEvent() == null ? 0L : this.getBlockedTime();
        return new TimeAndCount(duration, nrOfCounts);
    }

    @Override
    protected boolean nextFromStatistic() throws OperationCanceledException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int nextOrReadRaw() throws IOException {
        this.currentEnterEvent = null;
        this.currentEnteredEvent = null;
        this.blockingThreadIterator = null;
        this.filteredBlockedTime = -1L;
        if (this.cachedEnteredEvent != null) {
            this.currentEnteredEvent = this.cachedEnteredEvent;
            this.cachedEnteredEvent = null;
            this.filteredBlockedTime = this.cachedBlockedTime;
            this.cachedBlockedTime = -1L;
            return 0;
        }
        try {
            if (this.reader.nextPacket() != null) {
                ThreadInfo threadInfo;
                this.reporter.reportNextOrThrow();
                if (this.currentEnterEvent == null && this.currentEnteredEvent == null) {
                    return 1;
                }
                if (this.currentEnterEvent != null) {
                    this.currentEnterEvent = null;
                    this.currentEnteredEvent = null;
                    return 1;
                }
                assert (this.currentEnteredEvent != null);
                if (this.blockedThreadFilter != null && !this.blockedThreadFilter.applies(threadInfo = this.threadManager.getThreadInfo(this.currentEnteredEvent.getThreadIndex()))) {
                    this.currentEnterEvent = null;
                    this.currentEnteredEvent = null;
                    return 1;
                }
                MonitorObject monitor2 = this.getMonitorObject();
                if (monitor2 != null && (this.reentrantLockFilter != null || this.monitorFilter != null && !this.monitorFilter.matches(monitor2))) {
                    this.currentEnterEvent = null;
                    this.currentEnteredEvent = null;
                    return 1;
                }
                ReentrantLockObject lock = this.getReentrantLockObject();
                if (lock != null && (this.monitorFilter != null || this.reentrantLockFilter != null && !this.reentrantLockFilter.matches(lock))) {
                    this.currentEnterEvent = null;
                    this.currentEnteredEvent = null;
                    return 1;
                }
                SyncEnterEvent enterEvent = this.enterEvents[this.currentEnteredEvent.getThreadIndex()];
                long blockedTime = -1L;
                if (enterEvent != null) {
                    if (!this.isBlockedStartBeforeSnapshotEnd[this.currentEnteredEvent.getThreadIndex()] || !this.snapshot.isAfterSnapshotStart(this.reader)) {
                        this.currentEnterEvent = null;
                        this.currentEnteredEvent = null;
                        return 1;
                    }
                    this.stackIndex = enterEvent.getStackTraceIndex();
                    if (this.stackIndex == -1) {
                        this.currentEnterEvent = null;
                        this.currentEnteredEvent = null;
                        return 1;
                    }
                    if (this.blockedEventFilter != null && !this.blockedEventFilter.matches(enterEvent.getId())) {
                        this.currentEnterEvent = null;
                        this.currentEnteredEvent = null;
                        return 1;
                    }
                    if (this.blockingThreadFilter != null || this.blockingEventFilter != null || this.blockingExtractor != null) {
                        BlockingThreadIterator blockingIter = this.getBlockingThreadIterator();
                        boolean found = false;
                        blockedTime = 0L;
                        while (blockingIter.next()) {
                            assert ((this.blockingThreadFilter == null || this.blockingThreadFilter.applies(this.getThreadInfo(blockingIter.getThread()))) && (this.blockingEventFilter == null || this.blockingEventFilter.matches(blockingIter.getId())));
                            found = true;
                            blockedTime += blockingIter.getBlockedTime();
                        }
                        if (!found) {
                            this.currentEnterEvent = null;
                            this.currentEnteredEvent = null;
                            return 1;
                        }
                    }
                } else {
                    this.currentEnterEvent = null;
                    this.currentEnteredEvent = null;
                    return 1;
                }
                assert (this.cachedEnteredEvent == null);
                this.cachedEnteredEvent = this.currentEnteredEvent;
                assert (this.cachedBlockedTime == -1L);
                this.cachedBlockedTime = blockedTime;
                this.currentEnteredEvent = null;
                assert (this.currentEnterEvent == null);
                this.currentEnterEvent = enterEvent;
                return 0;
            }
        }
        catch (IOException ex) {
            this.reader.close();
            throw ex;
        }
        this.reader.close();
        return 2;
    }

    @Override
    public long getBlockCount() {
        return 1L;
    }

    @Override
    public StackFrames getBlockedThreadStackFrames() {
        return this.getStack();
    }

    @Override
    public long getBlockedTime() {
        if (this.currentEnteredEvent == null) {
            return 0L;
        }
        long startBlockedTime = this.startBlockedTimes[this.currentEnteredEvent.getThreadIndex()];
        if (startBlockedTime == 0L) {
            return 0L;
        }
        if (this.filteredBlockedTime != -1L) {
            return this.filteredBlockedTime;
        }
        return this.currentEnteredEvent.getTimeStamp() - this.currentEnteredEvent.getCumulatedSafepointTime() - startBlockedTime;
    }

    @Override
    public BlockingThreadIterator getBlockingThreadIterator() {
        this.blockingThreadIterator = new BlockingThreadIteratorImpl();
        return this.blockingThreadIterator;
    }

    @Override
    public SyncEnterEvent getEnterEvent() {
        return this.currentEnterEvent;
    }

    @Override
    public SyncEnteredEvent getEnteredEvent() {
        return this.currentEnteredEvent;
    }

    @Override
    public MonitorObject getMonitorObject() {
        long objectId;
        if (!(this.currentEnterEvent instanceof MonitorEnterEvent) && !(this.currentEnteredEvent instanceof MonitorEnteredEvent)) {
            return null;
        }
        if (this.currentEnterEvent != null) {
            objectId = this.currentEnterEvent.getObjectId();
        } else {
            assert (this.currentEnteredEvent != null);
            SyncEnterEvent enterEvent = this.enterEvents[this.currentEnteredEvent.getThreadIndex()];
            if (enterEvent != null) {
                objectId = enterEvent.getObjectId();
            } else {
                return null;
            }
        }
        assert (objectId <= Integer.MAX_VALUE);
        if (objectId >= (long)this.objectId2ClassObject.size()) {
            return null;
        }
        ClassObject clazz = (ClassObject)this.objectId2ClassObject.get((int)objectId);
        if (clazz == null) {
            return null;
        }
        return new MonitorObject(objectId, clazz);
    }

    @Override
    public ReentrantLockObject getReentrantLockObject() {
        if (!(this.currentEnterEvent instanceof ReentrantLockEnterEvent) && !(this.currentEnteredEvent instanceof ReentrantLockEnteredEvent)) {
            return null;
        }
        if (this.currentEnterEvent != null) {
            return new ReentrantLockObject(this.currentEnterEvent.getObjectId());
        }
        assert (this.currentEnteredEvent != null);
        SyncEnterEvent enterEvent = this.enterEvents[this.currentEnteredEvent.getThreadIndex()];
        if (enterEvent != null) {
            return new ReentrantLockObject(enterEvent.getObjectId());
        }
        return null;
    }

    @Override
    public ThreadInfo getThreadInfo(char threadIndex) {
        return this.threadManager.getThreadInfo(threadIndex);
    }

    public void handle(DisableSynchronizationTraceResponse response) {
    }

    public void handle(EnableSynchronizationTraceResponse response) {
    }

    public void handle(MonitorEnterEvent event) {
        this.handleImpl((SyncEnterEvent)event);
    }

    private void handleImpl(SyncEnterEvent event) {
        this.currentEnterEvent = event;
        this.startBlockedTimes[event.getThreadIndex()] = event.getTimeStamp() - event.getCumulatedSafepointTime();
        this.enterEvents[event.getThreadIndex()] = event;
        this.isBlockedStartBeforeSnapshotEnd[event.getThreadIndex()] = this.snapshot.isBeforeSnapshotEnd(this.reader);
    }

    public void handle(MonitorEnteredEvent event) {
        this.handleImpl((SyncEnteredEvent)event);
    }

    private void handleImpl(SyncEnteredEvent event) {
        this.currentEnteredEvent = event;
    }

    public void handle(MonitorWaitEnterEvent event) {
        ++this.nrOfWaitEvents;
    }

    public void handle(MonitorWaitExitEvent event) {
    }

    public void handle(MonitorExitEvent event) {
        this.handleImpl((SyncExitEvent)event);
    }

    private void handleImpl(SyncExitEvent event) {
        this.startBlockedTimes[event.getThreadIndex()] = 0L;
        this.enterEvents[event.getThreadIndex()] = null;
        this.isBlockedStartBeforeSnapshotEnd[event.getThreadIndex()] = false;
    }

    public void handle(MonitorNotifyEvent event) {
    }

    public void handle(MonitorNotifyAllEvent event) {
    }

    public void handle(ObjectIdentificationEvent event) {
        long objectId = event.getObjectId();
        assert (objectId <= Integer.MAX_VALUE);
        assert (objectId >= (long)this.objectId2ClassObject.size() || this.objectId2ClassObject.get((int)objectId) == null);
        if (objectId >= (long)this.objectId2ClassObject.size()) {
            this.objectId2ClassObject.resize((int)(objectId + 1L));
        }
        assert (objectId < (long)this.objectId2ClassObject.size());
        this.objectId2ClassObject.set((int)objectId, (Object)event.getClassObject());
    }

    public void handle(ReentrantLockEnterEvent event) {
        this.handleImpl((SyncEnterEvent)event);
    }

    public void handle(ReentrantLockEnteredEvent event) {
        this.handleImpl((SyncEnteredEvent)event);
    }

    public void handle(ReentrantLockExitEvent event) {
        this.handleImpl((SyncExitEvent)event);
    }

    public long getWaitCount() {
        return this.nrOfWaitEvents;
    }

    public StackExtractor getBlockingStackExtractor() {
        return this.blockingExtractor;
    }

    public ResourceName getBlockingResourceName() {
        return this.blockingResourceName;
    }

    @Override
    public ProgressReporter getReporter() {
        return this.reporter;
    }

    private final class BlockingThreadIteratorImpl
    implements BlockingThreadIterator {
        private final BlockingThreadCacheIterator iter;

        private BlockingThreadIteratorImpl() {
            assert (SynchronizationEventIteratorImpl.this.currentEnteredEvent != null);
            char threadIndex = SynchronizationEventIteratorImpl.this.currentEnteredEvent.getThreadIndex();
            long startBlockedTime = SynchronizationEventIteratorImpl.this.startBlockedTimes[threadIndex];
            long endBlockedTime = SynchronizationEventIteratorImpl.this.currentEnteredEvent.getTimeStamp() - SynchronizationEventIteratorImpl.this.currentEnteredEvent.getCumulatedSafepointTime();
            long objectId = SynchronizationEventIteratorImpl.this.enterEvents[threadIndex].getObjectId();
            char blockerThread = SynchronizationEventIteratorImpl.this.enterEvents[threadIndex].getBlockerThreadIndex();
            long lockCountBefore = SynchronizationEventIteratorImpl.this.enterEvents[threadIndex].getLockCount();
            this.iter = SynchronizationEventIteratorImpl.this.blockingThreadCache.iterator(objectId, startBlockedTime, endBlockedTime, blockerThread, lockCountBefore, SynchronizationEventIteratorImpl.this.currentEnteredEvent);
        }

        @Override
        public boolean next() {
            this.checkValidity();
            if (SynchronizationEventIteratorImpl.this.blockingThreadFilter == null && SynchronizationEventIteratorImpl.this.blockingEventFilter == null && SynchronizationEventIteratorImpl.this.blockingExtractor == null) {
                return this.iter.next();
            }
            while (this.iter.next()) {
                if (SynchronizationEventIteratorImpl.this.blockingEventFilter != null && !SynchronizationEventIteratorImpl.this.blockingEventFilter.matches(this.iter.getId()) || SynchronizationEventIteratorImpl.this.blockingThreadFilter != null && !SynchronizationEventIteratorImpl.this.blockingThreadFilter.applies(SynchronizationEventIteratorImpl.this.getThreadInfo(this.iter.getThread())) || SynchronizationEventIteratorImpl.this.blockingExtractor != null && !SynchronizationEventIteratorImpl.this.blockingExtractor.setStack(this.getStackIndex())) continue;
                return true;
            }
            return false;
        }

        @Override
        public char getThread() {
            this.checkValidity();
            return this.iter.getThread();
        }

        @Override
        public long getBlockedTime() {
            this.checkValidity();
            return this.iter.getBlockedTime();
        }

        @Override
        public int getStackIndex() {
            this.checkValidity();
            return this.iter.getStackTraceIndex();
        }

        @Override
        public long getId() {
            this.checkValidity();
            return this.iter.getId();
        }

        private void checkValidity() {
            if (SynchronizationEventIteratorImpl.this.blockingThreadIterator != this) {
                throw new IllegalStateException("Iterator not valid anymore.");
            }
        }
    }
}

