/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.sync.util;

import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.BlockedEventFilterElement;
import com.sap.jvm.profiling.snapshot.elements.BlockedThreadFilterElement;
import com.sap.jvm.profiling.snapshot.elements.BlockingEventFilterElement;
import com.sap.jvm.profiling.snapshot.elements.BlockingThreadFilterElement;
import com.sap.jvm.profiling.snapshot.elements.MonitorFilterElement;
import com.sap.jvm.profiling.snapshot.elements.ReentrantLockFilterElement;
import com.sap.jvm.profiling.snapshot.elements.SwitchToBlocked;
import com.sap.jvm.profiling.snapshot.elements.SwitchToBlocking;
import com.sap.jvm.profiling.snapshot.filter.MonitorFilter;
import com.sap.jvm.profiling.snapshot.filter.ReentrantLockFilter;
import com.sap.jvm.profiling.snapshot.filter.SynchronizationEventFilter;

public final class SynchronizationTraceNameExtractor {
    public static ThreadFilter getBlockedThreadFilter(ResourceName name) {
        ThreadFilter filter = null;
        for (ResourceNameElement element : name.getElements()) {
            if (!(element instanceof BlockedThreadFilterElement)) continue;
            BlockedThreadFilterElement filterElement = (BlockedThreadFilterElement)element;
            if (filter == null) {
                filter = filterElement.getFilter();
                continue;
            }
            filter = filter.copy();
            filter.narrow(filterElement.getFilter());
        }
        return filter;
    }

    public static ThreadFilter getBlockingThreadFilter(ResourceName name) {
        ThreadFilter filter = null;
        for (ResourceNameElement element : name.getElements()) {
            if (!(element instanceof BlockingThreadFilterElement)) continue;
            BlockingThreadFilterElement filterElement = (BlockingThreadFilterElement)element;
            if (filter == null) {
                filter = filterElement.getFilter();
                continue;
            }
            filter = filter.copy();
            filter.narrow(filterElement.getFilter());
        }
        return filter;
    }

    public static MonitorFilter getMonitorFilter(ResourceName name) {
        MonitorFilter filter = null;
        for (ResourceNameElement element : name.getElements()) {
            if (!(element instanceof MonitorFilterElement)) continue;
            MonitorFilterElement filterElement = (MonitorFilterElement)element;
            filter = filter == null ? filterElement.getFilter() : filter.narrow(filterElement.getFilter());
        }
        return filter;
    }

    public static ReentrantLockFilter getReentranLockFilter(ResourceName name) {
        ReentrantLockFilter filter = null;
        for (ResourceNameElement element : name.getElements()) {
            if (!(element instanceof ReentrantLockFilterElement)) continue;
            ReentrantLockFilterElement filterElement = (ReentrantLockFilterElement)element;
            filter = filter == null ? filterElement.getFilter() : filter.narrow(filterElement.getFilter());
        }
        return filter;
    }

    public static SynchronizationEventFilter getBlockedEventFilter(ResourceName name) {
        SynchronizationEventFilter filter = null;
        for (ResourceNameElement element : name.getElements()) {
            if (!(element instanceof BlockedEventFilterElement)) continue;
            BlockedEventFilterElement filterElement = (BlockedEventFilterElement)element;
            filter = filter == null ? filterElement.getFilter() : filter.narrow(filterElement.getFilter());
        }
        return filter;
    }

    public static SynchronizationEventFilter getBlockingEventFilter(ResourceName name) {
        SynchronizationEventFilter filter = null;
        for (ResourceNameElement element : name.getElements()) {
            if (!(element instanceof BlockingEventFilterElement)) continue;
            BlockingEventFilterElement filterElement = (BlockingEventFilterElement)element;
            filter = filter == null ? filterElement.getFilter() : filter.narrow(filterElement.getFilter());
        }
        return filter;
    }

    public static ResourceName getBlockedMethodFilter(ResourceName name) {
        return SynchronizationTraceNameExtractor.getMethodFilter(name, true);
    }

    public static ResourceName getBlockingMethodFilter(ResourceName name) {
        return SynchronizationTraceNameExtractor.getMethodFilter(name, false);
    }

    private static ResourceName getMethodFilter(ResourceName name, boolean blocked) {
        ResourceName result = null;
        boolean start = true;
        boolean isBlocked = false;
        for (ResourceNameElement element : name.getElements()) {
            if (element instanceof SwitchToBlocked) {
                isBlocked = true;
                start = false;
            }
            if (element instanceof SwitchToBlocking) {
                isBlocked = false;
                start = false;
            }
            if (!start && (!blocked || !isBlocked) && (blocked || isBlocked)) continue;
            result = result == null ? name.getResourceManager().createResourceName(element) : result.addElement(element);
        }
        return result;
    }
}

