/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.sync.util;

import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.event.ObjectIdentificationEvent;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.filter.MonitorFilter;
import com.sap.jvm.profiling.snapshot.impl.resource.AbstractValueIterator;
import com.sap.jvm.profiling.snapshot.impl.sync.SynchronizationSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.sync.util.SynchronizationTraceNameExtractor;
import com.sap.jvm.profiling.snapshot.sync.SynchronizationSnapshot;
import com.sap.jvm.profiling.snapshot.sync.SynchronizationWaitEventIterator;
import com.sap.jvm.profiling.snapshot.sync.TimeAndCount;
import com.sap.jvm.profiling.sync.event.MonitorEnterEvent;
import com.sap.jvm.profiling.sync.event.MonitorEnteredEvent;
import com.sap.jvm.profiling.sync.event.MonitorExitEvent;
import com.sap.jvm.profiling.sync.event.MonitorNotifyAllEvent;
import com.sap.jvm.profiling.sync.event.MonitorNotifyEvent;
import com.sap.jvm.profiling.sync.event.MonitorWaitEnterEvent;
import com.sap.jvm.profiling.sync.event.MonitorWaitExitEvent;
import com.sap.jvm.profiling.sync.event.ReentrantLockEnterEvent;
import com.sap.jvm.profiling.sync.event.ReentrantLockEnteredEvent;
import com.sap.jvm.profiling.sync.event.ReentrantLockExitEvent;
import com.sap.jvm.profiling.sync.event.SynchronizationEventHandler;
import com.sap.jvm.profiling.sync.response.DisableSynchronizationTraceResponse;
import com.sap.jvm.profiling.sync.response.EnableSynchronizationTraceResponse;
import com.sap.jvm.profiling.util.splitarray.SplitArrayObject;
import java.io.IOException;

public final class SynchronizationWaitEventIteratorImpl
extends AbstractValueIterator<TimeAndCount>
implements SynchronizationWaitEventIterator,
SynchronizationEventHandler {
    private final ProfilingReader reader = this.getEventReader();
    private MonitorWaitEnterEvent currentWaitEnterEvent;
    private MonitorWaitExitEvent currentWaitExitEvent;
    private final ProgressReporter reporter;
    private long[] startWaitTimes;
    private MonitorWaitEnterEvent[] waitingEnterEvents;
    private boolean[] isWaitStartBeforeSnapshotEnd;
    private MonitorWaitExitEvent cachedWaitExitEvent = null;
    private int stackIndex = -1;
    private final MonitorFilter monitorFilter;
    private final SplitArrayObject<ClassObject> objectId2ClassObject;
    private final long[] objectIds;
    private final SynchronizationSnapshot snapshot;

    private SynchronizationWaitEventIteratorImpl(SynchronizationSnapshot snapshot, ResourceName name, ProgressReporter reporter, String message) throws OperationCanceledException {
        super(name, snapshot, reporter);
        this.snapshot = snapshot;
        this.reporter = reporter;
        reporter.setWork(message, this.reader.getNrOfPacketsToRead());
        this.reader.registerSynchronizationEventHandler((SynchronizationEventHandler)this);
        this.startWaitTimes = new long[32768];
        this.waitingEnterEvents = new MonitorWaitEnterEvent[32768];
        this.objectIds = new long[32768];
        this.isWaitStartBeforeSnapshotEnd = new boolean[32768];
        for (int i = 0; i < this.waitingEnterEvents.length; ++i) {
            this.waitingEnterEvents[i] = null;
            this.startWaitTimes[i] = -1L;
            this.objectIds[i] = -1L;
            this.isWaitStartBeforeSnapshotEnd[i] = false;
        }
        this.monitorFilter = SynchronizationTraceNameExtractor.getMonitorFilter(name);
        this.objectId2ClassObject = this.monitorFilter != null ? new SplitArrayObject() : null;
    }

    public SynchronizationWaitEventIteratorImpl(SynchronizationSnapshot snapshot, ProgressReporter reporter, String message) throws OperationCanceledException {
        this(snapshot, snapshot.asResourceName(), reporter, message);
    }

    public SynchronizationWaitEventIteratorImpl(ResourceName name, ProgressReporter reporter, String message) throws OperationCanceledException {
        this((SynchronizationSnapshotImpl)SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name), reporter, message);
    }

    @Override
    protected ResourceName getDependentForIt() {
        return null;
    }

    @Override
    public TimeAndCount getEmptyValue() {
        return TimeAndCount.EMPTY;
    }

    @Override
    public int getStackIndex() {
        return this.stackIndex;
    }

    @Override
    public char getThreadIndex() {
        if (this.getMonitorWaitEnterEvent() != null) {
            return this.getMonitorWaitEnterEvent().getThreadIndex();
        }
        return this.getMonitorWaitExitEvent().getThreadIndex();
    }

    @Override
    public TimeAndCount getValue() {
        long nrOfCounts = this.getMonitorWaitEnterEvent() == null ? 0L : 1L;
        long duration = this.getMonitorWaitExitEvent() == null ? 0L : this.getDuration();
        return new TimeAndCount(duration, nrOfCounts);
    }

    @Override
    protected boolean nextFromStatistic() throws OperationCanceledException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int nextOrReadRaw() throws IOException {
        this.currentWaitEnterEvent = null;
        this.currentWaitExitEvent = null;
        if (this.cachedWaitExitEvent != null) {
            this.currentWaitExitEvent = this.cachedWaitExitEvent;
            this.cachedWaitExitEvent = null;
            this.stackIndex = this.waitingEnterEvents[this.currentWaitExitEvent.getThreadIndex()].getStackTraceIndex();
            return 0;
        }
        try {
            if (this.reader.nextPacket() != null) {
                if (!this.reporter.report(this.reader.getNrOfReadPackets())) {
                    throw new OperationCanceledException();
                }
                if (this.currentWaitEnterEvent == null && this.currentWaitExitEvent == null) {
                    return 1;
                }
                if (this.monitorFilter != null && !this.monitorFilter.matches(this.getMonitorObject())) {
                    this.currentWaitEnterEvent = null;
                    this.currentWaitExitEvent = null;
                    return 1;
                }
                if (this.currentWaitEnterEvent != null) {
                    this.currentWaitEnterEvent = null;
                    this.currentWaitExitEvent = null;
                    return 1;
                }
                assert (this.currentWaitExitEvent != null && this.currentWaitEnterEvent == null);
                char threadIndex = this.currentWaitExitEvent.getThreadIndex();
                this.currentWaitEnterEvent = this.waitingEnterEvents[threadIndex];
                if (this.currentWaitEnterEvent == null || this.currentWaitEnterEvent.getStackTraceIndex() == -1 || !this.isWaitStartBeforeSnapshotEnd[threadIndex] || !this.snapshot.isAfterSnapshotStart(this.reader)) {
                    this.currentWaitEnterEvent = null;
                    this.currentWaitExitEvent = null;
                    return 1;
                }
                this.cachedWaitExitEvent = this.currentWaitExitEvent;
                this.currentWaitExitEvent = null;
                this.stackIndex = this.currentWaitEnterEvent.getStackTraceIndex();
                return 0;
            }
        }
        catch (IOException ex) {
            this.reader.close();
            throw ex;
        }
        this.reader.close();
        return 2;
    }

    @Override
    public long getDuration() {
        if (this.currentWaitExitEvent == null) {
            return 0L;
        }
        long startWaitTime = this.startWaitTimes[this.currentWaitExitEvent.getThreadIndex()];
        if (startWaitTime == -1L) {
            return 0L;
        }
        return Math.max(0L, this.currentWaitExitEvent.getTimeStamp() - this.currentWaitExitEvent.getCumulatedSafepointTime() - startWaitTime);
    }

    @Override
    public MonitorWaitEnterEvent getMonitorWaitEnterEvent() {
        return this.currentWaitEnterEvent;
    }

    @Override
    public MonitorWaitExitEvent getMonitorWaitExitEvent() {
        return this.currentWaitExitEvent;
    }

    public void handle(EnableSynchronizationTraceResponse response) {
    }

    public void handle(DisableSynchronizationTraceResponse response) {
    }

    public void handle(MonitorWaitEnterEvent event) {
        this.currentWaitEnterEvent = event;
        this.startWaitTimes[event.getThreadIndex()] = event.getTimeStamp() - event.getCumulatedSafepointTime();
        this.waitingEnterEvents[event.getThreadIndex()] = event;
        this.objectIds[event.getThreadIndex()] = event.getObjectId();
        this.isWaitStartBeforeSnapshotEnd[event.getThreadIndex()] = this.snapshot.isBeforeSnapshotEnd(this.reader);
    }

    public void handle(MonitorWaitExitEvent event) {
        this.currentWaitExitEvent = event;
    }

    public void handle(MonitorEnterEvent event) {
    }

    public void handle(MonitorEnteredEvent event) {
    }

    public void handle(MonitorExitEvent event) {
    }

    public void handle(MonitorNotifyEvent event) {
    }

    public void handle(MonitorNotifyAllEvent event) {
    }

    public void handle(ObjectIdentificationEvent event) {
        if (this.objectId2ClassObject != null) {
            long objectId = event.getObjectId();
            assert (objectId <= Integer.MAX_VALUE);
            assert (objectId >= (long)this.objectId2ClassObject.size() || this.objectId2ClassObject.get((int)objectId) == null);
            if (objectId >= (long)this.objectId2ClassObject.size()) {
                this.objectId2ClassObject.resize((int)(objectId + 1L));
            }
            assert (objectId < (long)this.objectId2ClassObject.size());
            this.objectId2ClassObject.set((int)objectId, (Object)event.getClassObject());
        }
    }

    public void handle(ReentrantLockEnterEvent event) {
    }

    public void handle(ReentrantLockEnteredEvent event) {
    }

    public void handle(ReentrantLockExitEvent event) {
    }

    private MonitorObject getMonitorObject() {
        long objectId;
        if (this.currentWaitEnterEvent != null) {
            objectId = this.currentWaitEnterEvent.getObjectId();
        } else {
            assert (this.currentWaitExitEvent != null);
            objectId = this.objectIds[this.currentWaitExitEvent.getThreadIndex()];
            if (objectId == -1L) {
                return null;
            }
        }
        assert (objectId <= Integer.MAX_VALUE);
        if (objectId >= (long)this.objectId2ClassObject.size()) {
            return null;
        }
        ClassObject clazz = (ClassObject)this.objectId2ClassObject.get((int)objectId);
        if (clazz == null) {
            return null;
        }
        return new MonitorObject(objectId, clazz);
    }

    @Override
    public ProgressReporter getReporter() {
        return this.reporter;
    }
}

