/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.tbs;

import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.tbs.PerformanceValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.MethodColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.TimeAndDistColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.creator.CalledMethodStatisticCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.TimeAndDistSerializer;
import com.sap.jvm.profiling.snapshot.tbs.CalledMethodStatistic;
import com.sap.jvm.profiling.snapshot.tbs.TimeAndDist;
import java.io.IOException;

public class CalledMethodStatisticImpl
extends SelfAndTotalValueStatisticImpl<MethodObject, TimeAndDist>
implements CalledMethodStatistic {
    protected CalledMethodStatisticImpl(ResourceName name) {
        super(name, new MethodColumn(name.getSession()), new TimeAndDistColumnImpl(), new TimeAndDistColumnImpl(), new TimeAndDistSerializer());
    }

    public CalledMethodStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the method statistic ... (<%> %)"), reporter);
    }

    public static CalledMethodStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        PerformanceValueIterator[] its = PerformanceValueIterator.getIterators(name, reporter, I18n._s((String)"Creating the method statistic ... (<%> %)"), false);
        CalledMethodStatisticImpl result = new CalledMethodStatisticImpl(name);
        new CalledMethodStatisticCreator<TimeAndDist>().fillInStatistic(result, its);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the method statistic ... (<%> %)"), reporter);
    }
}

