/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.tbs;

import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.tbs.PerformanceValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueTreeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueTreeNodeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.Pruner;
import com.sap.jvm.profiling.snapshot.impl.util.creator.CalledMethodTreeCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.MethodLocationSerializer;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.TimeAndDistSerializer;
import com.sap.jvm.profiling.snapshot.tbs.CalledMethodTree;
import com.sap.jvm.profiling.snapshot.tbs.TimeAndDist;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueTreeNode;
import java.io.IOException;

public class CalledMethodTreeImpl
extends SelfAndTotalValueTreeImpl<MethodLocation, TimeAndDist>
implements CalledMethodTree {
    protected CalledMethodTreeImpl(ResourceName name) {
        super(name, new MethodLocationSerializer(), new TimeAndDistSerializer());
    }

    public CalledMethodTreeImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, reporter, I18n._s((String)"Reading the method tree ... (<%> %)"));
    }

    public static CalledMethodTreeImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        PerformanceValueIterator[] its = PerformanceValueIterator.getIterators(name, reporter, I18n._s((String)"Creating the method tree ... (<%> %)"), false);
        CalledMethodTreeImpl tree = new CalledMethodTreeImpl(name);
        new CalledMethodTreeCreator<TimeAndDist>().fillIn(tree, new TreePruner(), its);
        return tree;
    }

    @Override
    public void createChildren(SelfAndTotalValueTreeNode<MethodLocation, TimeAndDist> node, ProgressReporter reporter) throws IOException {
        assert (node.hasChildren());
        assert (!node.hasCreatedChildren());
        PerformanceValueIterator[] its = PerformanceValueIterator.getIterators(this.getResourceName(), reporter, I18n._s((String)"Creating the children ... (<%> %)"), false);
        new CalledMethodTreeCreator<TimeAndDist>().setChildren(new TreePruner(), (SelfAndTotalValueTreeNodeImpl)node, its);
    }

    @Override
    public void createSubNodes(SelfAndTotalValueTreeNode<MethodLocation, TimeAndDist> node, ProgressReporter reporter) throws IOException {
        assert (node.hasSubNodes());
        assert (!node.hasCreatedSubNodes());
        PerformanceValueIterator[] its = PerformanceValueIterator.getIterators(this.getResourceName(), reporter, I18n._s((String)"Creating the children ... (<%> %)"), false);
        new CalledMethodTreeCreator<TimeAndDist>().setSubNodes(new TreePruner(), (SelfAndTotalValueTreeNodeImpl)node, its);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        super.write(writer, reporter, I18n._s((String)"Writing the method tree ... (<%> %)"));
    }

    public static class TreePruner
    implements Pruner<TimeAndDist> {
        @Override
        public boolean shouldPrune(TimeAndDist value, TimeAndDist parentValue, TimeAndDist totalValue) {
            long relativeTime;
            long nodeTime = value.getMaxTime();
            double fraction = 1.0E-4;
            if (fraction * (double)totalValue.getMaxTime() >= (double)nodeTime) {
                return true;
            }
            long parentTime = parentValue.getMaxTime();
            return parentTime >= (relativeTime = nodeTime << 7);
        }
    }
}

