/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.tbs;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingEvent;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingEventHandler;
import com.sap.jvm.profiling.method.response.DisableTimeBasedSamplingMptResponse;
import com.sap.jvm.profiling.method.response.DisableTimeBasedSamplingResponse;
import com.sap.jvm.profiling.method.response.EnableTimeBasedSamplingMptResponse;
import com.sap.jvm.profiling.method.response.EnableTimeBasedSamplingResponse;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.snapshot.impl.tbs.PerformanceValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.series.AbstractValueTimeSeriesCollection;
import com.sap.jvm.profiling.snapshot.tbs.CalledTimeSeriesCollection;
import com.sap.jvm.profiling.snapshot.tbs.TimeAndDist;
import com.sap.jvm.profiling.snapshot.tbs.TimeDist;
import java.io.IOException;

public class CalledTimeSeriesCollectionImpl
extends AbstractValueTimeSeriesCollection<TimeAndDist>
implements CalledTimeSeriesCollection,
TimeBasedSamplingEventHandler {
    private long timeOffset = 0L;
    private long sampleCount = 0L;

    public CalledTimeSeriesCollectionImpl(ResourceName name) throws IOException {
        super(name);
    }

    public CalledTimeSeriesCollectionImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        super(name, reader, reporter, I18n._s((String)"Reading the time series ... (<%> %)"));
    }

    public static CalledTimeSeriesCollectionImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        CalledTimeSeriesCollectionImpl result = new CalledTimeSeriesCollectionImpl(name);
        PerformanceValueIterator it = PerformanceValueIterator.getEventIterator(name, reporter, I18n._s((String)"Creating the time series ... (<%> %)"));
        it.getEventReader().registerTimeBasedSamplingEventHandler((TimeBasedSamplingEventHandler)result);
        result.createTimeSeries(it);
        return result;
    }

    @Override
    protected boolean isHeartBeatBased(int index) {
        return index != 0;
    }

    @Override
    protected void getValuesForValue(long[] values, long elapsed, TimeAndDist value) {
        values[1] = this.sampleCount * 1000L / elapsed;
        this.sampleCount = 0L;
        values[2] = value.getCpuTime() * 1000L / elapsed;
        values[3] = value.getTime() * 1000L / elapsed;
        this.getTimeRatios(values, value.getCpuTimeDistribution(), 4, 5, 6, 7);
        this.getTimeRatios(values, value.getCpuTimeDistribution(), 8, 9, 10, 11);
    }

    private void getTimeRatios(long[] values, TimeDist distribution, int interpretedIndex, int compiledIndex, int inlinedIndex, int nativeIndex) {
        long nativeTime;
        long inlinedTime;
        long compiledTime;
        long interpretedTime = distribution.getInterpreterTime();
        long total = interpretedTime + (compiledTime = distribution.getCompiledTier1Time() + distribution.getCompiledTime()) + (inlinedTime = distribution.getInlinedTier1Time() + distribution.getInlinedTime()) + (nativeTime = distribution.getNativeCompiledTier1Time() + distribution.getNativeCompiledTime() + distribution.getNativeInlinedTier1Time() + distribution.getNativeInlinedTime() + distribution.getNativeInterpreterTime());
        if (total == 0L) {
            total = 1L;
        }
        values[interpretedIndex] = interpretedTime * 100000L / total;
        values[compiledIndex] = compiledTime * 100000L / total;
        values[inlinedIndex] = inlinedTime * 100000L / total;
        values[nativeIndex] = nativeTime * 100000L / total;
    }

    public void handle(EnableTimeBasedSamplingResponse response) {
    }

    public void handle(DisableTimeBasedSamplingResponse response) {
    }

    public void handle(EnableTimeBasedSamplingMptResponse response) {
    }

    public void handle(DisableTimeBasedSamplingMptResponse response) {
    }

    public void handle(TimeBasedSamplingEvent event) {
        try {
            if (this.timeOffset == 0L) {
                if (this.getFirstHeartBeat() == -1L) {
                    return;
                }
                long ts = (this.getFirstHeartBeat() - this.getProfilingStart()) * 1000L;
                this.timeOffset = ts - event.getTimeStamp() / 1000L;
            }
            this.builders[0].add(this.timeOffset + event.getTimeStamp() / 1000L, event.getElapsedTime());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ++this.sampleCount;
    }
}

