/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.tbs;

import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.tbs.CalledMethodTreeImpl;
import com.sap.jvm.profiling.snapshot.impl.tbs.PerformanceValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueTreeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueTreeNodeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.creator.CallingMethodTreeCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.MethodLocationSerializer;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.TimeAndDistSerializer;
import com.sap.jvm.profiling.snapshot.tbs.CallingMethodTree;
import com.sap.jvm.profiling.snapshot.tbs.TimeAndDist;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueTreeNode;
import java.io.IOException;

public class CallingMethodTreeImpl
extends SelfAndTotalValueTreeImpl<MethodLocation, TimeAndDist>
implements CallingMethodTree {
    protected CallingMethodTreeImpl(ResourceName name) {
        super(name, new MethodLocationSerializer(), new TimeAndDistSerializer());
    }

    public CallingMethodTreeImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, reporter, I18n._s((String)"Reading the method tree ... (<%> %)"));
    }

    public static CallingMethodTreeImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        PerformanceValueIterator[] its = PerformanceValueIterator.getIterators(name, reporter, I18n._s((String)"Creating the method tree ... (<%> %)"), false);
        CallingMethodTreeImpl tree = new CallingMethodTreeImpl(name);
        new CallingMethodTreeCreator<TimeAndDist>().fillIn(tree, new CalledMethodTreeImpl.TreePruner(), its);
        return tree;
    }

    @Override
    public void createChildren(SelfAndTotalValueTreeNode<MethodLocation, TimeAndDist> node, ProgressReporter reporter) throws IOException {
        assert (node.hasChildren());
        assert (!node.hasCreatedChildren());
        PerformanceValueIterator[] its = PerformanceValueIterator.getIterators(this.getResourceName(), reporter, I18n._s((String)"Creating the children ... (<%> %)"), false);
        new CallingMethodTreeCreator<TimeAndDist>().setChildren(new CalledMethodTreeImpl.TreePruner(), (SelfAndTotalValueTreeNodeImpl)node, its);
    }

    @Override
    public void createSubNodes(SelfAndTotalValueTreeNode<MethodLocation, TimeAndDist> node, ProgressReporter reporter) throws IOException {
        assert (node.hasSubNodes());
        assert (!node.hasCreatedSubNodes());
        PerformanceValueIterator[] its = PerformanceValueIterator.getIterators(this.getResourceName(), reporter, I18n._s((String)"Creating the children ... (<%> %)"), false);
        new CallingMethodTreeCreator<TimeAndDist>().setSubNodes(new CalledMethodTreeImpl.TreePruner(), (SelfAndTotalValueTreeNodeImpl)node, its);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        super.write(writer, reporter, I18n._s((String)"Writing the method tree ... (<%> %)"));
    }
}

