/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.tbs;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.method.command.TimeBasedSamplingConfiguration;
import com.sap.jvm.profiling.method.event.MethodParameterMethodToTraceEvent;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingEvent;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingEventHandler;
import com.sap.jvm.profiling.method.response.DisableTimeBasedSamplingMptResponse;
import com.sap.jvm.profiling.method.response.DisableTimeBasedSamplingResponse;
import com.sap.jvm.profiling.method.response.EnableTimeBasedSamplingMptResponse;
import com.sap.jvm.profiling.method.response.EnableTimeBasedSamplingResponse;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.impl.SnapshotImpl;
import com.sap.jvm.profiling.snapshot.tbs.PerformanceHotspotSnapshot;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class PerformanceHotspotSnapshotImpl
extends SnapshotImpl
implements PerformanceHotspotSnapshot {
    private ResourceName resourceName;
    private final TimeBasedSamplingConfiguration config;
    private long nrOfSamples;
    private long runningTime;
    private long cpuTime;
    private long sleepingTime;
    private final List<MethodParameterSpec> specs;
    private final List<MethodParameterMethodToTraceEvent> methodsToTrace;
    private final long nrOfInvocations;

    public static PerformanceHotspotSnapshotImpl read(ResourceName resourceName, ResourceReader reader, SnapshotStore<Snapshot> store, ProgressReporter reporter) throws IOException {
        long sleepingTime;
        long cpuTime;
        long runningTime;
        int id = reader.readInt32();
        String name = reader.readString();
        Bookmark start = reader.getSession().readBookmark(reader);
        Bookmark end = reader.getSession().readBookmark(reader);
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        boolean isVirtual = reader.readBoolean();
        int parentId = reader.readInt32();
        long nrOfSamples = reader.readInt64();
        long timePerSample = reader.readInt64();
        long nrOfStackTraces = reader.readInt64();
        TimeBasedSamplingConfiguration config = new TimeBasedSamplingConfiguration();
        config.setMaxStackTraceSize(reader.readInt32());
        config.setIgnoreSleepingThreads(reader.readBoolean());
        config.setThreadFilter(reader.readNewThreadFilter());
        long nrOfInvocations = reader.readInt64();
        ProfilingSession session = reader.getSession();
        int nrOfSpecs = reader.readInt8();
        ArrayList<MethodParameterSpec> specs = new ArrayList<MethodParameterSpec>();
        for (int i = 0; i < nrOfSpecs; ++i) {
            specs.add(session.readMethodParameterSpec(reader));
        }
        int nrOfMethodsToTrace = reader.hasNext() ? reader.readInt32() : 0;
        ArrayList<MethodParameterMethodToTraceEvent> methodsToTrace = new ArrayList<MethodParameterMethodToTraceEvent>();
        for (int i = 0; i < nrOfMethodsToTrace; ++i) {
            methodsToTrace.add(session.readMethodToTrace(reader));
        }
        if (reader.hasNext()) {
            runningTime = reader.readInt64();
            cpuTime = reader.readInt64();
            sleepingTime = reader.readInt64();
            if (reader.hasNext()) {
                config.setSmooth(reader.readBoolean());
            }
        } else {
            runningTime = nrOfStackTraces * timePerSample;
            cpuTime = 0L;
            sleepingTime = runningTime;
        }
        PerformanceHotspotSnapshotImpl snapshot = new PerformanceHotspotSnapshotImpl(id, resourceName, name, reader.getSession(), start, end, config, nrOfSamples, runningTime, cpuTime, sleepingTime, nrOfInvocations, specs, methodsToTrace, startTimestamp, endTimestamp, isVirtual, null);
        snapshot.setParentId(parentId);
        snapshot.setSnapshotStore(store);
        return snapshot;
    }

    public PerformanceHotspotSnapshotImpl(int id, ResourceName resourceName, String name, ProfilingSession session, Bookmark start, Bookmark end, TimeBasedSamplingConfiguration config, long nrOfSamples, long runningTime, long cpuTime, long sleepingTime, long nrOfInvocations, List<MethodParameterSpec> specs, List<MethodParameterMethodToTraceEvent> methodsToTrace, long startCollectionTimeStamp, long endCollectionTimeStamp, boolean isVirtual, PerformanceHotspotSnapshot parent) {
        super(SnapshotType.PERFORMANCE_HOTSPOT_SNAPSHOT, id, name, start, end, startCollectionTimeStamp, endCollectionTimeStamp, session, isVirtual, parent);
        this.config = config;
        this.nrOfSamples = nrOfSamples;
        this.runningTime = runningTime;
        this.cpuTime = cpuTime;
        this.sleepingTime = sleepingTime;
        this.nrOfInvocations = nrOfInvocations;
        this.specs = specs != null ? specs : new ArrayList();
        ArrayList arrayList = this.methodsToTrace = methodsToTrace != null ? methodsToTrace : new ArrayList();
        assert (isVirtual || nrOfSamples >= 0L);
        this.resourceName = resourceName;
    }

    public PerformanceHotspotSnapshotImpl(int id, ResourceName resourceName, String name, ProfilingSession session, Bookmark start, Bookmark end, TimeBasedSamplingConfiguration config, long nrOfInvocations, List<MethodParameterSpec> specs, List<MethodParameterMethodToTraceEvent> methodsToTrace, long startCollectionTimeStamp, long endCollectionTimeStamp, boolean isVirtual, PerformanceHotspotSnapshot parent, ProgressReporter reporter) {
        super(SnapshotType.PERFORMANCE_HOTSPOT_SNAPSHOT, id, name, start, end, startCollectionTimeStamp, endCollectionTimeStamp, session, isVirtual, parent);
        this.config = config;
        this.resourceName = resourceName;
        this.nrOfInvocations = nrOfInvocations;
        this.specs = specs != null ? specs : new ArrayList();
        this.methodsToTrace = methodsToTrace != null ? methodsToTrace : new ArrayList();
    }

    @Override
    public long getNrOfSamples() {
        return this.nrOfSamples;
    }

    @Override
    public long getSampleTime() {
        return this.getEndCollectionTimeStamp() - this.getStartCollectionTimeStamp();
    }

    @Override
    public long getCpuTime() {
        return this.cpuTime;
    }

    @Override
    public long getRunningTime() {
        return this.runningTime;
    }

    @Override
    public long getSleepingTime() {
        return this.sleepingTime;
    }

    @Override
    public ResourceName asResourceName() {
        return this.resourceName;
    }

    @Override
    public TimeBasedSamplingConfiguration getConfig() {
        return this.config;
    }

    @Override
    public long getNrOfInvocations() {
        return this.nrOfInvocations;
    }

    @Override
    public List<MethodParameterSpec> getParameterSpecs() {
        return this.specs;
    }

    @Override
    public List<MethodParameterMethodToTraceEvent> getMethodsToTrace() {
        return this.methodsToTrace;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt64(this.getNrOfSamples());
        writer.writeInt64(-1L);
        writer.writeInt64(-1L);
        writer.writeInt32(this.config.getMaxStackTraceSize());
        writer.writeBoolean(this.config.ignoreSleepingThreads());
        writer.writeNewThreadFilter(this.config.getThreadFilter());
        writer.writeInt64(this.getNrOfInvocations());
        writer.writeInt8(this.specs.size());
        for (MethodParameterSpec spec : this.specs) {
            writer.writeMethodParameterSpec(spec);
        }
        writer.writeInt32(this.methodsToTrace.size());
        for (MethodParameterMethodToTraceEvent methodToTrace : this.methodsToTrace) {
            writer.writeMethodToTrace(methodToTrace);
        }
        writer.writeInt64(this.runningTime);
        writer.writeInt64(this.cpuTime);
        writer.writeInt64(this.sleepingTime);
        writer.writeBoolean(this.config.getSmooth());
    }

    @Override
    public boolean hasParameterSettings() {
        return this.specs != null && this.specs.size() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeProperties(ProgressReporter reporter) throws IOException {
        SnapshotExtractor extractor = new SnapshotExtractor();
        try (ProfilingReader reader = this.getEventReader(reporter);){
            reader.registerTimeBasedSamplingEventHandler((TimeBasedSamplingEventHandler)extractor);
            reporter.setWork(I18n._s((String)"Analyzing the snapshot"), reader.getNrOfPacketsToRead());
            while (reader.nextPacket() != null) {
            }
        }
        this.nrOfSamples = extractor.getNrOfSamples();
        this.runningTime = extractor.getRunningTime();
        this.cpuTime = extractor.getCpuTime();
        this.sleepingTime = extractor.getSleepingTime();
    }

    private static class SnapshotExtractor
    implements TimeBasedSamplingEventHandler {
        private long nrOfSamples;
        private long runningTime;
        private long cpuTime;
        private long sleepingTime;

        private SnapshotExtractor() {
        }

        public void handle(EnableTimeBasedSamplingResponse response) {
        }

        public void handle(DisableTimeBasedSamplingResponse response) {
        }

        public void handle(EnableTimeBasedSamplingMptResponse response) {
        }

        public void handle(DisableTimeBasedSamplingMptResponse response) {
        }

        public void handle(TimeBasedSamplingEvent event) {
            ++this.nrOfSamples;
            for (int i = 0; i < event.getNrOfThreads(); ++i) {
                if (event.isSleeping(i)) {
                    this.sleepingTime += event.getElapsedTime();
                    continue;
                }
                this.runningTime += event.getElapsedTime();
                this.cpuTime += event.getElapsedCpuTime(i);
            }
        }

        public long getNrOfSamples() {
            return this.nrOfSamples;
        }

        public long getRunningTime() {
            return this.runningTime;
        }

        public long getCpuTime() {
            return this.cpuTime;
        }

        public long getSleepingTime() {
            return this.sleepingTime;
        }
    }
}

