/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.tbs;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingEvent;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingEventHandler;
import com.sap.jvm.profiling.method.response.DisableTimeBasedSamplingMptResponse;
import com.sap.jvm.profiling.method.response.DisableTimeBasedSamplingResponse;
import com.sap.jvm.profiling.method.response.EnableTimeBasedSamplingMptResponse;
import com.sap.jvm.profiling.method.response.EnableTimeBasedSamplingResponse;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.impl.resource.AbstractValueIterator;
import com.sap.jvm.profiling.snapshot.impl.tbs.RunningTypeFilter;
import com.sap.jvm.profiling.snapshot.impl.tbs.StackStatisticImpl;
import com.sap.jvm.profiling.snapshot.tbs.Elements;
import com.sap.jvm.profiling.snapshot.tbs.SimpleTimeAndDist;
import com.sap.jvm.profiling.snapshot.tbs.SimpleTimeDist;
import com.sap.jvm.profiling.snapshot.tbs.StackIterator;
import com.sap.jvm.profiling.snapshot.tbs.TimeAndDist;
import com.sap.jvm.profiling.snapshot.tbs.elements.FilterByRunningType;
import java.io.IOException;

public final class PerformanceValueIterator
extends AbstractValueIterator<TimeAndDist>
implements TimeBasedSamplingEventHandler {
    private final ProfilingReader reader;
    private TimeBasedSamplingEvent currentEvent;
    private int currentThreadIndex;
    private final ProgressReporter reporter;
    public final StackIterator it;
    public final RunningTypeFilter runningTypeFilter;

    public PerformanceValueIterator(Snapshot snapshot, ResourceName name, ProgressReporter reporter, String message) throws OperationCanceledException {
        super(name, snapshot, reporter);
        this.reader = this.getEventReader();
        this.runningTypeFilter = PerformanceValueIterator.getRunningTypeFilter(name);
        this.reporter = reporter;
        reporter.setWork(message, this.reader.getNrOfPacketsToRead());
        this.reader.registerTimeBasedSamplingEventHandler((TimeBasedSamplingEventHandler)this);
        this.it = null;
    }

    private PerformanceValueIterator(StackIterator it, ResourceName name, ProgressReporter reporter) throws OperationCanceledException {
        super(name, null, reporter);
        assert (!this.usesEvents());
        this.runningTypeFilter = PerformanceValueIterator.getRunningTypeFilter(name);
        this.reporter = reporter;
        this.it = it;
        this.reader = null;
    }

    public static PerformanceValueIterator getEventIterator(ResourceName name, ProgressReporter reporter, String message) throws IOException {
        return PerformanceValueIterator.getIterators(name, 1, reporter, message, true)[0];
    }

    public static PerformanceValueIterator[] getIterators(ResourceName name, ProgressReporter reporter, String message, boolean usesEvents) throws IOException {
        return PerformanceValueIterator.getIterators(name, name.getSession().getNrOfThreads(), reporter, message, usesEvents);
    }

    public static PerformanceValueIterator[] getIterators(ResourceName name, int nrOfIterators, ProgressReporter reporter, String message, boolean usesEvents) throws IOException {
        ProfilingSession session = name.getSession();
        Snapshot snapshot = SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        if (usesEvents || PerformanceValueIterator.needsEventIteration(name)) {
            return new PerformanceValueIterator[]{new PerformanceValueIterator(snapshot, name, reporter, message)};
        }
        ResourceName cAndSName = snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateStackStatistic());
        StackStatisticImpl statistic = (StackStatisticImpl)session.getResourceManager().get(cAndSName, reporter);
        if (statistic == null) {
            throw new OperationCanceledException();
        }
        StackStatisticImpl.StackIteratorImpl[] baseIterators = statistic.getIterators(nrOfIterators);
        PerformanceValueIterator[] result = new PerformanceValueIterator[baseIterators.length];
        ProgressReporter[] dummyReporters = reporter.getChildren(nrOfIterators - 1);
        result[0] = new PerformanceValueIterator(baseIterators[0], name, reporter);
        for (int i = 1; i < result.length; ++i) {
            result[i] = new PerformanceValueIterator(baseIterators[i], name, dummyReporters[i - 1]);
        }
        reporter.setWork(message, result[0].it.getMaxProgress());
        return result;
    }

    @Override
    protected ResourceName getDependentForIt() {
        ResourceName name = this.getResourceName();
        Snapshot snapshot = SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        return snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateStackStatistic());
    }

    @Override
    public TimeAndDist getEmptyValue() {
        return SimpleTimeAndDist.EMPTY;
    }

    @Override
    public int getStackIndex() {
        if (this.it != null) {
            return this.it.getStackIndex();
        }
        return this.currentEvent.getStackTraceIndex(this.currentThreadIndex);
    }

    @Override
    public char getThreadIndex() {
        return this.currentEvent.getThreadIndex(this.currentThreadIndex);
    }

    @Override
    public TimeAndDist getValue() {
        if (this.it != null) {
            return this.it.getTimeAndDist();
        }
        if (this.currentEvent.isSleeping(this.currentThreadIndex)) {
            long sleepTime = this.currentEvent.getElapsedTime();
            return new SimpleTimeAndDist(0L, 0L, sleepTime, SimpleTimeDist.EMPTY, SimpleTimeDist.EMPTY);
        }
        long time = this.currentEvent.getElapsedTime();
        long cpuTime = this.currentEvent.getElapsedCpuTime(this.currentThreadIndex);
        return new SimpleTimeAndDist(time, cpuTime, 0L, this.getTimeDistribution(time), this.getTimeDistribution(cpuTime));
    }

    private SimpleTimeDist getTimeDistribution(long time) {
        if (this.currentEvent.topIsInterpreter(this.currentThreadIndex)) {
            return new SimpleTimeDist(time, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        }
        if (this.currentEvent.topIsNativeInterpreter(this.currentThreadIndex)) {
            return new SimpleTimeDist(0L, time, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        }
        if (this.currentEvent.topIsInlined(this.currentThreadIndex)) {
            return new SimpleTimeDist(0L, 0L, time, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        }
        if (this.currentEvent.topIsNativeInlined(this.currentThreadIndex)) {
            return new SimpleTimeDist(0L, 0L, 0L, time, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        }
        if (this.currentEvent.topIsCompiled(this.currentThreadIndex)) {
            return new SimpleTimeDist(0L, 0L, 0L, 0L, time, 0L, 0L, 0L, 0L, 0L, 0L);
        }
        if (this.currentEvent.topIsNativeCompiled(this.currentThreadIndex)) {
            return new SimpleTimeDist(0L, 0L, 0L, 0L, 0L, time, 0L, 0L, 0L, 0L, 0L);
        }
        if (this.currentEvent.topIsInlinedTier1(this.currentThreadIndex)) {
            return new SimpleTimeDist(0L, 0L, 0L, 0L, 0L, 0L, time, 0L, 0L, 0L, 0L);
        }
        if (this.currentEvent.topIsNativeInlinedTier1(this.currentThreadIndex)) {
            return new SimpleTimeDist(0L, 0L, 0L, 0L, 0L, 0L, 0L, time, 0L, 0L, 0L);
        }
        if (this.currentEvent.topIsCompiledTier1(this.currentThreadIndex)) {
            return new SimpleTimeDist(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, time, 0L, 0L);
        }
        if (this.currentEvent.topIsNativeCompiledTier1(this.currentThreadIndex)) {
            return new SimpleTimeDist(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, time, 0L);
        }
        return new SimpleTimeDist(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, time);
    }

    public int getStackTraceIndex() {
        return this.currentEvent.getStackTraceIndex(this.currentThreadIndex);
    }

    @Override
    protected boolean nextFromStatistic() throws OperationCanceledException {
        if (this.it.next()) {
            if (!this.reporter.report(this.it.getProgress())) {
                throw new OperationCanceledException();
            }
            return true;
        }
        return false;
    }

    @Override
    protected int nextOrReadRaw() throws IOException {
        ++this.currentThreadIndex;
        if (this.currentEvent != null && this.currentThreadIndex < this.currentEvent.getNrOfThreads()) {
            if (this.runningTypeFilter != null && !this.runningTypeFilter.applies(this.currentEvent, this.currentThreadIndex)) {
                return 1;
            }
            return 0;
        }
        try {
            if (this.reader.nextPacket() != null) {
                if (!this.reporter.report(this.reader.getNrOfReadPackets())) {
                    throw new OperationCanceledException();
                }
                if (this.currentEvent == null) {
                    return 1;
                }
                if (this.currentThreadIndex < this.currentEvent.getNrOfThreads()) {
                    if (this.runningTypeFilter != null && !this.runningTypeFilter.applies(this.currentEvent, this.currentThreadIndex)) {
                        return 1;
                    }
                    return 0;
                }
                return 1;
            }
        }
        catch (IOException ex) {
            this.reader.close();
            throw ex;
        }
        this.reader.close();
        return 2;
    }

    public void handle(TimeBasedSamplingEvent event) {
        if (event.getNrOfThreads() > 0) {
            this.currentEvent = event;
            this.currentThreadIndex = 0;
        }
    }

    public void handle(EnableTimeBasedSamplingResponse response) {
    }

    public void handle(DisableTimeBasedSamplingResponse response) {
    }

    public void handle(EnableTimeBasedSamplingMptResponse response) {
    }

    public void handle(DisableTimeBasedSamplingMptResponse response) {
    }

    public static RunningTypeFilter getRunningTypeFilter(ResourceName name) {
        RunningTypeFilter result = null;
        for (ResourceNameElement element : name) {
            if (!(element instanceof FilterByRunningType)) continue;
            FilterByRunningType filterElement = (FilterByRunningType)element;
            result = new RunningTypeFilter(filterElement.getRunningTypes(), result);
        }
        return result;
    }

    @Override
    public ProgressReporter getReporter() {
        return this.reporter;
    }
}

