/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.tbs;

import com.sap.jvm.profiling.method.event.TimeBasedSamplingEvent;
import com.sap.jvm.profiling.snapshot.tbs.elements.RunningType;
import java.util.ArrayList;

public class RunningTypeFilter {
    private final RunningType[] types;
    private final boolean matchCompiledNonNative;
    private final boolean matchInlinedNonNative;
    private final boolean matchInterpretedNonNative;
    private final boolean matchCompiledNative;
    private final boolean matchInlinedNative;
    private final boolean matchInterpretedNative;
    private final boolean matchCompiledNonNativeTier1;
    private final boolean matchInlinedNonNativeTier1;
    private final boolean matchCompiledNativeTier1;
    private final boolean matchInlinedNativeTier1;
    private final boolean matchOther;

    public RunningTypeFilter(RunningType[] types, RunningTypeFilter parent) {
        if (parent == null) {
            this.types = types;
        } else {
            ArrayList<RunningType> newTypes = new ArrayList<RunningType>();
            for (RunningType type : types) {
                for (RunningType type2 : parent.types) {
                    if (type != type2) continue;
                    newTypes.add(type);
                }
            }
            this.types = newTypes.toArray(new RunningType[newTypes.size()]);
        }
        boolean hasCompiledNonNative = false;
        boolean hasInlinedNonNative = false;
        boolean hasInterpretedNonNative = false;
        boolean hasCompiledNative = false;
        boolean hasInlinedNative = false;
        boolean hasInterpretedNative = false;
        boolean hasCompiledNonNativeTier1 = false;
        boolean hasInlinedNonNativeTier1 = false;
        boolean hasCompiledNativeTier1 = false;
        boolean hasInlinedNativeTier1 = false;
        boolean hasOther = false;
        block18: for (RunningType type : types) {
            switch (type) {
                case COMPILED: {
                    hasCompiledNonNative = true;
                    hasInlinedNonNative = true;
                    hasCompiledNonNativeTier1 = true;
                    hasInlinedNonNativeTier1 = true;
                    continue block18;
                }
                case INTERPRETED: {
                    hasInterpretedNonNative = true;
                    continue block18;
                }
                case NATIVE: {
                    hasCompiledNative = true;
                    hasInterpretedNative = true;
                    hasInlinedNative = true;
                    hasCompiledNativeTier1 = true;
                    hasInlinedNativeTier1 = true;
                    continue block18;
                }
                case COMPILED_NON_NATIVE: {
                    hasCompiledNonNative = true;
                    continue block18;
                }
                case INLINED_NON_NATIVE: {
                    hasInlinedNonNative = true;
                    continue block18;
                }
                case INTERPRETED_NON_NATIVE: {
                    hasInterpretedNonNative = true;
                    continue block18;
                }
                case COMPILED_NATIVE: {
                    hasCompiledNative = true;
                    continue block18;
                }
                case INLINED_NATIVE: {
                    hasInlinedNative = true;
                    continue block18;
                }
                case INTERPRETED_NATIVE: {
                    hasInterpretedNative = true;
                    continue block18;
                }
                case COMPILED_NON_NATIVE_TIER1: {
                    hasCompiledNonNativeTier1 = true;
                    continue block18;
                }
                case INLINED_NON_NATIVE_TIER1: {
                    hasInlinedNonNativeTier1 = true;
                    continue block18;
                }
                case COMPILED_NATIVE_TIER1: {
                    hasCompiledNativeTier1 = true;
                    continue block18;
                }
                case INLINED_NATIVE_TIER1: {
                    hasInlinedNativeTier1 = true;
                    continue block18;
                }
                case OTHER: {
                    hasOther = true;
                }
            }
        }
        this.matchCompiledNonNative = hasCompiledNonNative;
        this.matchInlinedNonNative = hasInlinedNonNative;
        this.matchInterpretedNonNative = hasInterpretedNonNative;
        this.matchCompiledNative = hasCompiledNative;
        this.matchInlinedNative = hasInlinedNative;
        this.matchInterpretedNative = hasInterpretedNative;
        this.matchCompiledNonNativeTier1 = hasCompiledNonNativeTier1;
        this.matchInlinedNonNativeTier1 = hasInlinedNonNativeTier1;
        this.matchCompiledNativeTier1 = hasCompiledNativeTier1;
        this.matchInlinedNativeTier1 = hasInlinedNativeTier1;
        this.matchOther = hasOther;
    }

    public boolean applies(TimeBasedSamplingEvent event, int index) {
        if (event.topIsCompiled(index)) {
            return this.matchCompiledNonNative;
        }
        if (event.topIsInlined(index)) {
            return this.matchInlinedNonNative;
        }
        if (event.topIsInterpreter(index)) {
            return this.matchInterpretedNonNative;
        }
        if (event.topIsNativeCompiled(index)) {
            return this.matchCompiledNative;
        }
        if (event.topIsNativeInlined(index)) {
            return this.matchInlinedNative;
        }
        if (event.topIsNativeInterpreter(index)) {
            return this.matchInterpretedNative;
        }
        if (event.topIsCompiledTier1(index)) {
            return this.matchCompiledNonNativeTier1;
        }
        if (event.topIsInlinedTier1(index)) {
            return this.matchInlinedNonNativeTier1;
        }
        if (event.topIsNativeCompiledTier1(index)) {
            return this.matchCompiledNativeTier1;
        }
        if (event.topIsNativeInlinedTier1(index)) {
            return this.matchInlinedNativeTier1;
        }
        return this.matchOther;
    }
}

