/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.tbs;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.AbstractResource;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.Resource;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.tbs.PerformanceValueIterator;
import com.sap.jvm.profiling.snapshot.tbs.SimpleTimeAndDist;
import com.sap.jvm.profiling.snapshot.tbs.StackIterator;
import com.sap.jvm.profiling.snapshot.tbs.StackStatistic;
import com.sap.jvm.profiling.snapshot.tbs.TimeAndDist;
import com.sap.jvm.profiling.util.splitarray.SplitArray32;
import com.sap.jvm.profiling.util.splitarray.SplitArrayObject;
import com.sap.jvm.util.pair.IntPair;
import java.io.IOException;

public final class StackStatisticImpl
extends AbstractResource
implements StackStatistic {
    private static final int VERSION = 2;
    private final SplitArray32 stackIndexToLogicalIndexMap = new SplitArray32();
    private final SplitArray32 logicalIndexToStackIndexMap = new SplitArray32();
    private final SplitArrayObject<TimeAndDist> logicalIndexToTime = new SplitArrayObject(0);
    private TimeAndDist totalTime = SimpleTimeAndDist.EMPTY;
    private int nrOfEntries;

    public StackStatisticImpl(ResourceName name) {
        super(name);
    }

    public StackStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        reader.readVersion(2);
        int readNrOfEntries = reader.readInt32();
        reporter.setWork(I18n._s((String)"Reading the stack statistic ... (<%> %)"), (long)this.nrOfEntries);
        for (long i = 0L; i < (long)readNrOfEntries; ++i) {
            reporter.reportNextOrThrow();
            int stackIndex = reader.readInt32();
            SimpleTimeAndDist time = new SimpleTimeAndDist(reader);
            this.add(stackIndex, time);
        }
        assert (this.nrOfEntries == readNrOfEntries);
        this.finish();
    }

    public static Resource create(ResourceName name, ProgressReporter reporter) throws OperationCanceledException, IOException {
        PerformanceValueIterator it = PerformanceValueIterator.getEventIterator(name, reporter, I18n._s((String)"Analyzing the samples ... (<%> %)"));
        StackStatisticImpl result = new StackStatisticImpl(name);
        while (it.next()) {
            result.add(it.getStackTraceIndex(), it.getValue());
        }
        result.finish();
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(2);
        writer.writeInt32(this.nrOfEntries);
        StackIteratorImpl it = this.getIterators(1)[0];
        reporter.setWork(I18n._s((String)"Writing the stack statistic ... (<%> %)"), (long)this.nrOfEntries);
        for (int i = 0; i < this.nrOfEntries; ++i) {
            reporter.reportNextOrThrow();
            boolean hasNext = it.next();
            assert (hasNext);
            writer.writeInt32(it.getStackIndex());
            it.getTimeAndDist().write(writer);
        }
    }

    @Override
    public long calculateWriteWork() {
        return this.nrOfEntries;
    }

    private void add(int stackIndex, TimeAndDist time) {
        this.totalTime = this.totalTime.getSum(time);
        this.stackIndexToLogicalIndexMap.resize(stackIndex + 1);
        int logicalIndex = this.stackIndexToLogicalIndexMap.get(stackIndex);
        if (logicalIndex == 0) {
            ++this.nrOfEntries;
            logicalIndex = this.nrOfEntries;
            this.stackIndexToLogicalIndexMap.set(stackIndex, logicalIndex);
            this.logicalIndexToStackIndexMap.resize(this.nrOfEntries + 1);
            this.logicalIndexToTime.resize(this.nrOfEntries + 1, (Object)SimpleTimeAndDist.EMPTY);
            this.logicalIndexToStackIndexMap.set(logicalIndex, stackIndex);
        }
        this.logicalIndexToTime.set(logicalIndex, (Object)((TimeAndDist)this.logicalIndexToTime.get(logicalIndex)).getSum(time));
    }

    private void finish() {
    }

    public long getNrOfEntries() {
        return this.nrOfEntries;
    }

    public StackIteratorImpl[] getIterators(int nrOfIterators) {
        StackIteratorImpl baseIterator;
        assert (nrOfIterators > 0);
        StackIteratorImpl[] result = new StackIteratorImpl[nrOfIterators];
        result[0] = baseIterator = new StackIteratorImpl(this, null);
        for (int i = 1; i < nrOfIterators; ++i) {
            result[i] = new StackIteratorImpl(this, baseIterator);
        }
        return result;
    }

    @Override
    public long getSize() {
        return this.nrOfEntries;
    }

    @Override
    public TimeAndDist getTimeAndDist() {
        assert (this.totalTime != null);
        return this.totalTime;
    }

    public ResourceName[] getDependents() {
        return null;
    }

    public boolean isModifiable() {
        return false;
    }

    private IntPair getFromStackTraceArray(int startIndex, int maxToAdd, int offset, int[] stackIndices, TimeAndDist[] times) {
        int leftToAdd = maxToAdd;
        int currOffset = offset;
        int maxIndex = this.nrOfEntries + 1;
        for (int i = startIndex; i < maxIndex; ++i) {
            stackIndices[currOffset] = this.logicalIndexToStackIndexMap.get(i);
            times[currOffset] = (TimeAndDist)this.logicalIndexToTime.get(i);
            ++currOffset;
            if (--leftToAdd != 0) continue;
            return new IntPair(maxToAdd, i + 1);
        }
        return new IntPair(maxToAdd - leftToAdd, maxIndex);
    }

    public static final class StackIteratorImpl
    implements StackIterator {
        private static final int STORE_SIZE = 8192;
        private final StackStatisticImpl statistic;
        private long nrOfEntries;
        private final StackIteratorImpl baseIterator;
        private int stackTraceIndex;
        private final int[] stackStore;
        private final TimeAndDist[] timeStore;
        private int storeIndex;
        private int maxStoreIndex;
        private boolean isValid;

        public StackIteratorImpl(StackStatisticImpl statistic, StackIteratorImpl baseIterator) {
            this.statistic = statistic;
            this.stackStore = new int[8192];
            this.timeStore = new TimeAndDist[8192];
            for (int i = 0; i < 8192; ++i) {
                this.timeStore[i] = SimpleTimeAndDist.EMPTY;
            }
            this.baseIterator = baseIterator == null ? this : baseIterator;
            this.maxStoreIndex = 0;
            this.isValid = true;
            this.stackTraceIndex = 1;
        }

        @Override
        public int getStackIndex() {
            assert (this.isValid);
            return this.stackStore[this.storeIndex];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean next() {
            ++this.storeIndex;
            if (this.storeIndex < this.maxStoreIndex) {
                return true;
            }
            StackIteratorImpl stackIteratorImpl = this.baseIterator;
            synchronized (stackIteratorImpl) {
                this.storeIndex = 0;
                IntPair result = this.statistic.getFromStackTraceArray(this.baseIterator.stackTraceIndex, 8192, 0, this.stackStore, this.timeStore);
                this.maxStoreIndex = result.getFirst();
                this.baseIterator.stackTraceIndex = result.getSecond();
                this.baseIterator.nrOfEntries += (long)this.maxStoreIndex;
                if (this.maxStoreIndex > 0) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public long getProgress() {
            return this.baseIterator.nrOfEntries;
        }

        @Override
        public long getMaxProgress() {
            return this.statistic.nrOfEntries;
        }

        @Override
        public TimeAndDist getTimeAndDist() {
            assert (this.isValid);
            return this.timeStore[this.storeIndex];
        }
    }
}

