/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.AbstractResource;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpHintBlockedThreadImpl;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpHintBusyLoopImpl;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpHintDeadlockImpl;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpHintHotspotImpl;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpHintInactiveThreadImpl;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpHintLockContentionImpl;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpHintResourceLeakImpl;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpHintTopConsumerImpl;
import com.sap.jvm.profiling.snapshot.resource.SnapshotResource;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpSnapshot;
import com.sap.jvm.profiling.snapshot.thread.compare.ThreadDumpCompareResult;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHint;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.ThreadDumpFactory;
import com.sap.jvm.profiling.thread.ThreadDumpsNotMatchException;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ThreadDumpCompareResultImpl
extends AbstractResource
implements ThreadDumpCompareResult,
SnapshotResource {
    private ThreadDumpsSummary summary;
    private List<ThreadDumpHint> hints;

    public ThreadDumpCompareResultImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name, reporter);
    }

    protected ThreadDumpCompareResultImpl(ResourceName name, ProgressReporter reporter) {
        super(name);
        this.compareDumps(name, reporter);
    }

    public static ThreadDumpCompareResultImpl create(ResourceName name, ProgressReporter reporter) {
        return new ThreadDumpCompareResultImpl(name, reporter);
    }

    private void compareDumps(ResourceName name, ProgressReporter reporter) {
        ThreadDumpSnapshot snapshot = (ThreadDumpSnapshot)SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        ThreadDump[] dumps = snapshot.getThreadDumps(reporter);
        this.hints = new ArrayList<ThreadDumpHint>();
        try {
            this.summary = ThreadDumpFactory.createThreadDumpSummary((ThreadDump[])dumps, (ProfilingSession)this.getResourceName().getSession(), (ProgressReporter)reporter);
            reporter.setWork(I18n._s((String)"Calculating thread dump hints (<%>% done)"), 8L);
            this.hints.addAll(ThreadDumpHintDeadlockImpl.generateHints(this.summary));
            reporter.reportNextOrThrow();
            if (this.summary.getThreadDumps().getNumDumps() >= 3) {
                this.hints.addAll(ThreadDumpHintBusyLoopImpl.generateHints(this.summary));
                reporter.reportNextOrThrow();
                this.hints.addAll(ThreadDumpHintTopConsumerImpl.generateHints(this.summary));
                reporter.reportNextOrThrow();
                if (this.summary.getElapsedTimeDiff() > 300000L) {
                    this.hints.addAll(ThreadDumpHintResourceLeakImpl.generateHints(this.summary));
                }
                reporter.reportNextOrThrow();
                this.hints.addAll(ThreadDumpHintHotspotImpl.generateHints(this.summary));
                reporter.reportNextOrThrow();
                this.hints.addAll(ThreadDumpHintLockContentionImpl.generateHints(this.summary));
                reporter.reportNextOrThrow();
                this.hints.addAll(ThreadDumpHintBlockedThreadImpl.generateHints(this.summary));
                reporter.reportNextOrThrow();
                this.hints.addAll(ThreadDumpHintInactiveThreadImpl.generateHints(this.summary));
                reporter.reportNextOrThrow();
                reporter.report(reporter.getMaximumWork());
            }
        }
        catch (ThreadDumpsNotMatchException e) {
            assert (false);
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
    }

    @Override
    public ThreadDumpsSummary getSummary() {
        return this.summary;
    }

    @Override
    public List<ThreadDumpHint> getHints() {
        return this.hints;
    }

    public boolean isModifiable() {
        return false;
    }

    public ResourceName[] getDependents() {
        return null;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
    }

    @Override
    public long calculateWriteWork() {
        return 0L;
    }
}

