/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread;

import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.impl.thread.ThreadDumpValueImpl;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpValue;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.event.ThreadDumpEventHandler;
import com.sap.jvm.profiling.thread.event.ThreadDumpsEvent;
import com.sap.jvm.profiling.thread.event.ThreadDumpsLastEvent;
import com.sap.jvm.profiling.thread.response.EnableThreadDumpsResponse;
import java.io.IOException;

public final class ThreadDumpIterator
implements ThreadDumpEventHandler {
    public static final int VALUE_AVAILABLE = 0;
    public static final int READ_PERFORMED = 1;
    public static final int FINISHED = 2;
    private ThreadDump curThreadDump;
    private final ResourceName name;
    private final ProfilingReader reader;
    private final ProgressReporter reporter;

    public ThreadDumpIterator(ResourceName name, ProgressReporter reporter, String message) throws IOException {
        Snapshot snapshot = SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        this.name = name;
        this.reader = snapshot.getEventReader(reporter);
        this.reporter = reporter;
        reporter.setWork(message, this.reader.getNrOfPacketsToRead());
        this.reader.registerThreadDumpEventHandler((ThreadDumpEventHandler)this);
        this.next();
    }

    protected boolean isValid() {
        return this.curThreadDump != null;
    }

    public ThreadDump getThreadDump() {
        return this.curThreadDump;
    }

    public ThreadDumpValue getEmptyValue() {
        return ThreadDumpValueImpl.EMPTY;
    }

    public void handle(ThreadDumpsEvent event) {
        this.curThreadDump = event.getThreadDump();
    }

    public void handle(EnableThreadDumpsResponse response) {
    }

    public void handle(ThreadDumpsLastEvent event) {
        this.curThreadDump = null;
    }

    public ProgressReporter getReporter() {
        return this.reporter;
    }

    public boolean next() throws IOException, OperationCanceledException {
        int result;
        while ((result = this.nextOrRead()) != 2) {
            if (result != 0) continue;
            return true;
        }
        return false;
    }

    protected int nextOrRead() throws IOException {
        this.curThreadDump = null;
        try {
            if (this.reader.nextPacket() != null) {
                if (!this.reporter.report(this.reader.getNrOfReadPackets())) {
                    throw new OperationCanceledException();
                }
                if (this.curThreadDump == null) {
                    return 1;
                }
                return 0;
            }
        }
        catch (IOException e) {
            this.reader.close();
            throw e;
        }
        this.reader.close();
        return 2;
    }

    public ProfilingReader getEventReader() {
        return this.reader;
    }

    public ResourceName getResourceName() {
        return this.name;
    }
}

