/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.impl.SnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.thread.ThreadDumpIterator;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpSnapshot;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.ThreadDumpFactory;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumpsNotMatchException;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;

public class ThreadDumpSnapshotImpl
extends SnapshotImpl
implements ThreadDumpSnapshot {
    private final ResourceName resourceName;
    private long totalSocketIO;
    private long totalFileIO;
    private long totalCPU;
    private int maxNumThreads;
    private ThreadDumpInfo[] dumpInfos;
    boolean hasJavaThreadIdData;
    boolean hasElapsedTimeData;
    private ThreadDump[] threadDumps;

    public static ThreadDumpSnapshotImpl read(ResourceName resourceName, ResourceReader reader, SnapshotStore<Snapshot> store) throws IOException {
        int id = reader.readInt32();
        String name = reader.readString();
        Bookmark start = reader.getSession().readBookmark(reader);
        Bookmark end = reader.getSession().readBookmark(reader);
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        boolean isVirtual = reader.readBoolean();
        int parentId = reader.readInt32();
        long totalCPU = reader.readInt64();
        long totalFileIO = reader.readInt64();
        long totalSocketIO = reader.readInt64();
        int maxThreadCount = reader.readInt32();
        int numDumps = reader.readInt32();
        ThreadDumpInfo[] dumpInfos = new ThreadDumpInfo[numDumps];
        for (int i = 0; i < dumpInfos.length; ++i) {
            dumpInfos[i] = ThreadDumpInfo.read(reader);
        }
        boolean hasJavaThreadIds = false;
        if (reader.hasNext()) {
            hasJavaThreadIds = reader.readBoolean();
        }
        boolean hasElapsedTimeData = false;
        if (reader.hasNext()) {
            hasElapsedTimeData = reader.readBoolean();
        }
        ThreadDumpSnapshotImpl snapshot = new ThreadDumpSnapshotImpl(id, resourceName, name, reader.getSession(), start, end, startTimestamp, endTimestamp, dumpInfos, totalCPU, totalFileIO, totalSocketIO, maxThreadCount, hasJavaThreadIds, hasElapsedTimeData, isVirtual);
        snapshot.setParentId(parentId);
        snapshot.setSnapshotStore(store);
        return snapshot;
    }

    public ThreadDumpSnapshotImpl(int id, ResourceName resourceName, String name, ProfilingSession session, Bookmark start, Bookmark end, long startCollectionTimeStamp, long endCollectionTimeStamp, ThreadDumpInfo[] dumpInfos, long totalCPU, long totalFileIO, long totalSocketIO, int maxThreadCount, boolean hasJavaThreadIds, boolean hasElapsedTimeData, boolean isVirtual) {
        super(SnapshotType.THREAD_DUMP_SNAPSHOT, id, name, start, end, startCollectionTimeStamp, endCollectionTimeStamp, session, isVirtual, null);
        this.resourceName = resourceName;
        this.dumpInfos = dumpInfos;
        this.totalCPU = totalCPU;
        this.totalFileIO = totalFileIO;
        this.totalSocketIO = totalSocketIO;
        this.maxNumThreads = maxThreadCount;
        this.hasJavaThreadIdData = hasJavaThreadIds;
        this.hasElapsedTimeData = hasElapsedTimeData;
    }

    public ThreadDumpSnapshotImpl(int id, ResourceName resourceName, String name, ProfilingSession session, Bookmark start, Bookmark end, long startCollectionTimeStamp, long endCollectionTimeStamp, ThreadDump[] dumps, boolean isVirtual) {
        super(SnapshotType.THREAD_DUMP_SNAPSHOT, id, name, start, end, startCollectionTimeStamp, endCollectionTimeStamp, session, isVirtual, null);
        this.resourceName = resourceName;
        this.threadDumps = dumps;
        ProgressReporter reporter = new ProgressReporter();
        this.initDumpInfos(dumps, reporter);
        reporter.finish();
    }

    @Override
    public void computeProperties(ProgressReporter reporter) throws IOException {
        if (this.dumpInfos != null) {
            return;
        }
        ThreadDump[] dumps = this.getThreadDumps(reporter);
        this.initDumpInfos(dumps, reporter);
    }

    private void initDumpInfos(ThreadDump[] dumps, ProgressReporter reporter) {
        ThreadDumpsSummary summary;
        int numDumps;
        block19: {
            if (this.dumpInfos != null) {
                assert (false);
                return;
            }
            numDumps = dumps.length;
            summary = null;
            if (numDumps > 0) {
                try {
                    summary = ThreadDumpFactory.createThreadDumpSummary((ThreadDump[])dumps, (ProfilingSession)this.getSession(), (ProgressReporter)reporter);
                }
                catch (ThreadDumpsNotMatchException e) {
                    assert (false);
                }
                catch (OperationCanceledException e) {
                    if ($assertionsDisabled) break block19;
                    throw new AssertionError();
                }
            }
        }
        this.dumpInfos = new ThreadDumpInfo[numDumps];
        for (int i = 0; i < numDumps; ++i) {
            ThreadDumpInfo info = new ThreadDumpInfo();
            info.numThreads = dumps[i].getNumThreads();
            info.timestamp = dumps[i].getTimeStamp();
            if (summary != null && i > 0) {
                info.cpu = summary.getCPUTimeDiff(i - 1, i);
                info.fileIO = summary.getFileBytesReadDiff(i - 1, i) + summary.getFileBytesWrittenDiff(i - 1, i);
                info.socketIO = summary.getSocketBytesReadDiff(i - 1, i) + summary.getSocketBytesWrittenDiff(i - 1, i);
            }
            info.runningThreads = 0L;
            info.blockedThreads = 0L;
            info.sleepingThreads = 0L;
            info.waitingThreads = 0L;
            info.ioThreads = 0L;
            block11: for (ThreadDumpItem th : dumps[i].getThreadDumpItems()) {
                switch (th.getStatus()) {
                    case THREAD_STATUS_UNKNOWN: {
                        continue block11;
                    }
                    case THREAD_STATUS_RUNNING: {
                        ++info.runningThreads;
                        continue block11;
                    }
                    case THREAD_STATUS_SLEEPING: 
                    case THREAD_STATUS_OS_SLEEPING: {
                        ++info.sleepingThreads;
                        continue block11;
                    }
                    case THREAD_STATUS_OBJECT_WAIT: {
                        ++info.waitingThreads;
                        continue block11;
                    }
                    case THREAD_STATUS_LOCK_WAIT: {
                        ++info.blockedThreads;
                        continue block11;
                    }
                    default: {
                        ++info.ioThreads;
                    }
                }
            }
            info.deadlocked = dumps[i].getDeadlocks().length > 0;
            this.dumpInfos[i] = info;
        }
        if (dumps.length > 0) {
            this.totalSocketIO = summary.getSocketBytesReadDiff() + summary.getSocketBytesWrittenDiff();
            this.totalFileIO = summary.getFileBytesReadDiff() + summary.getFileBytesWrittenDiff();
            this.totalCPU = summary.getCPUTimeDiff();
            this.maxNumThreads = summary.getMaxNumThreads();
            if (dumps[0].getThreadDumpItems().length > 0) {
                ThreadDumpItem firstItem = dumps[0].getThreadDumpItems()[0];
                this.hasJavaThreadIdData = firstItem.getJavaThreadId() > 0L;
                this.hasElapsedTimeData = firstItem.getElapsedTime(false) > 0L;
            }
        }
    }

    @Override
    public ResourceName asResourceName() {
        return this.resourceName;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt64(this.totalCPU);
        writer.writeInt64(this.totalFileIO);
        writer.writeInt64(this.totalSocketIO);
        writer.writeInt32(this.maxNumThreads);
        writer.writeInt32(this.dumpInfos.length);
        for (ThreadDumpInfo info : this.dumpInfos) {
            info.write(writer);
        }
        writer.writeBoolean(this.hasJavaThreadIdData);
        writer.writeBoolean(this.hasElapsedTimeData);
    }

    @Override
    public ThreadDump[] getThreadDumps(ProgressReporter reporter) {
        if (this.threadDumps != null) {
            return this.threadDumps;
        }
        try {
            ArrayList<ThreadDump> dumps = new ArrayList<ThreadDump>();
            ThreadDumpIterator it = new ThreadDumpIterator(this.asResourceName(), reporter, I18n._s((String)"Analyzing the thread dump events ... (<%> %)"));
            while (it.isValid()) {
                dumps.add(it.getThreadDump());
                it.next();
            }
            this.threadDumps = dumps.toArray(new ThreadDump[0]);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.threadDumps;
    }

    @Override
    public long getFirstThreadDumpTimestamp() {
        return this.dumpInfos[0].timestamp;
    }

    @Override
    public long getLastThreadDumpTimestamp() {
        return this.dumpInfos[this.dumpInfos.length - 1].timestamp;
    }

    @Override
    public int getNumThreadDumps() {
        return this.dumpInfos.length;
    }

    @Override
    public int getNumThreadsInDump(int dumpIndex) {
        return this.dumpInfos[dumpIndex].numThreads;
    }

    @Override
    public long getNumOfRunningThreadsInDump(int dumpIndex) {
        return this.dumpInfos[dumpIndex].runningThreads;
    }

    @Override
    public long getNumOfWaitingThreadsInDump(int dumpIndex) {
        return this.dumpInfos[dumpIndex].waitingThreads;
    }

    @Override
    public long getNumOfBlockedThreadsInDump(int dumpIndex) {
        return this.dumpInfos[dumpIndex].blockedThreads;
    }

    @Override
    public long getNumOfSleepingThreadsInDump(int dumpIndex) {
        return this.dumpInfos[dumpIndex].sleepingThreads;
    }

    @Override
    public long getNumOfIOThreadsInDump(int dumpIndex) {
        return this.dumpInfos[dumpIndex].ioThreads;
    }

    @Override
    public long getTimestampThreadDump(int dumpIndex) {
        return this.dumpInfos[dumpIndex].timestamp;
    }

    @Override
    public long getCPUTimeThreadDump(int dumpIndex) {
        return this.dumpInfos[dumpIndex].cpu;
    }

    @Override
    public long getTotalCPUTime() {
        return this.totalCPU;
    }

    @Override
    public long getFileIOThreadDump(int dumpIndex) {
        return this.dumpInfos[dumpIndex].fileIO;
    }

    @Override
    public long getTotalFileIO() {
        return this.totalFileIO;
    }

    @Override
    public long getSocketIOThreadDump(int dumpIndex) {
        return this.dumpInfos[dumpIndex].socketIO;
    }

    @Override
    public long getTotalSocketIO() {
        return this.totalSocketIO;
    }

    @Override
    public int getMaxNumThreads() {
        return this.maxNumThreads;
    }

    @Override
    public boolean isThreadDumpDeadlocked(int dumpIndex) {
        return this.dumpInfos[dumpIndex].deadlocked;
    }

    @Override
    public boolean hasJavaThreadIdData() {
        return this.hasJavaThreadIdData;
    }

    @Override
    public boolean hasElapsedTimeData() {
        return this.hasElapsedTimeData;
    }

    public static class ThreadDumpInfo {
        long timestamp;
        int numThreads;
        long cpu;
        long fileIO;
        long socketIO;
        long runningThreads;
        long waitingThreads;
        long sleepingThreads;
        long blockedThreads;
        long ioThreads;
        boolean deadlocked;

        public static ThreadDumpInfo read(ResourceReader reader) throws EOFException {
            ThreadDumpInfo result = new ThreadDumpInfo();
            result.timestamp = reader.readInt64();
            result.numThreads = reader.readInt32();
            result.cpu = reader.readInt64();
            result.fileIO = reader.readInt64();
            result.socketIO = reader.readInt64();
            result.deadlocked = reader.readBoolean();
            result.runningThreads = reader.readInt64();
            result.waitingThreads = reader.readInt64();
            result.sleepingThreads = reader.readInt64();
            result.blockedThreads = reader.readInt64();
            result.ioThreads = reader.readInt64();
            return result;
        }

        public void write(PacketResourceWriter writer) throws IOException {
            writer.writeInt64(this.timestamp);
            writer.writeInt32(this.numThreads);
            writer.writeInt64(this.cpu);
            writer.writeInt64(this.fileIO);
            writer.writeInt64(this.socketIO);
            writer.writeBoolean(this.deadlocked);
            writer.writeInt64(this.runningThreads);
            writer.writeInt64(this.waitingThreads);
            writer.writeInt64(this.sleepingThreads);
            writer.writeInt64(this.blockedThreads);
            writer.writeInt64(this.ioThreads);
        }
    }
}

