/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.thread.ThreadDumpIterator;
import com.sap.jvm.profiling.snapshot.impl.thread.ThreadDumpValueImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.ThreadDumpValuesColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.ThreadDumpValuesSerializer;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpStatistic;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpValue;
import com.sap.jvm.profiling.snapshot.util.column.LongColumn;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import java.io.IOException;

public final class ThreadDumpStatisticImpl
extends ValueStatisticImpl<Long, ThreadDumpValue>
implements ThreadDumpStatistic {
    protected ThreadDumpStatisticImpl(ResourceName name) {
        super(name, new LongColumn(), new ThreadDumpValuesColumnImpl(), new ThreadDumpValuesSerializer());
    }

    public ThreadDumpStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the thread dump ... (<%> %)"), reporter);
    }

    public static ThreadDumpStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        ValueStatisticCollector<Long, ThreadDumpValue> collector = new ValueStatisticCollector<Long, ThreadDumpValue>(ThreadDumpValueImpl.EMPTY);
        ThreadDumpIterator it = new ThreadDumpIterator(name, reporter, I18n._s((String)"Creating the thread dump ... (<%> %)"));
        ThreadDump threadDump = it.getThreadDump();
        for (ThreadDumpItem threadDumpItem : threadDump.getThreadDumpItems()) {
            ThreadDumpValueImpl val = new ThreadDumpValueImpl(threadDumpItem, threadDump, 1, name.getSession());
            collector.add(Long.valueOf(threadDumpItem.getThreadIndex()), val);
        }
        ThreadDumpStatisticImpl result = new ThreadDumpStatisticImpl(name);
        collector.fillStatistic(result);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the thread dump ... (<%> %)"), reporter);
    }
}

