/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.core.type.MonitorObjectUsage;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.impl.thread.ThreadDumpTreeItemImpl;
import com.sap.jvm.profiling.snapshot.impl.thread.ThreadDumpValueImpl;
import com.sap.jvm.profiling.snapshot.impl.thread.ThreadDumpValueTreeNodeImpl;
import com.sap.jvm.profiling.snapshot.impl.thread.ThreadRunIterator;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpTree;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpTreeItem;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpTreeItemType;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpValue;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpValueTreeNode;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ThreadDumpTreeCreator {
    private ProfilingSession session;

    public ThreadDumpTreeCreator(ResourceName resourceName) {
        this.session = resourceName.getSession();
    }

    public void fillIn(ThreadDumpTree tree, ThreadDump threadDump) throws IOException {
        this.fillIn(tree, this.getRoots(threadDump));
    }

    public void fillIn(ThreadDumpTree tree, ThreadRunIterator it) throws IOException {
        this.fillIn(tree, this.getRoots(it));
    }

    private void fillIn(ThreadDumpTree tree, ThreadDumpValueTreeNode[] roots) {
        ThreadDumpValue total = ThreadDumpValueImpl.EMPTY;
        for (ThreadDumpValueTreeNode node : roots) {
            total = total.getSum(((ThreadDumpTreeItem)node.getKey()).getValue());
        }
        tree.initTree(roots, total);
    }

    public void setChildren(ThreadDumpValueTreeNodeImpl startNode, ThreadDump threadDump) throws IOException {
        startNode.setChildren(this.getChildren(startNode, threadDump));
    }

    public void setSubNodes(ThreadDumpValueTreeNodeImpl startNode, ThreadDump threadDump) throws IOException {
    }

    private ThreadDumpValueTreeNode[] getRoots(ThreadDump threadDump) throws IOException {
        ThreadDumpItem[] threadDumpInfos = threadDump.getThreadDumpItems();
        ThreadDumpValueTreeNode[] result = new ThreadDumpValueTreeNodeImpl[threadDumpInfos.length];
        for (int i = 0; i < threadDumpInfos.length; ++i) {
            ThreadDumpTreeItemImpl newEntry = new ThreadDumpTreeItemImpl((ThreadDumpValue)new ThreadDumpValueImpl(threadDumpInfos[i], threadDump, -1, this.session), true);
            ThreadDumpValueTreeNodeImpl newNode = new ThreadDumpValueTreeNodeImpl(null, newEntry, ThreadDumpValueImpl.EMPTY);
            newNode.setHasChildren();
            result[i] = newNode;
        }
        return result;
    }

    private ThreadDumpValueTreeNode[] getRoots(ThreadRunIterator it) throws IOException {
        ArrayList<ThreadDumpItem> items = new ArrayList<ThreadDumpItem>();
        ArrayList<ThreadDump> dumps = new ArrayList<ThreadDump>();
        int minDumpIndex = Integer.MAX_VALUE;
        while (it.isValid()) {
            items.add(it.getThreadDumpItem());
            dumps.add(it.getThreadDump());
            minDumpIndex = Math.min(minDumpIndex, it.getDumpIndex());
            it.next();
        }
        ThreadDumpItem[] threadDumpInfos = items.toArray(new ThreadDumpItem[0]);
        ThreadDumpValueTreeNode[] result = new ThreadDumpValueTreeNodeImpl[threadDumpInfos.length];
        for (int i = 0; i < threadDumpInfos.length; ++i) {
            ThreadDumpTreeItemImpl newEntry = new ThreadDumpTreeItemImpl((ThreadDumpValue)new ThreadDumpValueImpl(threadDumpInfos[i], i > 0 ? threadDumpInfos[i - 1] : null, (ThreadDump)dumps.get(i), minDumpIndex + i, this.session), true);
            ThreadDumpValueTreeNodeImpl newNode = new ThreadDumpValueTreeNodeImpl(null, newEntry, ThreadDumpValueImpl.EMPTY);
            newNode.setHasChildren();
            result[i] = newNode;
        }
        return result;
    }

    private ThreadDumpValueTreeNodeImpl[] getChildren(ThreadDumpValueTreeNodeImpl parentNode, ThreadDump threadDump) {
        LinkedList<Object> resultList = new LinkedList<Object>();
        ThreadDumpValue emptyValue = ThreadDumpValueImpl.EMPTY;
        ThreadDumpTreeItem parentItem = (ThreadDumpTreeItem)parentNode.getKey();
        ThreadDumpValue value = parentItem.getValue();
        ThreadDumpItem threadInfo = parentItem.getValue().getThreadDumpItem();
        if (parentItem.getThreadDumpTreeItemType() == ThreadDumpTreeItemType.THREAD_ROOT_DESCRIPTION || parentItem.getThreadDumpTreeItemType() == ThreadDumpTreeItemType.THREAD_SUB_DESCRIPTION) {
            StackFrames stacktrace = this.session.getStackTraceManager().getStackFramesObject(false);
            stacktrace.fillIn(threadInfo.getStackTraceIndex());
            int nof = stacktrace.getNrOfFrames();
            for (int j = 0; j < nof; ++j) {
                MethodLocation location = stacktrace.getMethodLocation(nof - j - 1);
                ThreadDumpTreeItemImpl newEntry = new ThreadDumpTreeItemImpl(value, location, j);
                ThreadDumpValueTreeNodeImpl newNode = new ThreadDumpValueTreeNodeImpl(parentNode, newEntry, emptyValue);
                resultList.add(newNode);
                if (!(j == 0 && threadInfo.getMonitorObject() != null || threadInfo.getFrameMonitorObjects(j) != null && threadInfo.getFrameMonitorObjects(j).size() > 0) && (j != 0 || threadInfo.getSocketInfo() == null)) continue;
                newNode.setHasChildren();
            }
            List blockingMonitors = threadInfo.getNoFrameMonitorObjects();
            if (blockingMonitors != null && blockingMonitors.size() > 0) {
                for (MonitorObject monitor2 : blockingMonitors) {
                    ThreadDumpTreeItemImpl monitorEntry = new ThreadDumpTreeItemImpl(value, monitor2, MonitorObjectUsage.LOCKED);
                    ThreadDumpValueTreeNodeImpl newNode = new ThreadDumpValueTreeNodeImpl(parentNode, monitorEntry, emptyValue);
                    newNode.setHasChildren();
                    resultList.add(newNode);
                }
            }
        } else if (parentItem.getThreadDumpTreeItemType() == ThreadDumpTreeItemType.THREAD_STACKFRAME) {
            List monitors;
            int frameIndex = parentItem.getFrameIndex();
            if (frameIndex == 0) {
                if (threadInfo.getMonitorObject() != null) {
                    MonitorObjectUsage monitorUsage = threadInfo.getStatus() == ThreadStatus.THREAD_STATUS_OBJECT_WAIT ? MonitorObjectUsage.WAITING : MonitorObjectUsage.BLOCKED;
                    ThreadDumpTreeItemImpl monitorEntry = new ThreadDumpTreeItemImpl(value, threadInfo.getMonitorObject(), monitorUsage);
                    ThreadDumpValueTreeNodeImpl newNode = new ThreadDumpValueTreeNodeImpl(parentNode, monitorEntry, emptyValue);
                    if (threadInfo.hasBlockingThread()) {
                        newNode.setHasChildren();
                    }
                    resultList.add(newNode);
                } else if (threadInfo.getSocketInfo() != null) {
                    ThreadDumpTreeItemImpl socketEntry = new ThreadDumpTreeItemImpl(value, threadInfo.getSocketInfo());
                    ThreadDumpValueTreeNodeImpl newNode = new ThreadDumpValueTreeNodeImpl(parentNode, socketEntry, emptyValue);
                    newNode.setHasNoChildren();
                    resultList.add(newNode);
                }
            }
            if ((monitors = threadInfo.getFrameMonitorObjects(frameIndex)) != null) {
                for (MonitorObject monitor3 : monitors) {
                    ThreadDumpTreeItemImpl monitorEntry = new ThreadDumpTreeItemImpl(value, monitor3, MonitorObjectUsage.LOCKED);
                    ThreadDumpValueTreeNodeImpl newNode = new ThreadDumpValueTreeNodeImpl(parentNode, monitorEntry, emptyValue);
                    newNode.setHasChildren();
                    resultList.add(newNode);
                }
            }
        } else if (parentItem.getThreadDumpTreeItemType() == ThreadDumpTreeItemType.THREAD_LOCKED) {
            for (ThreadDumpItem blockedThreadInfo : threadDump.getThreadDumpItems()) {
                if (blockedThreadInfo.getBlockingThreadIndex() != threadInfo.getThreadIndex() || blockedThreadInfo.getMonitorObject().getObjectId() != parentItem.getMonitorObject().getObjectId()) continue;
                ThreadDumpTreeItemImpl newEntry = new ThreadDumpTreeItemImpl((ThreadDumpValue)new ThreadDumpValueImpl(blockedThreadInfo, threadDump, -1, this.session), false);
                ThreadDumpValueTreeNodeImpl newNode = new ThreadDumpValueTreeNodeImpl(parentNode, newEntry, emptyValue);
                newNode.setHasChildren();
                resultList.add(newNode);
            }
        } else if (parentItem.getThreadDumpTreeItemType() == ThreadDumpTreeItemType.THREAD_BLOCKED || parentItem.getThreadDumpTreeItemType() == ThreadDumpTreeItemType.THREAD_WAITING) {
            assert (threadInfo.hasBlockingThread());
            int blockingThreadIndex = threadInfo.getBlockingThreadIndex();
            ThreadDumpItem blockingThreadInfo = threadDump.getThreadDumpItemWithThreadIndex(blockingThreadIndex);
            assert (blockingThreadInfo != null);
            ThreadDumpTreeItemImpl newEntry = new ThreadDumpTreeItemImpl((ThreadDumpValue)new ThreadDumpValueImpl(blockingThreadInfo, threadDump, -1, this.session), false);
            ThreadDumpValueTreeNodeImpl newNode = new ThreadDumpValueTreeNodeImpl(parentNode, newEntry, emptyValue);
            newNode.setHasChildren();
            resultList.add(newNode);
        } else assert (false);
        return resultList.toArray(new ThreadDumpValueTreeNodeImpl[0]);
    }
}

