/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.impl.thread.ThreadDumpTreeCreator;
import com.sap.jvm.profiling.snapshot.impl.thread.ThreadDumpTreeNodeSerializer;
import com.sap.jvm.profiling.snapshot.impl.thread.ThreadDumpValueTreeNodeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueTreeBaseImpl;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.Serializer;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.ThreadDumpItemSerializer;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.ThreadDumpValuesSerializer;
import com.sap.jvm.profiling.snapshot.thread.Elements;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpSnapshot;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpTree;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpTreeItem;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpValue;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpValueTreeNode;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.snapshot.util.ValueTreeNodeBase;
import com.sap.jvm.profiling.thread.ThreadDump;
import java.io.IOException;

public final class ThreadDumpTreeImpl
extends ValueTreeBaseImpl<ThreadDumpTreeItem, ThreadDumpValue, ThreadDumpValueTreeNode>
implements ThreadDumpTree {
    private ThreadDump threadDump;

    protected ThreadDumpTreeImpl(ResourceName name, Serializer<ThreadDumpTreeItem> keySerializer, Serializer<ThreadDumpValue> valueSerializer) {
        super(name, new ThreadDumpTreeNodeSerializer(keySerializer, valueSerializer), valueSerializer);
    }

    protected ThreadDumpTreeImpl(ResourceName name) {
        this(name, new ThreadDumpItemSerializer(new ThreadDumpValuesSerializer()), new ThreadDumpValuesSerializer());
    }

    public ThreadDumpTreeImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        Elements.CreateThreadDumpTree createThreadDumpTree = (Elements.CreateThreadDumpTree)name.getLastElement();
        int dumpIndex = createThreadDumpTree.getId();
        ThreadDumpSnapshot snapshot = (ThreadDumpSnapshot)SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        ThreadDump[] dumps = snapshot.getThreadDumps(reporter);
        this.threadDump = dumps[dumpIndex];
        new ThreadDumpTreeCreator(name).fillIn((ThreadDumpTree)this, this.threadDump);
    }

    public static ThreadDumpTreeImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        Elements.CreateThreadDumpTree createThreadDumpTree = (Elements.CreateThreadDumpTree)name.getLastElement();
        int dumpIndex = createThreadDumpTree.getId();
        ThreadDumpSnapshot snapshot = (ThreadDumpSnapshot)SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        ThreadDump[] dumps = snapshot.getThreadDumps(reporter);
        ThreadDumpTreeImpl tree = new ThreadDumpTreeImpl(name);
        tree.threadDump = dumps[dumpIndex];
        if (tree.threadDump != null) {
            new ThreadDumpTreeCreator(tree.getResourceName()).fillIn((ThreadDumpTree)tree, tree.threadDump);
        }
        return tree;
    }

    @Override
    public void createChildren(ThreadDumpValueTreeNode node, ProgressReporter reporter) throws IOException {
        assert (node.hasChildren());
        assert (!node.hasCreatedChildren());
        new ThreadDumpTreeCreator(this.getResourceName()).setChildren((ThreadDumpValueTreeNodeImpl)node, this.threadDump);
    }

    @Override
    public void createSubNodes(ThreadDumpValueTreeNode node, ProgressReporter reporter) throws IOException {
        assert (node.hasSubNodes());
        assert (!node.hasCreatedSubNodes());
        new ThreadDumpTreeCreator(this.getResourceName()).setSubNodes((ThreadDumpValueTreeNodeImpl)node, this.threadDump);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        super.write(writer, reporter, I18n._s((String)"Writing the thread dump tree ... (<%> %)"));
    }

    @Override
    public void initTree(ThreadDumpValueTreeNode[] roots, ThreadDumpValue total) {
        super.init((ValueTreeNodeBase[])roots, (Value)total);
    }
}

