/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.core.type.MonitorObjectUsage;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.Serializer;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpTreeItem;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpTreeItemType;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpValue;
import com.sap.jvm.profiling.thread.SocketObject;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ThreadDumpTreeItemImpl
implements ThreadDumpTreeItem {
    private static final int VERSION = 0;
    private final ThreadDumpValue value;
    private final ThreadDumpTreeItemType treeItemType;
    private final MethodLocation methodLocation;
    private final int frameIndex;
    private final MonitorObject monitorObject;
    private final List<MonitorObject> blockingMonitors;
    private SocketObject socketInfo;

    public ThreadDumpTreeItemImpl(ThreadDumpValue threadDumpValue, boolean root) {
        this.value = threadDumpValue;
        this.methodLocation = null;
        this.frameIndex = -1;
        this.monitorObject = null;
        this.blockingMonitors = null;
        this.socketInfo = null;
        this.treeItemType = root ? ThreadDumpTreeItemType.THREAD_ROOT_DESCRIPTION : ThreadDumpTreeItemType.THREAD_SUB_DESCRIPTION;
    }

    public ThreadDumpTreeItemImpl(ThreadDumpValue threadDumpValue, MethodLocation methodLocation, int frameIndex) {
        this.value = threadDumpValue;
        this.methodLocation = methodLocation;
        this.frameIndex = frameIndex;
        this.monitorObject = null;
        this.blockingMonitors = null;
        this.socketInfo = null;
        this.treeItemType = ThreadDumpTreeItemType.THREAD_STACKFRAME;
    }

    public ThreadDumpTreeItemImpl(ThreadDumpValue threadDumpValue, MonitorObject monitorObject, MonitorObjectUsage monitorUsage) {
        this.value = threadDumpValue;
        this.methodLocation = null;
        this.frameIndex = -1;
        this.monitorObject = monitorObject;
        this.blockingMonitors = null;
        this.socketInfo = null;
        this.treeItemType = monitorUsage == MonitorObjectUsage.LOCKED ? ThreadDumpTreeItemType.THREAD_LOCKED : (monitorUsage == MonitorObjectUsage.BLOCKED ? ThreadDumpTreeItemType.THREAD_BLOCKED : (monitorUsage == MonitorObjectUsage.WAITING ? ThreadDumpTreeItemType.THREAD_WAITING : ThreadDumpTreeItemType.UNKNOWN));
    }

    public ThreadDumpTreeItemImpl(ThreadDumpValue threadDumpValue, SocketObject socketInfo) {
        this.value = threadDumpValue;
        this.methodLocation = null;
        this.frameIndex = -1;
        this.monitorObject = null;
        this.blockingMonitors = null;
        this.socketInfo = socketInfo;
        this.treeItemType = ThreadDumpTreeItemType.THREAD_SOCKETINFO;
    }

    public ThreadDumpTreeItemImpl(ResourceReader reader, Serializer<ThreadDumpValue> serializer) throws IOException {
        reader.readVersion(0);
        this.value = serializer.read(reader);
        ThreadDumpTreeItemType itemType = ThreadDumpTreeItemType.UNKNOWN;
        try {
            itemType = ThreadDumpTreeItemType.getThreadDumpTreeItemType(reader.readInt8());
        }
        catch (IllegalArgumentException e) {
            Trace.error((String)e.getMessage());
        }
        this.treeItemType = itemType;
        this.frameIndex = reader.readInt32();
        this.methodLocation = reader.readBoolean() ? reader.readMethodLocation() : null;
        this.monitorObject = reader.readBoolean() ? MonitorObject.read((ResourceReader)reader) : null;
        if (reader.readBoolean()) {
            int listSize = reader.readInt32();
            this.blockingMonitors = new ArrayList<MonitorObject>(listSize);
            for (int i = 0; i < listSize; ++i) {
                this.blockingMonitors.add(MonitorObject.read((ResourceReader)reader));
            }
        } else {
            this.blockingMonitors = null;
        }
        this.socketInfo = reader.readBoolean() ? new SocketObject(reader) : null;
    }

    @Override
    public MethodLocation getMethodLocation() {
        return this.methodLocation;
    }

    @Override
    public int getFrameIndex() {
        return this.frameIndex;
    }

    @Override
    public MonitorObject getMonitorObject() {
        return this.monitorObject;
    }

    @Override
    public List<MonitorObject> getBlockingMonitorObjects() {
        return this.blockingMonitors;
    }

    @Override
    public SocketObject getSocketInfo() {
        return this.socketInfo;
    }

    public ProfilingSession getSession() {
        return this.value.getSession();
    }

    @Override
    public ThreadDumpTreeItemType getThreadDumpTreeItemType() {
        return this.treeItemType;
    }

    @Override
    public boolean isRootItem() {
        return this.treeItemType == ThreadDumpTreeItemType.THREAD_ROOT_DESCRIPTION;
    }

    @Override
    public void write(ResourceWriter writer, Serializer<ThreadDumpValue> serializer) throws IOException {
        writer.writeVersion(0);
        serializer.write(this.value, writer);
        writer.writeInt8(this.treeItemType.getValue());
        writer.writeInt32(this.frameIndex);
        writer.writeBoolean(this.methodLocation != null);
        if (this.methodLocation != null) {
            writer.writeMethodLocation(this.methodLocation);
        }
        writer.writeBoolean(this.monitorObject != null);
        if (this.monitorObject != null) {
            this.monitorObject.write(writer);
        }
        writer.writeBoolean(this.blockingMonitors != null);
        if (this.blockingMonitors != null) {
            writer.writeInt32(this.blockingMonitors.size());
            for (MonitorObject monitor2 : this.blockingMonitors) {
                assert (monitor2 != null);
                monitor2.write(writer);
            }
        }
        writer.writeBoolean(this.socketInfo != null);
        if (this.socketInfo != null) {
            this.socketInfo.write(writer);
        }
    }

    @Override
    public ThreadDumpValue getValue() {
        return this.value;
    }
}

