/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpValue;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import java.io.IOException;

public class ThreadDumpValueImpl
implements ThreadDumpValue {
    private static final int VERSION = 1;
    private final ThreadDumpItem threadDumpItem;
    private final ThreadDumpItem prevThreadDumpItem;
    private final ThreadDump threadDump;
    private final int dumpIndex;
    private final ProfilingSession session;
    public static final ThreadDumpValue EMPTY = new ThreadDumpValueImpl();

    private ThreadDumpValueImpl() {
        this.threadDumpItem = null;
        this.prevThreadDumpItem = null;
        this.session = null;
        this.threadDump = null;
        this.dumpIndex = -1;
    }

    protected ThreadDumpValueImpl(ThreadDumpItem threadDumpItem, ThreadDump threadDump, int dumpIndex, ProfilingSession session) {
        this.threadDumpItem = threadDumpItem;
        this.threadDump = threadDump;
        this.dumpIndex = dumpIndex;
        this.session = session;
        this.prevThreadDumpItem = null;
    }

    protected ThreadDumpValueImpl(ThreadDumpItem threadDumpItem, ThreadDumpItem prevThreadDumpItem, ThreadDump threadDump, int dumpIndex, ProfilingSession session) {
        this.threadDumpItem = threadDumpItem;
        this.prevThreadDumpItem = prevThreadDumpItem;
        this.threadDump = threadDump;
        this.dumpIndex = dumpIndex;
        this.session = session;
    }

    public ThreadDumpValueImpl(ResourceReader reader, ThreadDump threadDump, ThreadDump prevThreadDump) throws IOException {
        int prevThreadIndex;
        int version = reader.readVersion(1, 1);
        int threadIndex = reader.readInt32();
        this.threadDumpItem = threadIndex >= 0 ? threadDump.getThreadDumpItemWithThreadIndex(threadIndex) : null;
        ThreadDumpItem prevThreadDumpItemTmp = null;
        if (version >= 1 && reader.hasNext() && (prevThreadIndex = reader.readInt32()) >= 0 && prevThreadDump != null) {
            prevThreadDumpItemTmp = prevThreadDump.getThreadDumpItemWithThreadIndex(prevThreadIndex);
        }
        this.prevThreadDumpItem = prevThreadDumpItemTmp;
        this.threadDump = threadDump;
        this.dumpIndex = reader.readInt32();
        this.session = reader.getSession();
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(1);
        if (this.threadDumpItem != null) {
            writer.writeInt32(this.threadDumpItem.getThreadIndex());
        } else {
            writer.writeInt32(-1);
        }
        if (this.prevThreadDumpItem != null) {
            writer.writeInt32(this.prevThreadDumpItem.getThreadIndex());
        } else {
            writer.writeInt32(-1);
        }
        writer.writeInt32(this.dumpIndex);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.threadDump.hashCode();
        result = 31 * result + this.threadDumpItem.hashCode();
        result = 31 * result + this.threadDumpItem.getThreadIndex() ^ this.threadDumpItem.getStackTraceIndex();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadDumpValueImpl other = (ThreadDumpValueImpl)obj;
        if (this.threadDump == null ? other.threadDump != null : !this.threadDump.equals(other.threadDump)) {
            return false;
        }
        if (this.threadDumpItem == null ? other.threadDumpItem != null : !this.threadDumpItem.equals(other.threadDumpItem)) {
            return false;
        }
        return this.dumpIndex == other.dumpIndex;
    }

    @Override
    public ThreadDumpValue getSum(ThreadDumpValue toAdd) {
        ThreadDumpValue first = this;
        ThreadDumpValue second = toAdd;
        if (first == EMPTY) {
            ThreadDumpValueImpl tmp = first;
            first = second;
            second = tmp;
        }
        if (first == EMPTY) {
            return EMPTY;
        }
        assert (first.getThreadDumpItem() != null);
        ThreadDumpValueImpl result = new ThreadDumpValueImpl(first.getThreadDumpItem().createEmptyItem(), this.threadDump, -1, first.getSession());
        result.getThreadDumpItem().add(first.getThreadDumpItem());
        if (second != EMPTY) {
            assert (second.getThreadDumpItem() != null);
            result.getThreadDumpItem().add(second.getThreadDumpItem());
        }
        return result;
    }

    @Override
    public ThreadDumpItem getThreadDumpItem() {
        return this.threadDumpItem;
    }

    @Override
    public ThreadDump getThreadDump() {
        return this.threadDump;
    }

    public ProfilingSession getSession() {
        return this.session;
    }

    @Override
    public int getDumpIndex() {
        return this.dumpIndex;
    }

    @Override
    public ThreadDumpItem getPrevThreadDumpItem() {
        return this.prevThreadDumpItem;
    }
}

