/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.thread.ThreadDumpTreeCreator;
import com.sap.jvm.profiling.snapshot.impl.thread.ThreadDumpTreeNodeSerializer;
import com.sap.jvm.profiling.snapshot.impl.thread.ThreadDumpValueTreeNodeImpl;
import com.sap.jvm.profiling.snapshot.impl.thread.ThreadRunIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueTreeBaseImpl;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.Serializer;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.ThreadDumpItemSerializer;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.ThreadDumpValuesSerializer;
import com.sap.jvm.profiling.snapshot.thread.Elements;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpTree;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpTreeItem;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpValue;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpValueTreeNode;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.snapshot.util.ValueTreeNodeBase;
import com.sap.jvm.profiling.thread.ThreadDump;
import java.io.IOException;

public final class ThreadRunTreeImpl
extends ValueTreeBaseImpl<ThreadDumpTreeItem, ThreadDumpValue, ThreadDumpValueTreeNode>
implements ThreadDumpTree {
    int threadIndex = -1;

    protected ThreadRunTreeImpl(ResourceName name, Serializer<ThreadDumpTreeItem> keySerializer, Serializer<ThreadDumpValue> valueSerializer) {
        super(name, new ThreadDumpTreeNodeSerializer(keySerializer, valueSerializer), valueSerializer);
    }

    protected ThreadRunTreeImpl(ResourceName name) {
        this(name, new ThreadDumpItemSerializer(new ThreadDumpValuesSerializer()), new ThreadDumpValuesSerializer());
        Elements.CreateThreadRunTree createTree = (Elements.CreateThreadRunTree)this.getResourceName().getLastElement();
        this.threadIndex = createTree.getId();
    }

    public ThreadRunTreeImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        Elements.CreateThreadRunTree createTree = (Elements.CreateThreadRunTree)name.getLastElement();
        this.threadIndex = createTree.getId();
        ThreadRunIterator it = new ThreadRunIterator(name, reporter, this.threadIndex, I18n._s((String)"Creating the thread run ... (<%> %)"));
        new ThreadDumpTreeCreator(name).fillIn((ThreadDumpTree)this, it);
    }

    public static ThreadRunTreeImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        Elements.CreateThreadRunTree createTree = (Elements.CreateThreadRunTree)name.getLastElement();
        int threadIndex = createTree.getId();
        ThreadRunIterator it = new ThreadRunIterator(name, reporter, threadIndex, I18n._s((String)"Creating the thread run ... (<%> %)"));
        ThreadRunTreeImpl tree = new ThreadRunTreeImpl(name);
        new ThreadDumpTreeCreator(tree.getResourceName()).fillIn((ThreadDumpTree)tree, it);
        return tree;
    }

    @Override
    public void createChildren(ThreadDumpValueTreeNode node, ProgressReporter reporter) throws IOException {
        assert (node.hasChildren());
        assert (!node.hasCreatedChildren());
        ThreadDump threadDump = ((ThreadDumpTreeItem)node.getKey()).getValue().getThreadDump();
        new ThreadDumpTreeCreator(this.getResourceName()).setChildren((ThreadDumpValueTreeNodeImpl)node, threadDump);
    }

    @Override
    public void createSubNodes(ThreadDumpValueTreeNode node, ProgressReporter reporter) throws IOException {
        assert (node.hasSubNodes());
        assert (!node.hasCreatedSubNodes());
        ThreadDump threadDump = ((ThreadDumpTreeItem)node.getKey()).getValue().getThreadDump();
        new ThreadDumpTreeCreator(this.getResourceName()).setSubNodes((ThreadDumpValueTreeNodeImpl)node, threadDump);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        super.write(writer, reporter, I18n._s((String)"Writing the thread run tree ... (<%> %)"));
    }

    @Override
    public void initTree(ThreadDumpValueTreeNode[] roots, ThreadDumpValue total) {
        super.init((ValueTreeNodeBase[])roots, (Value)total);
    }
}

