/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread.compare.hints;

import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.BlockingLockInfo;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class BlockingLockInfoImpl
implements BlockingLockInfo {
    private MonitorObject lock;
    private Set<Integer> blockingThreadIndices = new HashSet<Integer>();
    private List<ThreadDumpItem> blockingItems;
    private Set<Integer> blockedStackTraceIndices = new HashSet<Integer>();
    private List<ThreadDumpItem> blockedItems = new LinkedList<ThreadDumpItem>();
    private long blockedTime = 0L;

    public BlockingLockInfoImpl(MonitorObject lock) {
        this.blockingItems = new LinkedList<ThreadDumpItem>();
        this.lock = lock;
    }

    public void handleBlockedTime(ThreadDumpItem blockingItem, ThreadDumpItem blockedItem, long curBlockedTime) {
        int stackTraceIndex;
        this.blockedTime += curBlockedTime;
        int blockingStackIndex = blockingItem.getStackTraceIndex();
        if (!this.blockingThreadIndices.contains(blockingStackIndex)) {
            this.blockingThreadIndices.add(blockingStackIndex);
            this.blockingItems.add(blockingItem);
        }
        if (!this.blockedStackTraceIndices.contains(stackTraceIndex = blockedItem.getStackTraceIndex())) {
            this.blockedStackTraceIndices.add(stackTraceIndex);
            this.blockedItems.add(blockedItem);
        }
    }

    @Override
    public long getBlockedTime() {
        return this.blockedTime;
    }

    @Override
    public MonitorObject getLock() {
        return this.lock;
    }

    @Override
    public List<ThreadDumpItem> getBlockedThreadItems() {
        return this.blockedItems;
    }

    @Override
    public List<ThreadDumpItem> getBlockingThreads() {
        return this.blockingItems;
    }
}

