/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread.compare.hints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class Characteristics {
    private final int num;
    private final double min;
    private final double max;
    private final double median;
    private final double avg;
    private final double sum;
    private final double deviation;

    public Characteristics(double[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Need at least a single element");
        }
        Arrays.sort(values);
        this.num = values.length;
        this.min = values[0];
        this.max = values[values.length - 1];
        int medianIndex = values.length / 2 - 1;
        medianIndex = Math.max(medianIndex, 0);
        this.median = values[medianIndex];
        double expectation = 0.0;
        double squareExpectation = 0.0;
        for (double value : values) {
            expectation += value;
            squareExpectation += value * value;
        }
        this.sum = expectation;
        expectation = this.avg = this.sum / (double)this.num;
        double variance = (squareExpectation /= (double)this.num) - expectation * expectation;
        assert (variance >= 0.0);
        this.deviation = Math.sqrt(variance);
    }

    public int getNum() {
        return this.num;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getMedian() {
        return this.median;
    }

    public double getAvg() {
        return this.avg;
    }

    public double getSum() {
        return this.sum;
    }

    public double getDeviation() {
        return this.deviation;
    }

    public static <H> List<H> apply(Collection<H> objects, ValueGetter<H> getter) {
        ArrayList<H> result = new ArrayList<H>(objects.size());
        if (objects.isEmpty()) {
            return result;
        }
        double[] values = new double[objects.size()];
        int i = 0;
        for (H obj : objects) {
            values[i++] = getter.getValue(obj);
        }
        Characteristics chars = new Characteristics(values);
        for (H obj : objects) {
            if (!getter.applyCharacteristics(obj, chars)) continue;
            result.add(obj);
        }
        return result;
    }

    public static interface ValueGetter<H> {
        public double getValue(H var1);

        public boolean applyCharacteristics(H var1, Characteristics var2);
    }
}

