/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread.compare.hints;

import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.BlockingLockInfoImpl;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.Characteristics;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpHintImpl;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.BlockingLockInfo;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintBlockedThread;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintConfidence;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintUrgency;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;
import com.sap.jvm.profiling.thread.ThreadStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ThreadDumpHintBlockedThreadImpl
extends ThreadDumpHintImpl
implements ThreadDumpHintBlockedThread {
    private int blockedThreadIndex;
    private long blockedTime = 0L;
    private double expectedBlockedTime = 0.0;
    private long runnableTime;
    private long totalBlockedTime;
    private Map<MonitorObject, BlockingLockInfo> blockingLockInfos;
    private static final Set<String> falsePositives = Collections.unmodifiableSet(ThreadDumpHintBlockedThreadImpl.falsePositives());

    protected ThreadDumpHintBlockedThreadImpl(int blockedThreadIndex, long runnableTime, ThreadDumpsSummary summary) {
        super(ThreadDumpHintUrgency.NOTE, ThreadDumpHintConfidence.S, summary, 0.0);
        this.runnableTime = runnableTime;
        this.blockedThreadIndex = blockedThreadIndex;
        this.blockingLockInfos = new HashMap<MonitorObject, BlockingLockInfo>();
    }

    public void handleBlockedThread(MonitorObject lock, ThreadDumpItem blockingThreadItem, ThreadDumpItem blockedThreadItem, long curBlockedTime) {
        this.blockedTime += curBlockedTime;
        BlockingLockInfoImpl blockingLockInfo = (BlockingLockInfoImpl)this.blockingLockInfos.get(lock);
        if (blockingLockInfo == null) {
            blockingLockInfo = new BlockingLockInfoImpl(lock);
            this.blockingLockInfos.put(lock, blockingLockInfo);
        }
        blockingLockInfo.handleBlockedTime(blockingThreadItem, blockedThreadItem, curBlockedTime);
    }

    public static List<ThreadDumpHintBlockedThreadImpl> generateHints(ThreadDumpsSummary summary) {
        ArrayList<ThreadDumpHintBlockedThreadImpl> allHints = new ArrayList<ThreadDumpHintBlockedThreadImpl>();
        ThreadDumps threadDumps = summary.getThreadDumps();
        for (int threadRunIndex = 0; threadRunIndex < threadDumps.getNumThreads(); ++threadRunIndex) {
            ThreadDumpItem[] threadRun = threadDumps.getThreadRun(threadRunIndex);
            assert (threadRun.length == threadDumps.getNumDumps());
            ThreadDumpHintBlockedThreadImpl hint = null;
            for (int dumpIndex = 1; dumpIndex < threadRun.length; ++dumpIndex) {
                ThreadDumpItem lastItem = threadRun[dumpIndex - 1];
                ThreadDumpItem item = threadRun[dumpIndex];
                if (item == null || lastItem == null) continue;
                if (item.getStatus() != ThreadStatus.THREAD_STATUS_LOCK_WAIT || !item.hasBlockingThread() || !lastItem.hasBlockingThread() || !item.getMonitorObject().equals((Object)lastItem.getMonitorObject()) || threadDumps.hasProgress(lastItem, item) || ThreadDumpHintBlockedThreadImpl.filterFalsePositives(item, summary)) {
                    if (hint == null) continue;
                    super.handleReleasedThread();
                    continue;
                }
                if (hint == null) {
                    int[] threadRange = summary.getThreadDumps().getThreadRunRange(threadRunIndex);
                    long threadTime = summary.getElapsedTimeDiff(threadRange[0], threadRange[1]);
                    hint = new ThreadDumpHintBlockedThreadImpl(threadRunIndex, threadTime, summary);
                    allHints.add(hint);
                }
                int blockingThreadRunIndex = threadDumps.threadIndex2ThreadRunIndex(dumpIndex, item.getBlockingThreadIndex());
                ThreadDumpItem blockingThreadItem = threadDumps.getThreadDumpItem(dumpIndex, blockingThreadRunIndex);
                long blockedTime = summary.getElapsedTimeDiff(dumpIndex - 1, dumpIndex);
                hint.handleBlockedThread(item.getMonitorObject(), blockingThreadItem, item, blockedTime);
            }
        }
        return Characteristics.apply(allHints, new Characteristics.ValueGetter<ThreadDumpHintBlockedThreadImpl>(){

            @Override
            public double getValue(ThreadDumpHintBlockedThreadImpl hint) {
                return hint.getBlockedTime();
            }

            @Override
            public boolean applyCharacteristics(ThreadDumpHintBlockedThreadImpl hint, Characteristics chars) {
                hint.calcImportance(chars);
                return hint.getImportance() > 0.0;
            }
        });
    }

    private static Set<String> falsePositives() {
        HashSet<String> result = new HashSet<String>();
        result.add("com.sap.engine.services.cross.fca.FCAConnectorImpl.readMessage(com.sap.engine.services.cross.fca.MessageReader)com.sap.engine.interfaces.cross.CrossMessage");
        result.add("sun.nio.ch.ServerSocketChannelImpl.accept()java.nio.channels.SocketChannel");
        result.add("com.sap.engine.services.httpserver.server.rcm.PostponedQueue.poll(java.lang.String)com.sap.bc.proj.jstartup.fca.FCAConnection");
        return result;
    }

    private static boolean filterFalsePositives(ThreadDumpItem item, ThreadDumpsSummary summary) {
        StackFrames frames = summary.getThreadDumps().getStackFrame(item.getStackTraceIndex());
        MethodObject topMethod = frames.getTopMethod();
        return falsePositives.contains(topMethod.getFullName());
    }

    private void handleReleasedThread() {
    }

    public String toString() {
        ThreadDumpItem item = this.getSummary().getThreadDumps().getThreadRunHead(this.blockedThreadIndex);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Detected blocked thread %s. BlockedTime: %d\n", item.getName().toString(), this.blockedTime));
        return sb.toString();
    }

    public void calcImportance(Characteristics chars) {
        this.expectedBlockedTime = chars.getAvg();
        this.totalBlockedTime = (long)chars.getSum();
        int[] threadRange = this.getSummary().getThreadDumps().getThreadRunRange(this.blockedThreadIndex);
        long totalTime = this.getSummary().getElapsedTimeDiff();
        long threadTime = this.getSummary().getElapsedTimeDiff(threadRange[0], threadRange[1]);
        assert (0L < this.blockedTime && this.blockedTime <= totalTime && threadTime <= totalTime);
        double percentage = (double)this.blockedTime / (double)totalTime * ((double)threadTime / (double)totalTime);
        if (this.expectedBlockedTime > 0.0) {
            percentage *= (double)this.blockedTime / this.expectedBlockedTime;
        }
        this.importance = ThreadDumpHintBlockedThreadImpl.getPercentage(percentage, 3.5);
    }

    @Override
    public Collection<BlockingLockInfo> getThreadBlockedInfo() {
        return this.blockingLockInfos.values();
    }

    @Override
    public long getBlockedTime() {
        return this.blockedTime;
    }

    @Override
    public double getExpectedBlockedTime() {
        return this.expectedBlockedTime;
    }

    @Override
    public int getBlockedThreadIndex() {
        return this.blockedThreadIndex;
    }

    @Override
    public long getRunnableTime() {
        return this.runnableTime;
    }

    @Override
    public long getTotalBlockedTime() {
        return this.totalBlockedTime;
    }
}

