/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread.compare.hints;

import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpHintImpl;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintBusyLoop;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintConfidence;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintUrgency;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;
import com.sap.jvm.profiling.thread.ThreadStatus;
import java.util.LinkedList;
import java.util.List;

public class ThreadDumpHintBusyLoopImpl
extends ThreadDumpHintImpl
implements ThreadDumpHintBusyLoop {
    private final int threadRunIndex;
    private final int dumpIndex;
    private int stackPrefix;
    private double cpuRatio;

    protected ThreadDumpHintBusyLoopImpl(int threadRunIndex, int dumpIndex, int stackPrefix, double cpuRatio, int percentage, ThreadDumpsSummary summary) {
        super(ThreadDumpHintUrgency.WARNING, ThreadDumpHintConfidence.getByProbability(percentage), summary, (double)percentage / 100.0);
        this.threadRunIndex = threadRunIndex;
        this.dumpIndex = dumpIndex;
        this.stackPrefix = stackPrefix;
        this.cpuRatio = Math.min(cpuRatio, 1.0);
    }

    private static boolean liveLockState(ThreadStatus status) {
        return status == ThreadStatus.THREAD_STATUS_RUNNING;
    }

    public static List<ThreadDumpHintBusyLoopImpl> generateHints(ThreadDumpsSummary summary) {
        LinkedList<ThreadDumpHintBusyLoopImpl> result = new LinkedList<ThreadDumpHintBusyLoopImpl>();
        ThreadDumps threadDumps = summary.getThreadDumps();
        for (int threadRunIndex = 0; threadRunIndex < threadDumps.getNumThreads(); ++threadRunIndex) {
            ThreadDumpItem item;
            int runIndex;
            int runEndIndex;
            ThreadDumpItem[] threadRun = threadDumps.getThreadRun(threadRunIndex);
            if (!ThreadDumpHintBusyLoopImpl.liveLockState(threadRun[runEndIndex = threadDumps.getThreadRunEndIndex(threadRun)].getStatus())) continue;
            int stacktraceId = threadRun[runEndIndex].getStackTraceIndex();
            StackFrames endStack = threadDumps.getStackFrame(stacktraceId);
            int maxCommonFrames = endStack.getNrOfFrames();
            for (runIndex = runEndIndex; runIndex >= 0 && (item = threadRun[runIndex]) != null && ThreadDumpHintBusyLoopImpl.liveLockState(item.getStatus()); --runIndex) {
                if (item.getStackTraceIndex() == stacktraceId) continue;
                StackFrames curStack = threadDumps.getStackFrame(item.getStackTraceIndex());
                maxCommonFrames = threadDumps.getStackPrefix(curStack, endStack, maxCommonFrames);
                stacktraceId = item.getStackTraceIndex();
            }
            if (++runIndex >= runEndIndex) continue;
            long elapsed = summary.getElapsedTimeDiff(runIndex, runEndIndex);
            long cpuEnd = threadRun[runEndIndex].getCpuTime(false);
            double sumSquaredFrameDist = 0.0;
            double sumFrameDist = 0.0;
            double pmax = 0.0;
            int dumpIndexMax = -1;
            for (int i = 1; i <= runEndIndex - runIndex; ++i) {
                double p2;
                double p1;
                double p;
                int curIndex = runEndIndex - i;
                ThreadDumpItem item2 = threadRun[curIndex];
                StackFrames curStack = threadDumps.getStackFrame(item2.getStackTraceIndex());
                int stackVar = curStack.getNrOfFrames() - maxCommonFrames;
                assert (stackVar >= 0);
                double spread = ((sumSquaredFrameDist += (double)(stackVar * stackVar)) - (sumFrameDist += (double)stackVar) * sumFrameDist / (double)(i + 1)) / (double)i;
                spread = Math.sqrt(spread);
                double cpuDiff = (cpuEnd - item2.getCpuTime(false)) / 1000000L;
                double p0 = cpuDiff / (double)elapsed;
                p0 = Math.min(1.0, p0);
                if (maxCommonFrames == 0 && spread == 0.0 || Double.isNaN(p = p0 * (p1 = (double)maxCommonFrames / ((double)maxCommonFrames + spread)) * (p2 = (double)(elapsed / summary.getElapsedTimeDiff())))) continue;
                assert (p >= 0.0 && p <= 1.0);
                if (!(p > pmax)) continue;
                pmax = p;
                dumpIndexMax = curIndex;
            }
            int percentage = (int)Math.round(pmax * 100.0);
            if (dumpIndexMax < 0 || percentage <= 10) continue;
            double cpuDiff = (cpuEnd - threadRun[dumpIndexMax].getCpuTime(false)) / 1000000L;
            double ratio = cpuDiff / (double)elapsed;
            ThreadDumpHintBusyLoopImpl hint = new ThreadDumpHintBusyLoopImpl(threadRunIndex, dumpIndexMax, maxCommonFrames, ratio, percentage, summary);
            result.add(hint);
        }
        return result;
    }

    public String toString() {
        ThreadDumpItem startItem = this.getSummary().getThreadDumps().getThreadDumpItem(this.dumpIndex, this.threadRunIndex);
        return String.format("Detected Livelock [hintUrgency=%s, confidence=%s %d%%]: Thread '%s' at %s", new Object[]{this.getUrgency(), this.getConfidence().getDescription(), (int)(100.0 * this.getImportance()), this.toString(startItem), this.toString(this.dumpIndex)});
    }

    @Override
    public int getThreadRunIndex() {
        return this.threadRunIndex;
    }

    @Override
    public int getThreadDumpIndex() {
        return this.dumpIndex;
    }

    @Override
    public int getStackBottomPrefix() {
        return this.stackPrefix;
    }

    @Override
    public double getCPURatio() {
        return this.cpuRatio;
    }
}

