/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread.compare.hints;

import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpHintImpl;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintConfidence;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintDeadlock;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintUrgency;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ThreadDumpHintDeadlockImpl
extends ThreadDumpHintImpl
implements ThreadDumpHintDeadlock {
    final List<ThreadDumpItem> deadlockCycle;
    final int dumpIndex;
    final Map<Integer, List<ThreadDumpItem>> blockedThreads;
    final Set<ThreadDumpItem> blockedThreadHeads;

    protected ThreadDumpHintDeadlockImpl(ThreadDumpItem deadlockCycleHead, int dumpIndex, ThreadDumpsSummary summary) {
        super(ThreadDumpHintUrgency.ERROR, ThreadDumpHintConfidence.S, summary, 1.0);
        this.dumpIndex = dumpIndex;
        this.blockedThreads = new TreeMap<Integer, List<ThreadDumpItem>>();
        this.blockedThreadHeads = new HashSet<ThreadDumpItem>();
        ThreadDumps threadDumps = summary.getThreadDumps();
        this.deadlockCycle = new LinkedList<ThreadDumpItem>();
        ThreadDumpItem curItem = deadlockCycleHead;
        int cycleIndex = deadlockCycleHead.getDeadlockCycleIndex();
        assert (cycleIndex > 0);
        do {
            int blockingIndex = curItem.getBlockingThreadIndex();
            int threadRunIndex = threadDumps.threadIndex2ThreadRunIndex(dumpIndex, blockingIndex);
            curItem = threadDumps.getThreadDumpItem(dumpIndex, threadRunIndex);
            assert (curItem.getDeadlockCycleIndex() == cycleIndex);
            this.deadlockCycle.add(curItem);
        } while (curItem != deadlockCycleHead);
    }

    private void addBlockedThread(ThreadDumpItem item, int itemsDumpIndex) {
        int threadRunIndex;
        ThreadDumps threadDumps = this.getSummary().getThreadDumps();
        ThreadDumpItem headItem = threadDumps.getThreadRunHead(threadRunIndex = threadDumps.threadIndex2ThreadRunIndex(itemsDumpIndex, item.getThreadIndex()));
        if (!this.blockedThreadHeads.contains(headItem)) {
            this.blockedThreadHeads.add(headItem);
            List<ThreadDumpItem> items = this.blockedThreads.get(itemsDumpIndex);
            if (items == null) {
                items = new ArrayList<ThreadDumpItem>();
            }
            items.add(headItem);
            this.blockedThreads.put(itemsDumpIndex, items);
        }
    }

    private boolean isDeadlocked(ThreadDumpItem testItem) {
        for (ThreadDumpItem deadlockItem : this.deadlockCycle) {
            if (!this.getSummary().getThreadDumps().isSameThreadRun(deadlockItem, testItem)) continue;
            return true;
        }
        return false;
    }

    public static List<ThreadDumpHintDeadlockImpl> generateHints(ThreadDumpsSummary summary) {
        LinkedList<ThreadDumpHintDeadlockImpl> result = new LinkedList<ThreadDumpHintDeadlockImpl>();
        ThreadDumps dumps = summary.getThreadDumps();
        for (int dumpIndex = 0; dumpIndex < dumps.getNumDumps(); ++dumpIndex) {
            ThreadDump dump = dumps.getThreadDumps()[dumpIndex];
            ThreadDumpItem[] items = (ThreadDumpItem[])dump.getThreadDumpItems().clone();
            Arrays.sort(items, new Comparator<ThreadDumpItem>(){

                @Override
                public int compare(ThreadDumpItem o1, ThreadDumpItem o2) {
                    int d2;
                    int d1 = o1.getDeadlockCycleIndex();
                    return d1 == (d2 = o2.getDeadlockCycleIndex()) ? 0 : (d1 < d2 ? 1 : -1);
                }
            });
            HashMap<Integer, ThreadDumpHintDeadlockImpl> cycleHints = new HashMap<Integer, ThreadDumpHintDeadlockImpl>();
            for (ThreadDumpItem item : items) {
                ThreadDumpHintDeadlockImpl cycleHint;
                int cycleIndex = item.getDeadlockCycleIndex();
                int blockingCycleIndex = item.getBlockedDeadlockCycleIndex();
                assert (cycleIndex <= 0 || blockingCycleIndex <= 0);
                if (cycleIndex > 0) {
                    if (cycleHints.get(cycleIndex) != null) continue;
                    cycleHint = null;
                    for (ThreadDumpHintDeadlockImpl hint : result) {
                        if (!hint.isDeadlocked(item)) continue;
                        cycleHint = hint;
                        break;
                    }
                    if (cycleHint == null) {
                        cycleHint = new ThreadDumpHintDeadlockImpl(item, dumpIndex, summary);
                        result.add(cycleHint);
                    }
                    cycleHints.put(cycleIndex, cycleHint);
                    continue;
                }
                if (blockingCycleIndex <= 0) continue;
                cycleHint = (ThreadDumpHintDeadlockImpl)cycleHints.get(blockingCycleIndex);
                assert (cycleHint != null);
                cycleHint.addBlockedThread(item, dumpIndex);
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(String.format("Detected deadlock cycle [hintUrgency=%s, confidence=%s]:\n", new Object[]{this.getUrgency(), this.getConfidence().getDescription()}));
        for (ThreadDumpItem item : this.deadlockCycle) {
            result.append('\t');
            result.append(this.toString(item));
            result.append('\n');
        }
        return result.toString();
    }

    @Override
    public List<ThreadDumpItem> getDeadlockCycle() {
        return this.deadlockCycle;
    }

    @Override
    public int getDumpIndex() {
        return this.dumpIndex;
    }

    @Override
    public Map<Integer, List<ThreadDumpItem>> getBlockedThreads() {
        return this.blockedThreads;
    }

    @Override
    public Set<ThreadDumpItem> getBlockedThreadHeads() {
        return this.blockedThreadHeads;
    }
}

