/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread.compare.hints;

import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.Characteristics;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpHintImpl;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintConfidence;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintHotspot;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintUrgency;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;
import com.sap.jvm.profiling.thread.ThreadStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThreadDumpHintHotspotImpl
extends ThreadDumpHintImpl
implements ThreadDumpHintHotspot {
    private final int hits;
    private final int totalHits;
    private List<ThreadDumpHintHotspot.StackPrefixInfo> stackPrefixInfo;
    private final MethodObject hotspotMethod;

    protected ThreadDumpHintHotspotImpl(int hits, int totalHits, MethodObject hotspot, List<ThreadDumpHintHotspot.StackPrefixInfo> stackPrefixInfo, ThreadDumpsSummary summary) {
        super(ThreadDumpHintUrgency.NOTE, ThreadDumpHintConfidence.S, summary, 0.0);
        this.hits = hits;
        this.totalHits = totalHits;
        this.hotspotMethod = hotspot;
        this.stackPrefixInfo = stackPrefixInfo;
    }

    protected void calcImportance(Characteristics chars) {
        double dist = (double)this.hits - chars.getAvg();
        this.importance = (dist > chars.getDeviation() || (double)this.hits >= 0.25 * (double)this.totalHits) && chars.getDeviation() > 0.0 ? ThreadDumpHintHotspotImpl.getPercentage(dist / chars.getDeviation() * (double)this.hits / chars.getSum(), 2.0) : (this.totalHits > 0 && (chars.getNum() == 1 || dist <= Double.MIN_VALUE) ? (double)(this.hits / this.totalHits) : 0.0);
    }

    public static List<ThreadDumpHintHotspotImpl> generateHints(ThreadDumpsSummary summary) {
        class MethodInfo {
            int total = 0;
            Map<Integer, List<ThreadDumpItem>> stackInfo = new HashMap<Integer, List<ThreadDumpItem>>();
            final /* synthetic */ ThreadDumpsSummary val$summary;

            MethodInfo(ThreadDumpsSummary threadDumpsSummary) {
                this.val$summary = threadDumpsSummary;
            }

            public void add(ThreadDumpItem item) {
                List<ThreadDumpItem> itemList = this.stackInfo.get(item.getStackTraceIndex());
                if (itemList == null) {
                    itemList = new ArrayList<ThreadDumpItem>();
                    this.stackInfo.put(item.getStackTraceIndex(), itemList);
                }
                itemList.add(item);
                ++this.total;
            }

            public int getTotal() {
                return this.total;
            }

            public List<ThreadDumpHintHotspot.StackPrefixInfo> calcStackInfo() {
                ArrayList<ThreadDumpHintHotspot.StackPrefixInfo> sortedStackPrefixes = new ArrayList<ThreadDumpHintHotspot.StackPrefixInfo>();
                for (List<ThreadDumpItem> sameStackItems : this.stackInfo.values()) {
                    StackFrames stackFrames = this.val$summary.getThreadDumps().getStackFrame(sameStackItems.get(0).getStackTraceIndex());
                    ThreadDumpHintHotspot.StackPrefixInfo currentPrefix = new ThreadDumpHintHotspot.StackPrefixInfo(sameStackItems, stackFrames.getNrOfFrames(), stackFrames);
                    ThreadDumpHintHotspotImpl.addOrMergeSimilar(sortedStackPrefixes, currentPrefix);
                }
                Collections.sort(sortedStackPrefixes, new Comparator<ThreadDumpHintHotspot.StackPrefixInfo>(){

                    @Override
                    public int compare(ThreadDumpHintHotspot.StackPrefixInfo o1, ThreadDumpHintHotspot.StackPrefixInfo o2) {
                        int o2Size;
                        int o1Size = o1.getNumHits();
                        return o1Size == (o2Size = o2.getNumHits()) ? 0 : (o1Size < o2Size ? 1 : -1);
                    }
                });
                return sortedStackPrefixes;
            }
        }
        HashMap<MethodObject, MethodInfo> hits = new HashMap<MethodObject, MethodInfo>();
        int totalHits = 0;
        ThreadDumps threadDumps = summary.getThreadDumps();
        for (int threadRunIndex = 0; threadRunIndex < threadDumps.getNumThreads(); ++threadRunIndex) {
            ThreadDumpItem[] threadRun = threadDumps.getThreadRun(threadRunIndex);
            int runStartIndex = threadDumps.getThreadRunStartIndex(threadRun);
            int runEndIndex = threadDumps.getThreadRunEndIndex(threadRun);
            ThreadDumpItem prevItem = null;
            for (int index = runStartIndex; index <= runEndIndex; ++index) {
                ThreadDumpItem curItem = threadRun[index];
                if (curItem.getStatus() == ThreadStatus.THREAD_STATUS_RUNNING && prevItem != null && threadDumps.hasProgress(prevItem, curItem)) {
                    StackFrames stack = threadDumps.getStackFrame(curItem.getStackTraceIndex());
                    if (stack != null && stack.getNrOfFrames() > 0) {
                        ++totalHits;
                        MethodObject topMethod = stack.getTopMethod();
                        MethodInfo methodInfo = (MethodInfo)hits.get(topMethod);
                        if (methodInfo == null) {
                            methodInfo = new MethodInfo(summary);
                            hits.put(topMethod, methodInfo);
                        }
                        methodInfo.add(curItem);
                    } else assert (false);
                }
                prevItem = curItem;
            }
        }
        ArrayList<ThreadDumpHintHotspotImpl> allHints = new ArrayList<ThreadDumpHintHotspotImpl>();
        for (Map.Entry entry : hits.entrySet()) {
            MethodInfo methodInfo = (MethodInfo)entry.getValue();
            List<ThreadDumpHintHotspot.StackPrefixInfo> stackInfos = methodInfo.calcStackInfo();
            allHints.add(new ThreadDumpHintHotspotImpl(methodInfo.getTotal(), totalHits, (MethodObject)entry.getKey(), stackInfos, summary));
        }
        return Characteristics.apply(allHints, new Characteristics.ValueGetter<ThreadDumpHintHotspotImpl>(){

            @Override
            public double getValue(ThreadDumpHintHotspotImpl hint) {
                return hint.getNumberHits();
            }

            @Override
            public boolean applyCharacteristics(ThreadDumpHintHotspotImpl hint, Characteristics chars) {
                hint.calcImportance(chars);
                return hint.getNumberHits() > 2 && hint.getImportance() > 0.0;
            }
        });
    }

    private static void addOrMergeSimilar(List<ThreadDumpHintHotspot.StackPrefixInfo> stackPrefixes, ThreadDumpHintHotspot.StackPrefixInfo curPrefixInfo) {
        for (ThreadDumpHintHotspot.StackPrefixInfo existingPrefixInfo : stackPrefixes) {
            StackFrames existingStackFrames = existingPrefixInfo.getStackFrames();
            StackFrames curStackFrames = curPrefixInfo.getStackFrames();
            if (!curStackFrames.getMethod(0).equals(existingStackFrames.getMethod(0))) continue;
            int maxPrefixIndex = Math.min(existingPrefixInfo.getStackPrefix(), curPrefixInfo.getStackPrefix());
            boolean foundNonJDKMethod = false;
            int credit = 0;
            int currentPrefix = 0;
            while (currentPrefix < maxPrefixIndex) {
                MethodObject existingMethod;
                MethodObject curMethod = curStackFrames.getMethod(curStackFrames.getNrOfFrames() - 1 - currentPrefix);
                if (!curMethod.equals(existingMethod = existingStackFrames.getMethod(existingStackFrames.getNrOfFrames() - 1 - currentPrefix))) {
                    String generatedAccessorFrame = "sun.reflect.GeneratedMethodAccessor";
                    if (!curMethod.getClass().getName().startsWith(generatedAccessorFrame) || !existingMethod.getClass().getName().startsWith(generatedAccessorFrame)) break;
                }
                ++currentPrefix;
                if (ThreadDumpHintHotspotImpl.isJDKMethod(curMethod)) {
                    ++credit;
                    continue;
                }
                foundNonJDKMethod = true;
                credit += 2;
            }
            if (credit < 10 || !foundNonJDKMethod) continue;
            ThreadDumpHintHotspot.StackPrefixInfo resultingPrefix = new ThreadDumpHintHotspot.StackPrefixInfo(curPrefixInfo.getItems(), currentPrefix, curStackFrames);
            existingPrefixInfo.merge(resultingPrefix);
            return;
        }
        stackPrefixes.add(curPrefixInfo);
    }

    private static boolean isJDKMethod(MethodObject method) {
        String methodPackage = method.getMethodClass().getFullName();
        return methodPackage.startsWith("java.") || methodPackage.startsWith("javax.") || methodPackage.startsWith("sun.");
    }

    public String toString() {
        int percentage = (int)Math.round((double)this.hits / (double)this.totalHits * 100.0);
        return String.format("Hotspot: %s %d%%", this.hotspotMethod.getFullName(), percentage);
    }

    @Override
    public int getNumberHits() {
        return this.hits;
    }

    @Override
    public int getTotalNumberHits() {
        return this.totalHits;
    }

    @Override
    public MethodObject getHotspotMethod() {
        return this.hotspotMethod;
    }

    @Override
    public List<ThreadDumpHintHotspot.StackPrefixInfo> getStackPrefixInfo() {
        return this.stackPrefixInfo;
    }
}

