/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread.compare.hints;

import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHint;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintConfidence;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintUrgency;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ThreadDumpHintImpl
implements ThreadDumpHint {
    private final ThreadDumpHintUrgency urgency;
    private final ThreadDumpHintConfidence confidence;
    protected double importance;
    private final ThreadDumpsSummary summary;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm:ss (yyyy-MM-dd)");

    protected ThreadDumpHintImpl(ThreadDumpHintUrgency urgency, ThreadDumpHintConfidence confidence, ThreadDumpsSummary summary, double importance) {
        this.urgency = urgency;
        this.confidence = confidence;
        this.summary = summary;
        this.importance = importance;
    }

    protected ThreadDumpHintImpl(ThreadDumpHintUrgency urgency, ThreadDumpsSummary summary, double importance) {
        this.urgency = urgency;
        this.confidence = ThreadDumpHintConfidence.getByProbability(importance);
        this.summary = summary;
        this.importance = importance;
    }

    protected String toString(ThreadDumpItem item) {
        long id = item.getJavaThreadId();
        id = id <= 0L ? item.getKernelId() : id;
        id = id <= 0L ? item.getPthreadId() : id;
        return String.format("%s [id = %d]", item.getName().toString(), id);
    }

    protected String toString(int dumpIndex) {
        long timestamp = this.summary.getThreadDumps().getTimeStamp(dumpIndex);
        return dateFormat.format(new Date(timestamp));
    }

    @Override
    public ThreadDumpHintUrgency getUrgency() {
        return this.urgency;
    }

    @Override
    public ThreadDumpHintConfidence getConfidence() {
        return this.confidence;
    }

    @Override
    public double getImportance() {
        return this.importance;
    }

    @Override
    public ThreadDumpsSummary getSummary() {
        return this.summary;
    }

    @Override
    public int getPercentage() {
        assert (this.importance >= 0.0 && this.importance <= 1.0);
        return (int)Math.round(100.0 * this.importance);
    }

    public static double getPercentage(double value, double factor) {
        double result = 1.0 - Math.exp(-factor * value);
        assert (result >= 0.0 && result <= 1.0);
        return result;
    }

    public static double getSquarePercentage(double value) {
        assert (value >= 0.0 && value <= 1.0);
        double result = 1.0 - Math.sqrt(value);
        return result;
    }

    public static double getLogisticPercentage(double value, double halfValue) {
        assert (0.0 < halfValue && halfValue < 1.0);
        double f0inv = 100000.0;
        double k = -2.0 * Math.log((1.0 - halfValue) / (halfValue * (f0inv - 1.0)));
        return 1.0 / (Math.exp(-k * value) * (f0inv - 1.0) + 1.0);
    }
}

