/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread.compare.hints;

import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpHintImpl;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintInactiveThread;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintUrgency;
import com.sap.jvm.profiling.thread.SocketObject;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;
import com.sap.jvm.profiling.thread.ThreadStatus;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ThreadDumpHintInactiveThreadImpl
extends ThreadDumpHintImpl
implements ThreadDumpHintInactiveThread {
    private final int threadRunIndex;
    private final int dumpStartIndex;
    private final int dumpEndIndex;
    private final int stackIndex;
    private final SocketObject socketInfo;
    private final boolean isProcessingNetworkIO;
    private static final Set<String> falsePositives = ThreadDumpHintInactiveThreadImpl.falsePositives();

    protected ThreadDumpHintInactiveThreadImpl(int threadRunIndex, int dumpStartIndex, int dumpEndIndex, int stackIndex, SocketObject socketInfo, boolean processingNetworkIO, double importance, ThreadDumpsSummary summary) {
        super(ThreadDumpHintUrgency.SUSPICION, summary, importance);
        this.isProcessingNetworkIO = processingNetworkIO;
        this.threadRunIndex = threadRunIndex;
        this.dumpStartIndex = dumpStartIndex;
        this.dumpEndIndex = dumpEndIndex;
        this.stackIndex = stackIndex;
        this.socketInfo = socketInfo;
    }

    public static List<ThreadDumpHintInactiveThreadImpl> generateHints(ThreadDumpsSummary summary) {
        LinkedList<ThreadDumpHintInactiveThreadImpl> result = new LinkedList<ThreadDumpHintInactiveThreadImpl>();
        ThreadDumps threadDumps = summary.getThreadDumps();
        for (int threadRunIndex = 0; threadRunIndex < threadDumps.getNumThreads(); ++threadRunIndex) {
            ThreadDumpItem[] threadRun = threadDumps.getThreadRun(threadRunIndex);
            ThreadDumpItem lastItem = null;
            int runLength = 0;
            int startIndex = -1;
            int runEndIndex = threadDumps.getThreadRunEndIndex(threadRun);
            for (int curIndex = threadDumps.getThreadRunStartIndex(threadRun); curIndex <= runEndIndex; ++curIndex) {
                ThreadDumpItem item = threadRun[curIndex];
                if (lastItem != null && !threadDumps.hasProgress(lastItem, item) && ThreadDumpHintInactiveThreadImpl.activeState(item)) {
                    ++runLength;
                    if (startIndex == -1) {
                        startIndex = curIndex - 1;
                    }
                } else if (runLength > 0) {
                    ThreadDumpHintInactiveThreadImpl hint = ThreadDumpHintInactiveThreadImpl.handleInactiveRun(startIndex, runLength, threadRunIndex, summary);
                    if (hint != null) {
                        result.add(hint);
                    }
                    startIndex = -1;
                    runLength = 0;
                }
                lastItem = item;
            }
            if (runLength <= 0) continue;
            assert (startIndex + runLength <= runEndIndex);
            ThreadDumpHintInactiveThreadImpl hint = ThreadDumpHintInactiveThreadImpl.handleInactiveRun(startIndex, runLength, threadRunIndex, summary);
            if (hint == null) continue;
            result.add(hint);
        }
        return result;
    }

    protected static boolean activeState(ThreadDumpItem item) {
        switch (item.getStatus()) {
            case THREAD_STATUS_RUNNING: 
            case THREAD_STATUS_SOCKET_READ: 
            case THREAD_STATUS_SOCKET_WRITE: 
            case THREAD_STATUS_SOCKET_CONNECT: {
                return true;
            }
        }
        return false;
    }

    private static ThreadDumpHintInactiveThreadImpl handleInactiveRun(int startIndex, int runLength, int threadRunIndex, ThreadDumpsSummary summary) {
        ThreadDumps threadDumps = summary.getThreadDumps();
        ThreadDumpItem[] threadRun = threadDumps.getThreadRun(threadRunIndex);
        int endIndex = startIndex + runLength;
        long inactiveTime = summary.getElapsedTimeDiff(startIndex, endIndex);
        ThreadDumpItem item = threadRun[startIndex];
        if (!ThreadDumpHintInactiveThreadImpl.filterFalsePositives(threadRun[endIndex], summary)) {
            return new ThreadDumpHintInactiveThreadImpl(threadRunIndex, startIndex, endIndex, item.getStackTraceIndex(), item.getSocketInfo(), item.getStatus() != ThreadStatus.THREAD_STATUS_RUNNING, ThreadDumpHintInactiveThreadImpl.getPercentage(inactiveTime, 1.1666666666666666E-5), summary);
        }
        return null;
    }

    private static final Set<String> falsePositives() {
        HashSet<String> result = new HashSet<String>();
        result.add("com.sap.bc.krn.enqu.EncomiHandle.ReceiveMessage");
        result.add("com.sap.mw.rfc.driver.CpicDriver.nativeCpic_coxread");
        result.add("com.sap.bc.proj.jstartup.fca.impl2.FCAConnection.getInBuf2");
        result.add("sun.nio.ch.PollArrayWrapper.poll0");
        result.add("sun.nio.ch.DevPollArrayWrapper.poll0");
        result.add("sun.nio.ch.EPollArrayWrapper.epollWait");
        result.add("sun.nio.ch.WindowsSelectorImpl$SubSelector.poll0");
        result.add("com.sap.engine.core.cluster.impl6.ms.MSRawConnection.receiveRawMessage");
        result.add("com.sap.engine.core.cluster.impl6.session.Reader.run");
        result.add("com.sap.engine.core.cluster.impl6.lazy.Reader.run");
        result.add("com.sun.jndi.ldap.Connection.run");
        return Collections.unmodifiableSet(result);
    }

    private static boolean filterFalsePositives(ThreadDumpItem item, ThreadDumpsSummary summary) {
        StackFrames frames = summary.getThreadDumps().getStackFrame(item.getStackTraceIndex());
        for (int i = 0; i < frames.getNrOfFrames(); ++i) {
            MethodObject method = frames.getMethod(i);
            String methodName = method.getMethodClass().getFullName() + "." + method.getName();
            if (!falsePositives.contains(methodName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        ThreadDumpItem startItem = this.getSummary().getThreadDumps().getThreadDumpItem(this.dumpStartIndex, this.threadRunIndex);
        return String.format("Detected inactive thread [hintUrgency=%s, confidence=%s %d%%]: Thread '%s' at %s", new Object[]{this.getUrgency(), this.getConfidence().getDescription(), this.getPercentage(), this.toString(startItem), this.toString(this.dumpStartIndex)});
    }

    @Override
    public int getThreadRunIndex() {
        return this.threadRunIndex;
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackIndex;
    }

    @Override
    public SocketObject getSocketInfo() {
        return this.socketInfo;
    }

    @Override
    public int getThreadDumpStartIndex() {
        return this.dumpStartIndex;
    }

    @Override
    public int getThreadDumpEndIndex() {
        return this.dumpEndIndex;
    }

    @Override
    public boolean isProcessingNetworkIO() {
        return this.isProcessingNetworkIO;
    }
}

