/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread.compare.hints;

import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.Characteristics;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpHintImpl;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintConfidence;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintLockContention;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintUrgency;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;
import com.sap.jvm.profiling.thread.ThreadStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ThreadDumpHintLockContentionImpl
extends ThreadDumpHintImpl
implements ThreadDumpHintLockContention {
    private final MonitorObject lock;
    private List<ThreadDumpHintLockContention.ThreadStackInfo> blockingThreadInfo;
    private List<ThreadDumpHintLockContention.ThreadStackInfo> blockedThreadInfo;
    private int numThreadsBlocked;
    private int numDumpsBlocked;
    private int totalNumBlocked;
    private int totalNumRunnable;
    private boolean keepsThreadsBlocked;
    private static Set<String> falsePositives = ThreadDumpHintLockContentionImpl.falsePositives();

    protected ThreadDumpHintLockContentionImpl(MonitorObject lock, ThreadDumpsSummary summary) {
        super(ThreadDumpHintUrgency.NOTE, ThreadDumpHintConfidence.S, summary, 0.0);
        this.lock = lock;
        this.blockingThreadInfo = new ArrayList<ThreadDumpHintLockContention.ThreadStackInfo>();
        this.blockedThreadInfo = new ArrayList<ThreadDumpHintLockContention.ThreadStackInfo>();
    }

    public static List<ThreadDumpHintLockContentionImpl> generateHints(ThreadDumpsSummary summary) {
        final class LockInfo {
            Map<ThreadLoc, Integer> blockingThreadInfo = new HashMap<ThreadLoc, Integer>();
            Map<ThreadLoc, Integer> blockedThreadInfo = new HashMap<ThreadLoc, Integer>();
            int numThreadsBlocked;

            LockInfo() {
                final class ThreadLoc {
                    int threadIndex;
                    ThreadDumpItem item;

                    public ThreadLoc(int threadIndex, ThreadDumpItem item) {
                        this.threadIndex = threadIndex;
                        this.item = item;
                    }

                    public int hashCode() {
                        int prime = 31;
                        int result = 1;
                        result = 31 + this.item.getStackTraceIndex();
                        result = 31 * result + this.threadIndex;
                        return result;
                    }

                    public boolean equals(Object obj) {
                        if (this.item.getStackTraceIndex() != ((ThreadLoc)obj).item.getStackTraceIndex()) {
                            return false;
                        }
                        return this.threadIndex == ((ThreadLoc)obj).threadIndex;
                    }
                }
            }

            void handleBlockingThread(int blockingThreadIndex, ThreadDumpItem item) {
                this.merge(this.blockingThreadInfo, new ThreadLoc(blockingThreadIndex, item));
            }

            void handleBlockedThread(int blockedThreadIndex, ThreadDumpItem item) {
                ++this.numThreadsBlocked;
                this.merge(this.blockedThreadInfo, new ThreadLoc(blockedThreadIndex, item));
            }

            private void merge(Map<ThreadLoc, Integer> threadInfos, ThreadLoc threadLoc) {
                Integer number = threadInfos.get(threadLoc);
                number = number == null ? Integer.valueOf(1) : Integer.valueOf(number + 1);
                threadInfos.put(threadLoc, number);
            }

            public List<ThreadDumpHintLockContention.ThreadStackInfo> convertMap2ThreadInfoList(Map<ThreadLoc, Integer> theMap) {
                ArrayList<ThreadDumpHintLockContention.ThreadStackInfo> result = new ArrayList<ThreadDumpHintLockContention.ThreadStackInfo>(theMap.size());
                for (Map.Entry<ThreadLoc, Integer> entry : theMap.entrySet()) {
                    ThreadLoc threadLoc = entry.getKey();
                    Integer number = entry.getValue();
                    result.add(new ThreadDumpHintLockContention.ThreadStackInfo(threadLoc.threadIndex, threadLoc.item, number));
                }
                Collections.sort(result, new Comparator<ThreadDumpHintLockContention.ThreadStackInfo>(){

                    @Override
                    public int compare(ThreadDumpHintLockContention.ThreadStackInfo o1, ThreadDumpHintLockContention.ThreadStackInfo o2) {
                        return o1.getNumber() == o2.getNumber() ? 0 : (o1.getNumber() > o2.getNumber() ? 1 : -1);
                    }
                });
                return result;
            }
        }
        TreeMap<MonitorObject, LockInfo> lockInfos = new TreeMap<MonitorObject, LockInfo>();
        ThreadDumps threadDumps = summary.getThreadDumps();
        int countLocks = 0;
        int countRunnable = 0;
        int countNumDumpsBlocked = 0;
        for (int dumpIndex = 0; dumpIndex < threadDumps.getNumDumps(); ++dumpIndex) {
            int oldCountLocks = countLocks;
            for (int threadIndex = 0; threadIndex < threadDumps.getNumThreads(); ++threadIndex) {
                ThreadDumpItem item = threadDumps.getThreadDumpItem(dumpIndex, threadIndex);
                if (item != null && item.getStatus() == ThreadStatus.THREAD_STATUS_LOCK_WAIT && item.hasBlockingThread()) {
                    MonitorObject lock = item.getMonitorObject();
                    if (lock == null || ThreadDumpHintLockContentionImpl.filterFalsePositives(item, summary)) continue;
                    ++countLocks;
                    LockInfo lockInfo = (LockInfo)lockInfos.get(lock);
                    if (lockInfo == null) {
                        lockInfo = new LockInfo();
                        lockInfos.put(lock, lockInfo);
                    }
                    lockInfo.handleBlockedThread(threadIndex, item);
                    int blockingThreadRunIndex = threadDumps.threadIndex2ThreadRunIndex(dumpIndex, item.getBlockingThreadIndex());
                    ThreadDumpItem blockingItem = threadDumps.getThreadDumpItem(dumpIndex, blockingThreadRunIndex);
                    assert (blockingThreadRunIndex >= 0);
                    lockInfo.handleBlockingThread(blockingThreadRunIndex, blockingItem);
                    continue;
                }
                if (item == null || item.getStatus() != ThreadStatus.THREAD_STATUS_RUNNING) continue;
                ++countRunnable;
            }
            if (countLocks <= oldCountLocks) continue;
            ++countNumDumpsBlocked;
        }
        ArrayList<ThreadDumpHintLockContentionImpl> allHints = new ArrayList<ThreadDumpHintLockContentionImpl>();
        for (Map.Entry entry : lockInfos.entrySet()) {
            MonitorObject lock = (MonitorObject)entry.getKey();
            LockInfo lockInfo = (LockInfo)entry.getValue();
            ThreadDumpHintLockContentionImpl hint = new ThreadDumpHintLockContentionImpl(lock, summary);
            hint.blockingThreadInfo = lockInfo.convertMap2ThreadInfoList(lockInfo.blockingThreadInfo);
            hint.blockedThreadInfo = lockInfo.convertMap2ThreadInfoList(lockInfo.blockedThreadInfo);
            hint.numThreadsBlocked = lockInfo.numThreadsBlocked;
            hint.totalNumBlocked = countLocks;
            hint.totalNumRunnable = countRunnable;
            hint.numDumpsBlocked = countNumDumpsBlocked;
            hint.keepsThreadsBlocked = true;
            for (ThreadDumpHintLockContention.ThreadStackInfo info : hint.blockedThreadInfo) {
                hint.keepsThreadsBlocked = hint.threadIsKeptBlocked(info);
                if (hint.keepsThreadsBlocked) continue;
                break;
            }
            allHints.add(hint);
        }
        return Characteristics.apply(allHints, new Characteristics.ValueGetter<ThreadDumpHintLockContentionImpl>(){

            @Override
            public double getValue(ThreadDumpHintLockContentionImpl hint) {
                return hint.getNumThreadsBlocked();
            }

            @Override
            public boolean applyCharacteristics(ThreadDumpHintLockContentionImpl hint, Characteristics chars) {
                hint.calcImportance(chars);
                return hint.getImportance() > 0.0;
            }
        });
    }

    private boolean threadIsKeptBlocked(ThreadDumpHintLockContention.ThreadStackInfo info) {
        int[] range = this.getSummary().getThreadDumps().getThreadRunRange(info.getThreadIndex());
        for (int dumpIndex = range[0]; dumpIndex < range[1] + 1; ++dumpIndex) {
            ThreadDumpItem item = this.getSummary().getThreadDumps().getThreadDumpItem(dumpIndex, info.getThreadIndex());
            if (item != info.getThreadDumpItem()) continue;
            return info.getNumber() == range[1] + 1 - dumpIndex;
        }
        return false;
    }

    private static Set<String> falsePositives() {
        HashSet<String> theFalsePositives = new HashSet<String>();
        theFalsePositives.add("com.sap.engine.services.cross.fca.FCAConnectorImpl.readMessage(com.sap.engine.services.cross.fca.MessageReader)com.sap.engine.interfaces.cross.CrossMessage");
        theFalsePositives.add("sun.nio.ch.ServerSocketChannelImpl.accept()java.nio.channels.SocketChannel");
        theFalsePositives.add("com.sap.engine.services.httpserver.server.rcm.PostponedQueue.poll(java.lang.String)com.sap.bc.proj.jstartup.fca.FCAConnection");
        return Collections.unmodifiableSet(theFalsePositives);
    }

    private static boolean filterFalsePositives(ThreadDumpItem item, ThreadDumpsSummary summary) {
        StackFrames frames = summary.getThreadDumps().getStackFrame(item.getStackTraceIndex());
        MethodObject method = frames.getTopMethod();
        return falsePositives.contains(method.getFullName());
    }

    public void calcImportance(Characteristics chars) {
        double factor = 0.0;
        if (this.numThreadsBlocked > 0) {
            if (chars.getNum() > 10 && chars.getDeviation() > 0.0) {
                factor = ((double)this.numThreadsBlocked - chars.getAvg()) / chars.getDeviation();
                factor = Math.max(factor, 0.0);
            } else if (chars.getMedian() > 0.0) {
                factor = (double)this.numThreadsBlocked / chars.getMedian();
            }
            factor = ThreadDumpHintLockContentionImpl.getPercentage(factor, 0.25);
            double factor2 = (double)this.numThreadsBlocked / (double)(this.totalNumBlocked + this.totalNumRunnable);
            factor2 = ThreadDumpHintLockContentionImpl.getPercentage(factor2, 4.5);
            factor = Math.max(factor, factor2);
        }
        this.importance = factor;
    }

    @Override
    public MonitorObject getMonitorObject() {
        return this.lock;
    }

    @Override
    public List<ThreadDumpHintLockContention.ThreadStackInfo> getBlockingThreadInfo() {
        return this.blockingThreadInfo;
    }

    @Override
    public List<ThreadDumpHintLockContention.ThreadStackInfo> getBlockedThreadInfo() {
        return this.blockedThreadInfo;
    }

    @Override
    public int getNumThreadsBlocked() {
        return this.numThreadsBlocked;
    }

    @Override
    public boolean keepsThreadsBlocked() {
        return this.keepsThreadsBlocked;
    }

    @Override
    public int getTotalNumBlocked() {
        return this.totalNumBlocked;
    }

    @Override
    public int getNumDumpsWithBlocked() {
        return this.numDumpsBlocked;
    }

    public String toString() {
        return String.format("ThreadDumpHintBlockContentionImpl [lock=%s, numThreadsBlocked=%s, totalNumBlocked=%s, keepsThreadsBlocked=%s]", this.lock, this.numThreadsBlocked, this.totalNumBlocked, this.keepsThreadsBlocked);
    }
}

