/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread.compare.hints;

import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpHintImpl;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpValue;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ResourceLeakType;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintConfidence;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintResourceLeak;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintUrgency;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;
import java.util.LinkedList;
import java.util.List;

public class ThreadDumpHintResourceLeakImpl
extends ThreadDumpHintImpl
implements ThreadDumpHintResourceLeak {
    private double trendFactor;
    private ResourceLeakType resourceType;
    private double minValue;
    private double maxValue;
    private double valueGradient;
    double[] values;

    protected ThreadDumpHintResourceLeakImpl(ResourceLeakType valueType, double minValue, double maxValue, double valueGradient, double[] values, double trendFactor, ThreadDumpsSummary summary) {
        super(ThreadDumpHintUrgency.NOTE, ThreadDumpHintConfidence.S, summary, trendFactor);
        this.trendFactor = trendFactor;
        this.resourceType = valueType;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valueGradient = valueGradient;
        this.values = values;
    }

    public static List<ThreadDumpHintResourceLeakImpl> generateHints(ThreadDumpsSummary summary) {
        LinkedList<ThreadDumpHintResourceLeakImpl> result = new LinkedList<ThreadDumpHintResourceLeakImpl>();
        for (ResourceLeakType valueType : ResourceLeakType.values()) {
            result.addAll(ThreadDumpHintResourceLeakImpl.examineValues(valueType, summary));
        }
        return result;
    }

    private static List<ThreadDumpHintResourceLeakImpl> examineValues(ResourceLeakType resourceType, ThreadDumpsSummary summary) {
        double growthRate;
        LinkedList<ThreadDumpHintResourceLeakImpl> result = new LinkedList<ThreadDumpHintResourceLeakImpl>();
        ThreadDumpValue.ValueGetter getter = ThreadDumpValue.createGetter(resourceType);
        double[] values = ThreadDumpHintResourceLeakImpl.computeValues(getter, summary);
        if (values.length <= 1) {
            return result;
        }
        ThreadDumps threadDumps = summary.getThreadDumps();
        long[] times = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            times[i] = threadDumps.getTimeStamp(i) - threadDumps.getTimeStamp(0);
        }
        double meanTime = 0.0;
        double meanValue = 0.0;
        double minValue = Double.MAX_VALUE;
        double maxValue = Double.MIN_VALUE;
        for (int i = 0; i < values.length; ++i) {
            meanTime += (double)times[i];
            meanValue += values[i];
            minValue = Math.min(minValue, values[i]);
            maxValue = Math.max(maxValue, values[i]);
        }
        meanTime /= (double)values.length;
        meanValue /= (double)values.length;
        double sumSquareTimeDist = 0.0;
        double sumTimeDistValueDist = 0.0;
        for (int i = 0; i < values.length; ++i) {
            double deltaTime = (double)times[i] - meanTime;
            double deltaValue = values[i] - meanValue;
            sumSquareTimeDist += deltaTime * deltaTime;
            sumTimeDistValueDist += deltaTime * deltaValue;
        }
        double increase = maxValue - minValue;
        if (sumSquareTimeDist > 0.0 && increase > ThreadDumpValue.lowerBound(resourceType) && (growthRate = 1000.0 * sumTimeDistValueDist / sumSquareTimeDist) > 0.0) {
            double totalTime = (double)times[times.length - 1] / 60000.0;
            double factorTime = ThreadDumpHintResourceLeakImpl.getPercentage(totalTime, 0.4);
            double factorGrowth = ThreadDumpHintResourceLeakImpl.getPercentage(factorTime * growthRate / ThreadDumpValue.limitPerSecond(resourceType), 1.0);
            result.add(new ThreadDumpHintResourceLeakImpl(resourceType, minValue, maxValue, growthRate, values, factorGrowth, summary));
        }
        return result;
    }

    private static double[] computeValues(ThreadDumpValue.ValueGetter getter, ThreadDumpsSummary summary) {
        ThreadDumps threadDumps = summary.getThreadDumps();
        ThreadDump[] dumps = threadDumps.getThreadDumps();
        double[] result = new double[dumps.length];
        for (int dumpIndex = 0; dumpIndex < dumps.length; ++dumpIndex) {
            result[dumpIndex] = getter.getValue(summary, dumpIndex);
        }
        if (result[0] < 0.0) {
            double shift = -result[0];
            int dumpIndex = 0;
            while (dumpIndex < dumps.length) {
                int n = dumpIndex++;
                result[n] = result[n] + shift;
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(String.format("Detected resource trend [type=%s, hintUrgency=%s, factor=%f]: ", new Object[]{this.resourceType.toString(), this.getUrgency(), this.trendFactor}));
        return result.toString();
    }

    @Override
    public ResourceLeakType resourceType() {
        return this.resourceType;
    }

    @Override
    public double minValue() {
        return this.minValue;
    }

    @Override
    public double maxValue() {
        return this.maxValue;
    }

    @Override
    public double valueGradient() {
        return this.valueGradient;
    }

    @Override
    public double[] values() {
        return this.values;
    }
}

