/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread.compare.hints;

import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.Characteristics;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpHintImpl;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintConfidence;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintUrgency;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;
import java.util.ArrayList;
import java.util.List;

public class ThreadDumpHintTimepoints
extends ThreadDumpHintImpl {
    final List<DumpTimestamp> dumps;

    protected ThreadDumpHintTimepoints(List<DumpTimestamp> dumps, ThreadDumpsSummary summary) {
        super(ThreadDumpHintUrgency.WARNING, ThreadDumpHintConfidence.S, summary, 0.0);
        this.dumps = dumps;
    }

    public static List<ThreadDumpHintTimepoints> generateHints(ThreadDumpsSummary summary) {
        ThreadDump[] dumps = summary.getThreadDumps().getThreadDumps();
        ArrayList<DumpTimestamp> timestamps = new ArrayList<DumpTimestamp>(dumps.length - 1);
        for (int dumpIndex = 1; dumpIndex < dumps.length; ++dumpIndex) {
            timestamps.add(new DumpTimestamp(dumps[dumpIndex].getTimeStamp() - dumps[dumpIndex - 1].getTimeStamp(), dumpIndex));
        }
        List<DumpTimestamp> irregularDumps = Characteristics.apply(timestamps, new Characteristics.ValueGetter<DumpTimestamp>(){

            @Override
            public double getValue(DumpTimestamp obj) {
                return obj.timeDistance;
            }

            @Override
            public boolean applyCharacteristics(DumpTimestamp obj, Characteristics chars) {
                double diff = Math.abs((double)obj.timeDistance - chars.getAvg());
                return diff > 3.0 * chars.getDeviation();
            }
        });
        ArrayList<ThreadDumpHintTimepoints> result = new ArrayList<ThreadDumpHintTimepoints>();
        if (irregularDumps.size() > 0) {
            result.add(new ThreadDumpHintTimepoints(irregularDumps, summary));
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(String.format("Detected dumps with irregular interval [hintUrgency=%s, confidence=%s]:\n", new Object[]{this.getUrgency(), this.getConfidence().getDescription()}));
        for (DumpTimestamp dump : this.dumps) {
            result.append(dump.getDumpIndex());
            result.append(String.format(" dist: %d ms\n", dump.getTimeDistance()));
        }
        return result.toString();
    }

    static final class DumpTimestamp {
        private final long timeDistance;
        private final int dumpIndex;

        public DumpTimestamp(long timeDistance, int dumpIndex) {
            this.timeDistance = timeDistance;
            this.dumpIndex = dumpIndex;
        }

        public long getTimeDistance() {
            return this.timeDistance;
        }

        public int getDumpIndex() {
            return this.dumpIndex;
        }
    }
}

