/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread.compare.hints;

import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.Characteristics;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpHintImpl;
import com.sap.jvm.profiling.snapshot.impl.thread.compare.hints.ThreadDumpItemValue;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintConfidence;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintTopConsumer;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.ThreadDumpHintUrgency;
import com.sap.jvm.profiling.snapshot.thread.compare.hints.TopConsumerType;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumps;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ThreadDumpHintTopConsumerImpl
extends ThreadDumpHintImpl
implements ThreadDumpHintTopConsumer {
    private final TopConsumerType valueType;
    private final int threadRunIndex;
    private final long valueBefore;
    private final long valueIncrease;
    private final double valueRate;
    private final long totalValueIncrease;
    private long[] values;
    private long[] avgValues;

    protected ThreadDumpHintTopConsumerImpl(TopConsumerType valueType, long valueBefore, long valueIncrease, double valueRate, long totalValueIncrease, int threadIndex, long[] values, long[] avgValues, ThreadDumpsSummary summary) {
        super(ThreadDumpHintUrgency.NOTE, ThreadDumpHintConfidence.S, summary, 0.0);
        this.threadRunIndex = threadIndex;
        this.valueBefore = valueBefore;
        this.valueIncrease = valueIncrease;
        this.valueRate = valueRate;
        this.totalValueIncrease = totalValueIncrease;
        this.valueType = valueType;
        this.values = values;
        this.avgValues = avgValues;
    }

    protected void calcImportance(Characteristics chars) {
        double expectedValueRate = chars.getAvg();
        double totalValueRate = chars.getSum();
        long totalTimeMs = this.getSummary().getElapsedTimeDiff();
        int[] range = this.getSummary().getThreadDumps().getThreadRunRange(this.threadRunIndex);
        long threadTimeMs = this.getSummary().getElapsedTimeDiff(range[0], range[1]);
        if (this.valueRate > 0.0 && expectedValueRate > 0.0 && totalValueRate > 0.0) {
            this.importance = ThreadDumpHintTopConsumerImpl.getPercentage(this.valueRate / expectedValueRate * (this.valueRate / totalValueRate) * ((double)threadTimeMs / (double)totalTimeMs), 0.4);
        }
        if (this.valueType == TopConsumerType.CPU_TIME && this.valueIncrease > 0L) {
            double coreConsumption = (double)this.valueIncrease / (1000000.0 * (double)threadTimeMs);
            this.importance = Math.max(this.importance, coreConsumption);
        }
    }

    public static List<ThreadDumpHintTopConsumer> generateHints(ThreadDumpsSummary summary) {
        LinkedList<ThreadDumpHintTopConsumer> result = new LinkedList<ThreadDumpHintTopConsumer>();
        result.addAll(ThreadDumpHintTopConsumerImpl.examineValues(TopConsumerType.CPU_TIME, summary));
        result.addAll(ThreadDumpHintTopConsumerImpl.examineValues(TopConsumerType.ALLOCATED, summary));
        result.addAll(ThreadDumpHintTopConsumerImpl.examineValues(TopConsumerType.SOCKET_READ, summary));
        result.addAll(ThreadDumpHintTopConsumerImpl.examineValues(TopConsumerType.SOCKET_WRITE, summary));
        result.addAll(ThreadDumpHintTopConsumerImpl.examineValues(TopConsumerType.FILE_READ, summary));
        result.addAll(ThreadDumpHintTopConsumerImpl.examineValues(TopConsumerType.FILE_WRITE, summary));
        return result;
    }

    private static List<ThreadDumpHintTopConsumerImpl> examineValues(TopConsumerType valueType, ThreadDumpsSummary summary) {
        int threadIndex;
        ThreadDumps threadDumps = summary.getThreadDumps();
        long totalValueIncrease = ThreadDumpItemValue.getTotalIncrease(valueType, summary);
        ArrayList<ThreadDumpHintTopConsumerImpl> consumers = new ArrayList<ThreadDumpHintTopConsumerImpl>(threadDumps.getNumThreads());
        ThreadDumpItemValue.ThreadDumpItemGetter getter = ThreadDumpItemValue.createGetter(valueType);
        long[] contributedValues = new long[threadDumps.getNumDumps()];
        int[] contributorThreads = new int[threadDumps.getNumDumps()];
        for (threadIndex = 0; threadIndex < threadDumps.getNumThreads(); ++threadIndex) {
            for (int dumpIndex = 1; dumpIndex < threadDumps.getNumDumps(); ++dumpIndex) {
                long deltaValue;
                ThreadDumpItem item = threadDumps.getThreadDumpItem(dumpIndex, threadIndex);
                ThreadDumpItem prevItem = threadDumps.getThreadDumpItem(dumpIndex - 1, threadIndex);
                if (item == null || prevItem == null || (deltaValue = getter.getValue(item) - getter.getValue(prevItem)) <= 0L) continue;
                int n = dumpIndex;
                contributedValues[n] = contributedValues[n] + deltaValue;
                int n2 = dumpIndex;
                contributorThreads[n2] = contributorThreads[n2] + 1;
            }
        }
        for (threadIndex = 0; threadIndex < threadDumps.getNumThreads(); ++threadIndex) {
            ThreadDumpItem[] threadRun = threadDumps.getThreadRun(threadIndex);
            assert (threadRun.length == threadDumps.getNumDumps());
            int startIndex = threadDumps.getThreadRunStartIndex(threadRun);
            int endIndex = threadDumps.getThreadRunEndIndex(threadRun);
            ThreadDumpItem startItem = threadRun[startIndex];
            ThreadDumpItem endItem = threadRun[endIndex];
            long valueIncrease = getter.getValue(endItem) - getter.getValue(startItem);
            long timeIncrease = 1000000L * summary.getElapsedTimeDiff(startIndex, endIndex);
            long valueBefore = getter.getValue(startItem);
            if (valueIncrease < 0L || timeIncrease <= 0L) continue;
            double valueRate = (double)valueIncrease / (double)timeIncrease;
            long[] topConsumerValues = new long[threadRun.length];
            int dumpIndex = 0;
            for (ThreadDumpItem item : threadRun) {
                long val = item != null ? getter.getValue(item) : Long.MIN_VALUE;
                topConsumerValues[dumpIndex++] = val;
            }
            long[] avgValues = new long[contributedValues.length];
            for (dumpIndex = 1; dumpIndex < contributedValues.length; ++dumpIndex) {
                ThreadDumpItem item = threadDumps.getThreadDumpItem(dumpIndex, threadIndex);
                ThreadDumpItem prevItem = threadDumps.getThreadDumpItem(dumpIndex - 1, threadIndex);
                int contributors = contributorThreads[dumpIndex];
                long topConsumerDelta = 0L;
                if (item != null && prevItem != null) {
                    topConsumerDelta = getter.getValue(item) - getter.getValue(prevItem);
                }
                if (topConsumerDelta > 0L) {
                    --contributors;
                }
                if (contributors > 0) {
                    avgValues[dumpIndex] = (contributedValues[dumpIndex] - topConsumerDelta) / (long)contributors;
                }
                assert (avgValues[dumpIndex] >= 0L);
            }
            for (dumpIndex = 1; dumpIndex < contributedValues.length; ++dumpIndex) {
                int n = dumpIndex;
                avgValues[n] = avgValues[n] + avgValues[dumpIndex - 1];
            }
            assert (valueRate >= 0.0 && valueIncrease <= totalValueIncrease);
            ThreadDumpHintTopConsumerImpl hint = new ThreadDumpHintTopConsumerImpl(valueType, valueBefore, valueIncrease, valueRate, totalValueIncrease, threadIndex, topConsumerValues, avgValues, summary);
            consumers.add(hint);
        }
        return Characteristics.apply(consumers, new Characteristics.ValueGetter<ThreadDumpHintTopConsumerImpl>(){

            @Override
            public double getValue(ThreadDumpHintTopConsumerImpl hint) {
                return hint.getValueRate();
            }

            @Override
            public boolean applyCharacteristics(ThreadDumpHintTopConsumerImpl hint, Characteristics chars) {
                hint.calcImportance(chars);
                return ThreadDumpItemValue.exceedsMinimum(hint.getConsumerType(), hint.getValueRate() * 1000.0 * 1000.0) && hint.getImportance() > 0.05;
            }
        });
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(String.format("Detected top consumer [type=%s, hintUrgency=%s]: ", new Object[]{this.valueType.toString(), this.getUrgency()}));
        ThreadDumpItem[] threadRun = this.getSummary().getThreadDumps().getThreadRun(this.threadRunIndex);
        int startIndex = this.getSummary().getThreadDumps().getThreadRunStartIndex(threadRun);
        result.append(this.toString(threadRun[startIndex]));
        result.append('\t');
        result.append("increment: ");
        result.append(ThreadDumpItemValue.toString(this.valueType, this.valueIncrease));
        return result.toString();
    }

    @Override
    public TopConsumerType getConsumerType() {
        return this.valueType;
    }

    @Override
    public int getThreadRunIndex() {
        return this.threadRunIndex;
    }

    @Override
    public long getValueIncrease() {
        return this.valueIncrease;
    }

    @Override
    public long getTotalIncrease() {
        return this.totalValueIncrease;
    }

    @Override
    public long[] getValues() {
        return this.values;
    }

    @Override
    public double getValueRate() {
        return this.valueRate;
    }

    @Override
    public long getValueBefore() {
        return this.valueBefore;
    }

    @Override
    public long[] getAvgValues() {
        return this.avgValues;
    }
}

