/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread.compare.hints;

import com.sap.jvm.profiling.snapshot.thread.compare.hints.TopConsumerType;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;

class ThreadDumpItemValue {
    static double tenMBperMin = 166.66666666666666;

    ThreadDumpItemValue() {
    }

    public static String toString(TopConsumerType type, long value) {
        switch (type) {
            case CPU_TIME: {
                return String.format("%d ms", value * 1000L * 1000L);
            }
            case ALLOCATED: 
            case SOCKET_READ: 
            case SOCKET_WRITE: 
            case FILE_READ: 
            case FILE_WRITE: {
                return String.format("%d bytes", value);
            }
        }
        assert (false);
        throw new InternalError("unknown value type");
    }

    public static ThreadDumpItemGetter createGetter(TopConsumerType type) {
        switch (type) {
            case CPU_TIME: {
                return new ThreadDumpItemGetter(){

                    @Override
                    public long getValue(ThreadDumpItem item) {
                        return item.getCpuTime(false);
                    }
                };
            }
            case ALLOCATED: {
                return new ThreadDumpItemGetter(){

                    @Override
                    public long getValue(ThreadDumpItem item) {
                        return item.getMemoryConsumption(false);
                    }
                };
            }
            case SOCKET_READ: {
                return new ThreadDumpItemGetter(){

                    @Override
                    public long getValue(ThreadDumpItem item) {
                        return item.getSocketBytesRead(false);
                    }
                };
            }
            case SOCKET_WRITE: {
                return new ThreadDumpItemGetter(){

                    @Override
                    public long getValue(ThreadDumpItem item) {
                        return item.getSocketBytesWritten(false);
                    }
                };
            }
            case FILE_READ: {
                return new ThreadDumpItemGetter(){

                    @Override
                    public long getValue(ThreadDumpItem item) {
                        return item.getFileBytesRead(false);
                    }
                };
            }
            case FILE_WRITE: {
                return new ThreadDumpItemGetter(){

                    @Override
                    public long getValue(ThreadDumpItem item) {
                        return item.getFileBytesWritten(false);
                    }
                };
            }
        }
        assert (false);
        throw new InternalError("unknown value type");
    }

    public static boolean exceedsMinimum(TopConsumerType type, double valueRateMs) {
        double limitRate = 0.0;
        switch (type) {
            case CPU_TIME: {
                limitRate = 100000.0;
                break;
            }
            case ALLOCATED: {
                limitRate = 20.0 * tenMBperMin;
                break;
            }
            case SOCKET_READ: 
            case SOCKET_WRITE: 
            case FILE_READ: 
            case FILE_WRITE: {
                limitRate = 6.0 * tenMBperMin;
                break;
            }
            default: {
                assert (false);
                throw new InternalError("unknown value type");
            }
        }
        return valueRateMs > limitRate;
    }

    public static long getTotalIncrease(TopConsumerType type, ThreadDumpsSummary summary) {
        switch (type) {
            case CPU_TIME: {
                return summary.getCPUTimeDiff();
            }
            case ALLOCATED: {
                return summary.getMemoryConsumptionDiff();
            }
            case SOCKET_READ: {
                return summary.getSocketBytesReadDiff();
            }
            case SOCKET_WRITE: {
                return summary.getSocketBytesWrittenDiff();
            }
            case FILE_READ: {
                return summary.getFileBytesReadDiff();
            }
            case FILE_WRITE: {
                return summary.getFileBytesWrittenDiff();
            }
        }
        assert (false);
        throw new InternalError("unknown value type");
    }

    static interface ThreadDumpItemGetter {
        public long getValue(ThreadDumpItem var1);
    }
}

