/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.thread.compare.hints;

import com.sap.jvm.profiling.snapshot.thread.compare.hints.ResourceLeakType;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;

class ThreadDumpValue {
    ThreadDumpValue() {
    }

    public static ValueGetter createGetter(ResourceLeakType type) {
        switch (type) {
            case SOCKETS_OPEN: {
                return new ValueGetter(){

                    @Override
                    public double getValue(ThreadDumpsSummary summary, int dumpIndex) {
                        return summary.getNumSocketsOpen(dumpIndex);
                    }
                };
            }
            case FILES_OPEN: {
                return new ValueGetter(){

                    @Override
                    public double getValue(ThreadDumpsSummary summary, int dumpIndex) {
                        return summary.getNumFilesOpen(dumpIndex);
                    }
                };
            }
            case NUM_THREADS: {
                return new ValueGetter(){

                    @Override
                    public double getValue(ThreadDumpsSummary summary, int dumpIndex) {
                        return summary.getNumThreads(dumpIndex);
                    }
                };
            }
            case NUM_LOCKED_THREADS: {
                return new ValueGetter(){

                    @Override
                    public double getValue(ThreadDumpsSummary summary, int dumpIndex) {
                        return summary.getNumBlockedThreads(dumpIndex);
                    }
                };
            }
            case NUM_IO_THREADS: {
                return new ValueGetter(){

                    @Override
                    public double getValue(ThreadDumpsSummary summary, int dumpIndex) {
                        return summary.getNumIOThreads(dumpIndex);
                    }
                };
            }
        }
        assert (false);
        throw new InternalError("unknown value type");
    }

    public static double limitPerSecond(ResourceLeakType type) {
        switch (type) {
            case SOCKETS_OPEN: 
            case FILES_OPEN: {
                return 0.016666666666666666;
            }
            case NUM_THREADS: {
                return 0.1;
            }
            case NUM_LOCKED_THREADS: 
            case NUM_IO_THREADS: {
                return 0.2;
            }
        }
        assert (false);
        throw new InternalError("unknown value type");
    }

    public static double lowerBound(ResourceLeakType type) {
        switch (type) {
            case SOCKETS_OPEN: 
            case FILES_OPEN: {
                return 50.0;
            }
            case NUM_THREADS: {
                return 50.0;
            }
            case NUM_LOCKED_THREADS: 
            case NUM_IO_THREADS: {
                return 25.0;
            }
        }
        assert (false);
        throw new InternalError("unknown value type");
    }

    static interface ValueGetter {
        public double getValue(ThreadDumpsSummary var1, int var2);
    }
}

