/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.tree;

import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueTreeNodeBaseImpl;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public abstract class TreeCollector<K, V extends Value<V>, T extends ValueTreeNodeBaseImpl<K, V>> {
    private static final int PRUNE_START_DEPTH = 3;
    private static final int MIN_AFTER_PRUNE = 1000;
    private final HashMap<T, T> nodes;
    private final HashSet<T> prunedNodes;
    private int maxDepth = Integer.MAX_VALUE;

    public TreeCollector() {
        this.nodes = new HashMap();
        this.prunedNodes = new HashSet();
    }

    public T getOrAdd(T toSearch) {
        ValueTreeNodeBaseImpl old = (ValueTreeNodeBaseImpl)this.nodes.get(toSearch);
        if (old == null) {
            this.nodes.put(toSearch, toSearch);
            return toSearch;
        }
        return (T)old;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    protected void addImpl(TreeCollector<K, V, T> other, T startNode) {
        for (ValueTreeNodeBaseImpl otherNode : other.nodes.values()) {
            this.normalize(otherNode, startNode);
            ValueTreeNodeBaseImpl ourNode = (ValueTreeNodeBaseImpl)this.nodes.get(otherNode);
            if (otherNode != ourNode) {
                this.add(ourNode, otherNode);
            }
            if (otherNode.hasChildren()) {
                ourNode.setHasChildren();
            }
            if (!otherNode.hasSubNodes()) continue;
            ourNode.setHasSubNodes();
        }
        this.maxDepth = Math.min(this.maxDepth, other.maxDepth);
    }

    private void normalize(T node, T startNode) {
        if (this.nodes.containsKey(node)) {
            return;
        }
        if (startNode == null && node == null) {
            return;
        }
        ValueTreeNodeBaseImpl parent = ((ValueTreeNodeBaseImpl)node).getParent();
        if (parent != startNode) {
            this.normalize(parent, startNode);
            ((ValueTreeNodeBaseImpl)node).setParent((ValueTreeNodeBaseImpl)this.nodes.get(parent));
        }
        this.nodes.put(node, node);
    }

    public final int getNrOfNodes() {
        return this.nodes.size();
    }

    public final void ensureMaxDepth(int depth) {
        if (depth <= 1) {
            return;
        }
        Iterator<T> it = this.nodes.keySet().iterator();
        while (it.hasNext()) {
            if (((ValueTreeNodeBaseImpl)it.next()).getDepth() < depth) continue;
            it.remove();
        }
    }

    public final void prune(int startDepth) {
        if ("false".equals(System.getProperty("sapjvm.pruneTree"))) {
            return;
        }
        if (this.nodes.size() < 1000) {
            return;
        }
        int pruneDepth = 3;
        int maxToPrune = this.nodes.size() - 900;
        while (true) {
            Iterator<T> it = this.nodes.keySet().iterator();
            this.prunedNodes.clear();
            while (it.hasNext()) {
                ValueTreeNodeBaseImpl node = (ValueTreeNodeBaseImpl)it.next();
                if (node.getDepth() < startDepth + pruneDepth || !this.shouldPrune(node)) continue;
                this.prunedNodes.add(node);
                if (this.prunedNodes.size() <= maxToPrune) continue;
                break;
            }
            if (this.prunedNodes.size() < maxToPrune) {
                return;
            }
            ++pruneDepth;
        }
    }

    public T[] getRootNodes(T startNode) {
        Iterator<T> it = this.nodes.values().iterator();
        ArrayList<ValueTreeNodeBaseImpl> directNodes = new ArrayList<ValueTreeNodeBaseImpl>();
        while (it.hasNext()) {
            ValueTreeNodeBaseImpl node = (ValueTreeNodeBaseImpl)it.next();
            if (node.getDepth() > this.maxDepth) continue;
            ValueTreeNodeBaseImpl parent = node.getParent();
            if (parent == startNode || parent.equals(startNode)) {
                directNodes.add(node);
                continue;
            }
            if (!this.prunedNodes.contains(parent)) {
                ValueTreeNodeBaseImpl<K, V>[] children;
                if (!parent.hasChildren() || !parent.hasCreatedChildren()) {
                    children = this.createArray(1);
                } else {
                    ValueTreeNodeBaseImpl<K, V>[] oldChildren = children = parent.getChildren();
                    children = this.createArray(children.length + 1);
                    System.arraycopy(oldChildren, 0, children, 0, oldChildren.length);
                }
                children[children.length - 1] = node;
                parent.setChildren(children);
                continue;
            }
            parent.setChildren(null);
        }
        return directNodes.toArray(this.createArray(directNodes.size()));
    }

    protected abstract void add(T var1, T var2);

    protected abstract boolean shouldPrune(T var1);

    protected abstract ValueTreeNodeBaseImpl<K, V>[] createArray(int var1);
}

