/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.resource.AbstractResource;
import com.sap.jvm.profiling.resource.InputStreamResourceReader;
import com.sap.jvm.profiling.resource.OutputStreamResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManager;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.impl.util.CachedSeekableFileInputStream;
import com.sap.jvm.profiling.snapshot.impl.util.LongWriteRandomAccessFile;
import com.sap.jvm.profiling.snapshot.resource.SnapshotResource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractId2DataOracle<Value>
extends AbstractResource
implements SnapshotResource {
    private static final int VERSION = 0;
    private final String temporaryIndexFilePrefix;
    private final String temporaryDataFilePrefix;
    private final long entries;
    private final ReadingPolicy policy;

    public AbstractId2DataOracle(ResourceName name, ProgressReporter reporter, String indexPrefix, String dataPrefix, ReadingPolicy readingPolicy) throws IOException {
        super(name);
        this.temporaryIndexFilePrefix = indexPrefix;
        this.temporaryDataFilePrefix = dataPrefix;
        if (new File(name.getResourceManager().getAddonPrefix(name)).exists()) {
            InputStreamResourceReader reader = new InputStreamResourceReader((InputStream)new FileInputStream(name.getResourceManager().getAddonPrefix(name)), name.getSession());
            this.entries = reader.readInt64();
            reader.close();
        } else {
            this.entries = this.createOracle(name, reporter);
        }
        this.policy = readingPolicy;
    }

    public AbstractId2DataOracle(ResourceReader reader, ResourceName name, ProgressReporter reporter, String indexPrefix, String dataPrefix) throws IOException {
        super(name);
        long createdEntries;
        this.temporaryIndexFilePrefix = indexPrefix;
        this.temporaryDataFilePrefix = dataPrefix;
        reader.readVersion(0);
        reporter.setWork(this.getMessages()[1], 1L);
        long readEntries = reader.readInt64();
        reporter.reportNextOrThrow();
        byte readingPolicy = reader.readInt8();
        assert (readingPolicy == 0 || readingPolicy == 1 || readingPolicy == 2);
        switch (readingPolicy) {
            case 0: {
                this.policy = ReadingPolicy.SIMPLE_READER;
                break;
            }
            case 1: {
                this.policy = ReadingPolicy.CACHING_READER;
                break;
            }
            case 2: {
                this.policy = ReadingPolicy.VALIDATING_READER;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid reading policy: " + readingPolicy);
            }
        }
        if (!new File(name.getResourceManager().getAddonPrefix(name)).exists() && (createdEntries = this.createOracle(name, reporter)) != readEntries) {
            throw new IOException("Inconsistent number of entries: " + readEntries + " vs. " + createdEntries);
        }
        this.entries = readEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createOracle(ResourceName name, ProgressReporter reporter) throws IOException {
        SnapshotResourceManager manager = SnapshotResourceManagerFactory.get(name.getSession());
        Snapshot snapshot = manager.getSnapshot(name);
        ProfilingReader reader = snapshot.getEventReader(reporter);
        reporter.addWork(this.getMessages()[0], reader.getNrOfPacketsToRead());
        ResourceManager resourceManager = name.getResourceManager();
        File indexFile = resourceManager.createTemporaryFile(this.temporaryIndexFilePrefix, null);
        File dataFile = resourceManager.createTemporaryFile(this.temporaryDataFilePrefix, null);
        LongWriteRandomAccessFile index = new LongWriteRandomAccessFile(indexFile);
        BufferedOutputStream dataRaw = new BufferedOutputStream(new FileOutputStream(dataFile));
        OutputStreamResourceWriter data = new OutputStreamResourceWriter((OutputStream)dataRaw, name.getSession());
        Creator creator = this.getCreator(data, index);
        AdditionalPacketReader addReader = this.getAdditionalReader(reader);
        try {
            ProfilingPacket packet;
            while ((packet = addReader.next()) != null || (packet = reader.nextPacket()) != null) {
                reporter.reportNextOrThrow();
                creator.handle(packet);
            }
        }
        finally {
            reader.close();
        }
        creator.finish();
        long dataEntries = creator.getIndexCount();
        reporter.addToMaximumWork(dataEntries);
        assert (dataEntries == index.size());
        index.close();
        data.close();
        DataInputStream indexIn = new DataInputStream(new BufferedInputStream(new FileInputStream(indexFile)));
        CachedSeekableFileInputStream dataInRaw = new CachedSeekableFileInputStream(dataFile);
        InputStreamResourceReader dataIn = new InputStreamResourceReader((InputStream)dataInRaw, name.getSession());
        assert (!new File(resourceManager.getAddonPrefix(name)).exists());
        String addonPrefix = resourceManager.getAddonPrefix(name);
        String tmpAddonPrefix = addonPrefix + ".tmp";
        BufferedOutputStream outRaw = new BufferedOutputStream(new FileOutputStream(tmpAddonPrefix));
        OutputStreamResourceWriter out = new OutputStreamResourceWriter((OutputStream)outRaw, name.getSession());
        out.writeInt64(dataEntries);
        for (long l = dataEntries; l > 0L; --l) {
            long readIndex = indexIn.readLong();
            dataInRaw.seek(readIndex);
            Entry<Value> entry = this.readData(dataIn);
            this.writeData((ResourceWriter)out, entry);
            reporter.reportNextOrThrow();
        }
        out.close();
        indexIn.close();
        dataInRaw.close();
        indexFile.delete();
        dataFile.delete();
        new File(tmpAddonPrefix).renameTo(new File(addonPrefix));
        return dataEntries;
    }

    public DataReader<Value> getReader(ProfilingSession session) throws IOException {
        switch (this.policy) {
            case SIMPLE_READER: {
                return new SimpleDataReader(session);
            }
            case CACHING_READER: {
                return new CachingDataReader(session);
            }
            case VALIDATING_READER: {
                return new ValidatingDataReader(session);
            }
        }
        throw new IllegalStateException("Invalid reading policy");
    }

    protected abstract Creator getCreator(OutputStreamResourceWriter var1, LongWriteRandomAccessFile var2);

    protected AdditionalPacketReader getAdditionalReader(ProfilingReader reader) {
        return new AdditionalPacketReader(){

            @Override
            public ProfilingPacket next() throws IOException {
                return null;
            }
        };
    }

    protected abstract void writeData(ResourceWriter var1, Entry<Value> var2) throws IOException;

    protected abstract Entry<Value> readData(InputStreamResourceReader var1) throws IOException;

    public boolean isModifiable() {
        return false;
    }

    public ResourceName[] getDependents() {
        return null;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        reporter.setWork(this.getMessages()[2], 2L);
        writer.writeInt64(this.entries);
        reporter.reportNextOrThrow();
        switch (this.policy) {
            case SIMPLE_READER: {
                writer.writeInt8(0);
                break;
            }
            case CACHING_READER: {
                writer.writeInt8(1);
                break;
            }
            case VALIDATING_READER: {
                writer.writeInt8(2);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid reading policy");
            }
        }
        reporter.reportNextOrThrow();
    }

    @Override
    public long calculateWriteWork() {
        return 1L;
    }

    protected abstract String[] getMessages();

    private class Block {
        private static final int DEFAULT_SIZE = 64;
        private Entry<Value>[] data = new Entry[64];
        private int size = 0;
        private int insertPosition = 0;
        private int first = 0;
        private long smallestId;
        private long biggestId;
        private Block next = null;

        private Block() {
        }

        public void add(Entry<Value> entry) {
            Block block = this;
            while (block.insertPosition == block.data.length) {
                if (block.next == null) {
                    block.next = new Block();
                }
                block = block.next;
            }
            block.data[block.insertPosition++] = entry;
            if (block.size++ == 0) {
                block.smallestId = entry.getId();
            }
            assert (block.biggestId == 0L || block.biggestId < entry.getId());
            block.biggestId = entry.getId();
            assert (block.smallestId <= block.biggestId);
        }

        public Entry<Value> find(long id) {
            Block block;
            block3: {
                block = this;
                while (true) {
                    assert (block.size > 0);
                    if (block.size != 0 && id <= block.biggestId) break block3;
                    if (block.next == null) break;
                    block = block.next;
                }
                return null;
            }
            if (id < block.smallestId) {
                return null;
            }
            return block.findImpl(id);
        }

        private Entry<Value> findImpl(long id) {
            boolean firstValue = true;
            for (int i = this.first; i < this.data.length; ++i) {
                if (this.data[i] == null) continue;
                if (firstValue) {
                    this.first = i;
                    firstValue = false;
                }
                if (id != this.data[i].getId()) continue;
                return this.data[i];
            }
            return null;
        }

        public void remove(long id) {
            Block previous;
            Block block;
            block4: {
                block = this;
                previous = null;
                while (true) {
                    assert (block.size > 0);
                    if (block.size != 0 && id <= block.biggestId) break block4;
                    if (block.next == null) break;
                    previous = block;
                    block = block.next;
                }
                return;
            }
            if (id < block.smallestId) {
                return;
            }
            block.removeImpl(id);
            if (block.isEmpty() && previous != null) {
                previous.next = previous.next.next;
            }
        }

        private void removeImpl(long id) {
            boolean firstValue = true;
            for (int i = this.first; i < this.data.length; ++i) {
                if (this.data[i] == null) continue;
                if (id == this.data[i].getId()) {
                    this.data[i] = null;
                    --this.size;
                    if (!firstValue) break;
                    this.first = i + 1;
                    break;
                }
                firstValue = false;
            }
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public Block getNextNonNull() {
            return this.next != null ? this.next : new Block();
        }
    }

    private class CachingDataReader
    implements DataReader<Value> {
        private Block head;
        private final InputStreamResourceReader reader;
        private long biggestId;
        private long entriesRead;

        public CachingDataReader(ProfilingSession session) throws IOException {
            this.head = new Block();
            this.biggestId = Long.MIN_VALUE;
            this.entriesRead = 0L;
            ResourceName name = AbstractId2DataOracle.this.getResourceName();
            String filename = name.getResourceManager().getAddonPrefix(name);
            this.reader = new InputStreamResourceReader((InputStream)new BufferedInputStream(new FileInputStream(filename)), session);
            this.reader.readInt64();
        }

        @Override
        public Value getData(long id) throws IOException {
            if (id > this.biggestId) {
                Entry entry;
                do {
                    if (this.entriesRead++ >= AbstractId2DataOracle.this.entries) {
                        throw new EOFException("Trying to read too many entries");
                    }
                    entry = AbstractId2DataOracle.this.readData(this.reader);
                    assert (entry.getId() > this.biggestId);
                    this.biggestId = entry.getId();
                    this.head.add(entry);
                    if (entry.getId() != id) continue;
                    return entry.getValue();
                } while (entry.getId() < id);
                throw new IllegalArgumentException("Identifier not found: " + id);
            }
            Entry entry = this.head.find(id);
            if (entry == null) {
                throw new IllegalArgumentException("Identifier not found: " + id);
            }
            return entry.getValue();
        }

        @Override
        public void finished(long id) {
            this.head.remove(id);
            if (this.head.isEmpty()) {
                this.head = this.head.getNextNonNull();
            }
        }

        @Override
        public void close() throws IOException {
            this.head = null;
            this.reader.close();
        }
    }

    public class SimpleDataReader
    implements DataReader<Value> {
        private final InputStreamResourceReader reader;
        private Entry<Value> entry;
        private boolean isEOF;
        private long lastId;

        public SimpleDataReader(ProfilingSession session) throws IOException {
            ResourceName name = AbstractId2DataOracle.this.getResourceName();
            String filename = name.getResourceManager().getAddonPrefix(name);
            this.reader = new InputStreamResourceReader((InputStream)new BufferedInputStream(new FileInputStream(filename)), session);
            this.reader.readInt64();
            this.lastId = -1L;
        }

        @Override
        public Value getData(long id) throws IOException {
            assert (id >= this.lastId);
            this.lastId = id;
            if (this.entry == null) {
                if (this.isEOF) {
                    return null;
                }
                try {
                    this.entry = AbstractId2DataOracle.this.readData(this.reader);
                }
                catch (EOFException e) {
                    this.isEOF = true;
                    this.entry = null;
                    return null;
                }
            }
            while (this.entry.getId() < id) {
                try {
                    long oldId = this.entry.getId();
                    this.entry = AbstractId2DataOracle.this.readData(this.reader);
                    assert (this.entry.getId() > oldId);
                }
                catch (EOFException e) {
                    this.isEOF = true;
                    this.entry = null;
                    return null;
                }
            }
            if (this.entry.getId() == id) {
                return this.entry.getValue();
            }
            return null;
        }

        @Override
        public void finished(long id) {
            assert (false);
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    public class ValidatingDataReader
    implements DataReader<Value> {
        private final SimpleDataReader simpleReader;
        private final CachingDataReader cachingReader;

        public ValidatingDataReader(ProfilingSession session) throws IOException {
            this.simpleReader = new SimpleDataReader(session);
            this.cachingReader = new CachingDataReader(session);
        }

        @Override
        public Value getData(long id) throws IOException {
            Object cachedData;
            Object simpleData = this.simpleReader.getData(id);
            if (simpleData.equals(cachedData = this.cachingReader.getData(id))) {
                return simpleData;
            }
            throw new IllegalStateException("Divergence between readers: id=" + id + ", simple data=" + simpleData + ", cached data=" + cachedData);
        }

        @Override
        public void finished(long id) {
            this.simpleReader.finished(id);
            this.cachingReader.finished(id);
        }

        @Override
        public void close() throws IOException {
            this.simpleReader.close();
            this.cachingReader.close();
        }
    }

    public static interface DataReader<Value> {
        public Value getData(long var1) throws IOException;

        public void finished(long var1);

        public void close() throws IOException;
    }

    public static class Entry<Value> {
        private final long id;
        private final Value value;

        public Entry(long id, Value value) {
            this.id = id;
            this.value = value;
        }

        public long getId() {
            return this.id;
        }

        public Value getValue() {
            return this.value;
        }
    }

    public static interface AdditionalPacketReader {
        public ProfilingPacket next() throws IOException;
    }

    public abstract class Creator {
        private final OutputStreamResourceWriter writer;
        private final LongWriteRandomAccessFile index;
        private long offset;
        private final Map<Long, Long> indexOffsets = new HashMap<Long, Long>();
        private long indexCount = 0L;

        public Creator(OutputStreamResourceWriter writer, LongWriteRandomAccessFile index) {
            this.writer = writer;
            this.index = index;
        }

        public final void handle(ProfilingPacket packet) throws IOException {
            assert (this.writer.written() != Integer.MAX_VALUE);
            this.offset = this.writer.written();
            this.handleImpl(packet);
        }

        protected abstract void handleImpl(ProfilingPacket var1) throws IOException;

        public final void finish() throws IOException {
            this.prepareForFinish();
            Long[] longArray = this.indexOffsets.keySet().toArray(new Long[this.indexOffsets.size()]);
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long id = longArray[i];
                this.offset = this.writer.written();
                this.finishImpl(id);
            }
        }

        protected abstract void finishImpl(long var1) throws IOException;

        protected abstract void prepareForFinish();

        protected void writeValue(Entry<Value> data) throws IOException {
            AbstractId2DataOracle.this.writeData((ResourceWriter)this.writer, data);
        }

        public void writeIndex(long id) throws IOException {
            long indexOffset;
            Long indexOffsetLong = this.indexOffsets.remove(id);
            if (indexOffsetLong != null) {
                indexOffset = indexOffsetLong;
            } else {
                indexOffset = this.index.size();
                ++this.indexCount;
            }
            this.index.write(indexOffset, this.offset);
        }

        public void createDummyIndex(long id) throws IOException {
            long indexOffset = this.index.size();
            this.index.write(indexOffset, -1L);
            assert (this.indexOffsets.get(id) == null);
            this.indexOffsets.put(id, indexOffset);
            ++this.indexCount;
        }

        public long getIndexCount() {
            return this.indexCount;
        }
    }

    public static enum ReadingPolicy {
        SIMPLE_READER,
        CACHING_READER,
        VALIDATING_READER;

    }
}

