/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;

public class CachedSeekableFileInputStream
extends InputStream {
    private static final int BYTES_PER_CACHE_LINE_LOG = 15;
    private static final int BYTES_PER_CACHE_LINE = 32768;
    private static final int NR_OF_CACHE_LINES = 16;
    private final LinkedHashMap<Integer, byte[]> cache;
    private int currIndex;
    private byte[] currCacheLine;
    private final RandomAccessFile file;
    private long offset;

    public CachedSeekableFileInputStream(File filename) throws IOException {
        this.file = new RandomAccessFile(filename, "r");
        this.cache = new LinkedHashMap();
    }

    private final void ensureCurrentCacheLine(int index) throws IOException {
        int result;
        byte[] cacheLine = this.cache.get(index);
        if (cacheLine != null) {
            this.currIndex = index;
            this.currCacheLine = cacheLine;
            return;
        }
        if (this.cache.size() >= 16) {
            this.cache.remove(this.currIndex);
            int indexToRemove = this.cache.keySet().iterator().next();
            this.currCacheLine = (byte[])this.cache.remove(indexToRemove);
            this.cache.put(index, this.currCacheLine);
        } else {
            this.currCacheLine = new byte[32768];
            this.cache.put(index, this.currCacheLine);
        }
        this.file.seek((long)index << 15);
        int pos = 0;
        for (int left = this.currCacheLine.length; left > 0 && (result = this.file.read(this.currCacheLine, pos, left)) > 0; left -= result) {
            pos += result;
        }
        this.currIndex = index;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public int read() throws IOException {
        int index = (int)(this.offset >> 15);
        if (this.currIndex != index || this.currCacheLine == null) {
            this.ensureCurrentCacheLine(index);
        }
        index = (int)(this.offset & 0x7FFFL);
        ++this.offset;
        return 0xFF & this.currCacheLine[index];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int index = (int)(this.offset >> 15);
        int fromStart = (int)(this.offset & 0x7FFFL);
        int pos = off;
        int left = len;
        while (left > 0) {
            if (this.currIndex != index || this.currCacheLine == null) {
                this.ensureCurrentCacheLine(index);
            }
            int fromEnd = Math.min(fromStart + left, 32768);
            int size = fromEnd - fromStart;
            System.arraycopy(this.currCacheLine, fromStart, b, pos, size);
            left -= size;
            pos += size;
            ++index;
            fromStart = 0;
        }
        this.offset += (long)len;
        return len;
    }

    public void seek(long newOffset) {
        assert (newOffset >= 0L);
        this.offset = newOffset;
    }
}

