/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util;

import com.sap.jvm.util.misc.ByteConverter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.LinkedHashMap;

public class LongWriteRandomAccessFile {
    private static final int LONGS_PER_CACHE_LINE_LOG = 13;
    private static final int LONGS_PER_CACHE_LINE = 8192;
    private static final int NR_OF_CACHE_LINES = 16;
    private final LinkedHashMap<Integer, long[]> cache;
    private final byte[] buffer;
    private long currIndex;
    private long[] currCacheLine;
    private final RandomAccessFile file;
    private long size;
    private long fileSize;

    public LongWriteRandomAccessFile(File filename) throws IOException {
        this.file = new RandomAccessFile(filename, "rw");
        this.cache = new LinkedHashMap();
        this.buffer = new byte[65536];
        this.currIndex = -1L;
    }

    private final long[] removeFromCache(int indexToRemove) throws IOException {
        long[] line = this.cache.get(indexToRemove);
        this.cache.remove(indexToRemove);
        if (this.currIndex == (long)indexToRemove) {
            this.currCacheLine = null;
        }
        int pos = 0;
        for (long value : line) {
            this.buffer[pos] = (byte)(value >>> 56);
            this.buffer[pos + 1] = (byte)(value >>> 48);
            this.buffer[pos + 2] = (byte)(value >>> 40);
            this.buffer[pos + 3] = (byte)(value >>> 32);
            this.buffer[pos + 4] = (byte)(value >>> 24);
            this.buffer[pos + 5] = (byte)(value >>> 16);
            this.buffer[pos + 6] = (byte)(value >>> 8);
            this.buffer[pos + 7] = (byte)(value >>> 0);
            pos += 8;
        }
        long offset = (long)indexToRemove << 16;
        this.fileSize = Math.max(offset + (long)this.buffer.length, this.fileSize);
        this.file.seek(offset);
        this.file.write(this.buffer);
        return line;
    }

    private final void ensureCurrentCacheLine(int index) throws IOException {
        long[] cacheLine = this.cache.get(index);
        if (cacheLine != null) {
            this.currIndex = index;
            this.currCacheLine = cacheLine;
            return;
        }
        if (this.cache.size() >= 16) {
            int indexToRemove = this.cache.keySet().iterator().next();
            this.currCacheLine = this.removeFromCache(indexToRemove);
            this.cache.remove(index);
            this.cache.put(index, this.currCacheLine);
        } else {
            this.currCacheLine = new long[8192];
            this.cache.put(index, this.currCacheLine);
        }
        long offset = (long)index << 16;
        if (offset < this.fileSize) {
            this.file.seek(offset);
            this.file.readFully(this.buffer);
            int pos = 0;
            for (int i = 0; i < 8192; ++i) {
                this.currCacheLine[i] = ByteConverter.readInt64((byte[])this.buffer, (int)pos);
                pos += 8;
            }
        } else {
            Arrays.fill(this.currCacheLine, 0L);
        }
        this.currIndex = index;
    }

    public void write(long offset, long value) throws IOException {
        assert (offset >= 0L);
        int index = (int)(offset >> 13);
        if (this.currIndex != (long)index) {
            this.ensureCurrentCacheLine(index);
        }
        this.size = Math.max(offset + 1L, this.size);
        index = (int)(offset & 0x1FFFL);
        this.currCacheLine[index] = value;
    }

    public long size() {
        return this.size;
    }

    public void close() throws IOException {
        Integer[] indices;
        Integer[] integerArray = indices = this.cache.keySet().toArray(new Integer[this.cache.size()]);
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int index = integerArray[i];
            this.removeFromCache(index);
        }
        assert (this.cache.isEmpty());
        this.file.close();
    }
}

