/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.elements.GenericThreadAnnotationElement;

public final class ThreadAnnotationUtil {
    public static String getWriteText(ResourceName name) {
        int annotationSlot = ThreadAnnotationUtil.getAnnotationSlot(name);
        switch (annotationSlot) {
            case 0: {
                return I18n._s((String)"Writing the user statistic ... (<%> %)");
            }
            case 3: {
                return I18n._s((String)"Writing the application statistic ... (<%> %)");
            }
            case 1: {
                return I18n._s((String)"Writing the session statistic ... (<%> %)");
            }
            case 2: {
                return I18n._s((String)"Writing the request statistic ... (<%> %)");
            }
            case 5: {
                return I18n._s((String)"Writing the tenant statistic ... (<%> %)");
            }
        }
        return I18n._s((String)"Writing the {0} statistic ... (<%> %)", (Object[])new Object[]{ThreadAnnotationUtil.getAnnotationKey(name)});
    }

    public static int getAnnotationSlot(ResourceName name) {
        GenericThreadAnnotationElement statistic = (GenericThreadAnnotationElement)name.getLastElement();
        int annotationIndex = statistic.getAnnotationSlot();
        return annotationIndex;
    }

    public static String getAnnotationKey(ResourceName name) {
        GenericThreadAnnotationElement statistic = (GenericThreadAnnotationElement)name.getLastElement();
        int annotationIndex = statistic.getAnnotationSlot();
        String annotationKey = name.getSession().getAnnotationKey(annotationIndex).toString();
        return annotationKey;
    }

    public static String getReadText(ResourceName name) {
        int annotationSlot = ThreadAnnotationUtil.getAnnotationSlot(name);
        switch (annotationSlot) {
            case 0: {
                return I18n._s((String)"Reading the user statistic ... (<%> %)");
            }
            case 3: {
                return I18n._s((String)"Reading the application statistic ... (<%> %)");
            }
            case 1: {
                return I18n._s((String)"Reading the session statistic ... (<%> %)");
            }
            case 2: {
                return I18n._s((String)"Reading the request statistic ... (<%> %)");
            }
            case 5: {
                return I18n._s((String)"Reading the tenant statistic ... (<%> %)");
            }
        }
        return I18n._s((String)"Reading the {0} statistic ... (<%> %)", (Object[])new Object[]{ThreadAnnotationUtil.getAnnotationKey(name)});
    }

    public static String getCreateText(ResourceName name) {
        int annotationSlot = ThreadAnnotationUtil.getAnnotationSlot(name);
        switch (annotationSlot) {
            case 0: {
                return I18n._s((String)"Creating the user statistic ... (<%> %)");
            }
            case 3: {
                return I18n._s((String)"Creating the application statistic ... (<%> %)");
            }
            case 1: {
                return I18n._s((String)"Creating the session statistic ... (<%> %)");
            }
            case 2: {
                return I18n._s((String)"Creating the request statistic ... (<%> %)");
            }
            case 5: {
                return I18n._s((String)"Creating the tenant statistic ... (<%> %)");
            }
        }
        return I18n._s((String)"Creating the {0} statistic ... (<%> %)", (Object[])new Object[]{ThreadAnnotationUtil.getAnnotationKey(name)});
    }
}

