/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.collections;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.resource.AbstractDependentResource;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.Serializer;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueStatistic;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.snapshot.util.column.ObjectColumn;
import java.io.IOException;
import java.util.List;

public abstract class SelfAndTotalValueStatisticImpl<K, V extends Value<V>>
extends AbstractDependentResource
implements SelfAndTotalValueStatistic<K, V> {
    private static final int VERSION = 1;
    private final SerializableColumn<K> keys;
    private final SerializableColumn<V> selfs;
    private final SerializableColumn<V> totals;
    private V total;
    private final Serializer<V> valueSerializer;

    public SelfAndTotalValueStatisticImpl(ResourceName name, SerializableColumn<K> keys, SerializableColumn<V> selfs, SerializableColumn<V> totals, Serializer<V> valueSerializer) {
        super(name);
        this.keys = keys;
        this.selfs = selfs;
        this.totals = totals;
        this.valueSerializer = valueSerializer;
    }

    public void read(ResourceReader reader, String message, ProgressReporter reporter) throws IOException {
        reader.readVersion(1);
        int size = reader.readInt32();
        reporter.addWork(message, this.keys.getWork(size) + this.selfs.getWork(size) + this.totals.getWork(size));
        this.total = (Value)this.valueSerializer.read(reader);
        this.keys.read(reader, reporter);
        this.selfs.read(reader, reporter);
        this.totals.read(reader, reporter);
    }

    protected void write(ResourceWriter writer, String message, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        writer.writeInt32(this.size());
        reporter.addWork(message, this.keys.getWork(this.size()) + this.selfs.getWork(this.size()) + this.totals.getWork(this.size()));
        this.valueSerializer.write(this.total, writer);
        this.keys.write(writer, reporter);
        this.selfs.write(writer, reporter);
        this.totals.write(writer, reporter);
    }

    @Override
    public V getSelf(int index) {
        return (V)((Value)this.selfs.get(index));
    }

    @Override
    public V getTotal(int index) {
        return (V)((Value)this.totals.get(index));
    }

    @Override
    public V getTotal() {
        return this.total;
    }

    @Override
    public K getKey(int index) {
        return (K)this.keys.get(index);
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public long calculateWriteWork() {
        return this.size() * 3;
    }

    public boolean isModifiable() {
        return false;
    }

    public void initSelfAndTotal(List<K> keys, List<V> selfs, List<V> totals, V total) {
        this.keys.fromList(keys);
        keys.clear();
        this.selfs.fromList(selfs);
        selfs.clear();
        this.totals.fromList(totals);
        totals.clear();
        this.total = total;
    }

    @Override
    public ObjectColumn<V> getSelfColumn() {
        return this.selfs;
    }

    @Override
    public ObjectColumn<V> getTotalColumn() {
        return this.totals;
    }

    @Override
    public ObjectColumn<K> getKeyColumn() {
        return this.keys;
    }
}

