/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.collections;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.Serializer;
import com.sap.jvm.profiling.snapshot.util.SelfTotalAndOtherValueStatistic;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.snapshot.util.column.ObjectColumn;
import java.io.IOException;
import java.util.List;

public abstract class SelfTotalAndOtherValueStatisticImpl<K, V extends Value<V>, O extends Value<O>>
extends SelfAndTotalValueStatisticImpl<K, V>
implements SelfTotalAndOtherValueStatistic<K, V, O> {
    private static final int VERSION = 1;
    private final SerializableColumn<O> others;
    private O totalOther;
    private final Serializer<O> otherValueSerializer;

    public SelfTotalAndOtherValueStatisticImpl(ResourceName name, SerializableColumn<K> keys, SerializableColumn<V> selfs, SerializableColumn<V> totals, Serializer<V> valueSerializer, SerializableColumn<O> others, Serializer<O> otherValueSerializer) {
        super(name, keys, selfs, totals, valueSerializer);
        this.others = others;
        this.otherValueSerializer = otherValueSerializer;
    }

    @Override
    public void read(ResourceReader reader, String message, ProgressReporter reporter) throws IOException {
        reader.readVersion(1);
        int size = reader.readInt32();
        reporter.addWork(message, this.others.getWork(size));
        super.read(reader, message, reporter);
        this.totalOther = (Value)this.otherValueSerializer.read(reader);
        this.others.read(reader, reporter);
    }

    @Override
    protected void write(ResourceWriter writer, String message, ProgressReporter reporter) throws IOException {
        reporter.addWork(message, this.others.getWork(this.size()));
        writer.writeVersion(1);
        writer.writeInt32(this.size());
        super.write(writer, message, reporter);
        this.otherValueSerializer.write(this.totalOther, writer);
        this.others.write(writer, reporter);
    }

    @Override
    public long calculateWriteWork() {
        return this.size() * 4;
    }

    @Override
    public O getOther() {
        return this.totalOther;
    }

    @Override
    public O getOther(int index) {
        return (O)((Value)this.others.get(index));
    }

    public void initOther(List<O> others, O totalOther) {
        this.others.fromList(others);
        others.clear();
        this.totalOther = totalOther;
    }

    @Override
    public ObjectColumn<O> getOtherColumn() {
        return this.others;
    }
}

