/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.collections;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.resource.AbstractDependentResource;
import com.sap.jvm.profiling.snapshot.impl.util.column.SerializableColumn;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.Serializer;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.snapshot.util.ValueStatistic;
import com.sap.jvm.profiling.snapshot.util.column.ObjectColumn;
import java.io.IOException;
import java.util.List;

public abstract class ValueStatisticImpl<K, V extends Value<V>>
extends AbstractDependentResource
implements ValueStatistic<K, V> {
    private static final int VERSION = 1;
    private final SerializableColumn<K> keys;
    private final SerializableColumn<V> values;
    private V total;
    private final Serializer<V> valueSerializer;

    public ValueStatisticImpl(ResourceName name, SerializableColumn<K> keys, SerializableColumn<V> values, Serializer<V> valueSerializer) {
        super(name);
        this.keys = keys;
        this.values = values;
        this.valueSerializer = valueSerializer;
    }

    public void read(ResourceReader reader, String message, ProgressReporter reporter) throws IOException {
        reader.readVersion(1);
        int size = reader.readInt32();
        reporter.addWork(message, this.keys.getWork(size) + this.values.getWork(size));
        this.total = (Value)this.valueSerializer.read(reader);
        this.keys.read(reader, reporter);
        this.values.read(reader, reporter);
    }

    protected void write(ResourceWriter writer, String message, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        writer.writeInt32(this.size());
        reporter.addWork(message, this.keys.getWork(this.size()) + this.values.getWork(this.size()));
        this.valueSerializer.write(this.total, writer);
        this.keys.write(writer, reporter);
        this.values.write(writer, reporter);
    }

    @Override
    public V getValue(int index) {
        return (V)((Value)this.values.get(index));
    }

    @Override
    public V getValue() {
        return this.total;
    }

    @Override
    public K getKey(int index) {
        return (K)this.keys.get(index);
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public long calculateWriteWork() {
        return this.size() * 3;
    }

    public boolean isModifiable() {
        return false;
    }

    public void initValues(List<K> keys, List<V> values, V total) {
        this.keys.fromList(keys);
        keys.clear();
        this.values.fromList(values);
        values.clear();
        this.total = total;
    }

    @Override
    public ObjectColumn<K> getKeyColumn() {
        return this.keys;
    }

    @Override
    public ObjectColumn<V> getValueColumn() {
        return this.values;
    }
}

