/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.collections;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.resource.AbstractDependentResource;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueTreeNodeBaseImpl;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.Serializer;
import com.sap.jvm.profiling.snapshot.resource.SnapshotResource;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.snapshot.util.ValueTreeBase;
import com.sap.jvm.profiling.snapshot.util.ValueTreeNodeBase;
import com.sap.jvm.profiling.util.IntArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class ValueTreeBaseImpl<K, V extends Value<V>, T extends ValueTreeNodeBase<K, V>>
extends AbstractDependentResource
implements ValueTreeBase<K, V, T>,
SnapshotResource {
    private static final int VERSION = 2;
    private static final int HAS_CHILDREN = 1;
    private static final int HAS_SUB_NODES = 2;
    private static final int IS_SUB_NODE = 4;
    private ValueTreeNodeBaseImpl<K, V>[] roots = null;
    private V total;
    private final Serializer<T> serializer;
    private final Serializer<V> totalSerializer;

    public ValueTreeBaseImpl(ResourceName name, Serializer<T> serializer, Serializer<V> totalSerializer) {
        super(name);
        this.serializer = serializer;
        this.totalSerializer = totalSerializer;
    }

    public void read(ResourceReader reader, ProgressReporter reporter, String message) throws IOException {
        int i;
        reader.readVersion(2);
        this.total = (Value)this.totalSerializer.read(reader);
        int nrOfRoots = reader.readInt32();
        int nrOfNodes = reader.readInt32();
        this.roots = new ValueTreeNodeBaseImpl[nrOfRoots];
        ValueTreeNodeBaseImpl[] nodes = new ValueTreeNodeBaseImpl[nrOfNodes];
        reporter.setWork(message, (long)nrOfNodes);
        for (int i2 = 0; i2 < nrOfNodes; ++i2) {
            reporter.reportNextOrThrow();
            ValueTreeNodeBaseImpl node = (ValueTreeNodeBaseImpl)this.serializer.read(reader);
            byte state = reader.readInt8();
            if ((state & 1) != 0) {
                node.setHasChildren();
            }
            if ((state & 2) != 0) {
                node.setHasSubNodes();
            }
            if ((state & 4) != 0) {
                node.setIsSubNode();
            }
            nodes[i2] = node;
        }
        int[] parentIndices = new int[reader.readInt32()];
        int[] nrOfChildrenList = new int[parentIndices.length];
        int[] nrOfSubNodesList = new int[parentIndices.length];
        for (int i3 = 0; i3 < parentIndices.length; ++i3) {
            parentIndices[i3] = reader.readInt32();
            nrOfChildrenList[i3] = reader.readInt32();
            nrOfSubNodesList[i3] = reader.readInt32();
        }
        int index = nodes.length;
        for (i = parentIndices.length - 1; i >= 0; --i) {
            int j;
            ValueTreeNodeBaseImpl parent = nodes[parentIndices[i]];
            int nrOfChildren = nrOfChildrenList[i];
            int nrOfSubNodes = nrOfSubNodesList[i];
            assert (nrOfChildren + nrOfSubNodes > 0);
            index -= nrOfChildren + nrOfSubNodes;
            if (nrOfChildren > 0) {
                ValueTreeNodeBaseImpl[] children = new ValueTreeNodeBaseImpl[nrOfChildren];
                for (j = 0; j < nrOfChildren; ++j) {
                    children[j] = nodes[index + j];
                    children[j].setParent(parent);
                }
                parent.setChildren(children);
            }
            if (nrOfSubNodes <= 0) continue;
            ValueTreeNodeBaseImpl[] subNodes = new ValueTreeNodeBaseImpl[nrOfSubNodes];
            for (j = 0; j < nrOfSubNodes; ++j) {
                subNodes[j] = nodes[index + j + nrOfChildren];
                subNodes[j].setParent(parent);
            }
            parent.setSubNodes(subNodes);
        }
        assert (index == nrOfRoots);
        for (i = index; i < nodes.length; ++i) {
            nodes[i].recalculateDepth();
        }
        for (i = 0; i < nrOfRoots; ++i) {
            this.roots[i] = nodes[i];
        }
    }

    @Override
    public final T[] getRoots() {
        return this.roots;
    }

    public final void init(T[] roots, V total) {
        this.roots = (ValueTreeNodeBaseImpl[])roots;
        this.total = total;
    }

    public void write(ResourceWriter writer, ProgressReporter reporter, String message) throws IOException {
        int index;
        writer.writeVersion(2);
        this.totalSerializer.write(this.total, writer);
        writer.writeInt32(this.roots.length);
        ArrayList toWrite = new ArrayList();
        IntArrayList parentIndices = new IntArrayList();
        IntArrayList nrOfChildrenList = new IntArrayList();
        IntArrayList nrOfSubNodesList = new IntArrayList();
        toWrite.addAll(Arrays.asList(this.roots));
        for (index = 0; index < toWrite.size(); ++index) {
            ValueTreeNodeBaseImpl node = (ValueTreeNodeBaseImpl)toWrite.get(index);
            int n = 0;
            int nrOfSubNodes = 0;
            if (node.hasChildren() && node.hasCreatedChildren()) {
                ValueTreeNodeBaseImpl<K, V>[] children = node.getChildren();
                n = children.length;
                for (ValueTreeNodeBaseImpl child : children) {
                    toWrite.add(child);
                }
            }
            if (node.hasSubNodes() && node.hasCreatedSubNodes()) {
                ValueTreeNodeBaseImpl<K, V>[] subNodes = node.getSubNodes();
                nrOfSubNodes = subNodes.length;
                for (ValueTreeNodeBaseImpl subNode : subNodes) {
                    toWrite.add(subNode);
                }
            }
            if (n + nrOfSubNodes <= 0) continue;
            parentIndices.push(index);
            nrOfChildrenList.push(n);
            nrOfSubNodesList.push(nrOfSubNodes);
        }
        writer.writeInt32(toWrite.size());
        reporter.setWork(message, (long)index);
        for (ValueTreeNodeBaseImpl valueTreeNodeBaseImpl : toWrite) {
            reporter.reportNextOrThrow();
            this.serializer.write(valueTreeNodeBaseImpl, writer);
            int state = valueTreeNodeBaseImpl.hasChildren() ? 1 : 0;
            state |= valueTreeNodeBaseImpl.hasSubNodes() ? 2 : 0;
            writer.writeInt8(state |= valueTreeNodeBaseImpl.isSubNode() ? 4 : 0);
        }
        writer.writeInt32(parentIndices.size());
        for (int i = 0; i < parentIndices.size(); ++i) {
            writer.writeInt32(parentIndices.get(i));
            writer.writeInt32(nrOfChildrenList.get(i));
            writer.writeInt32(nrOfSubNodesList.get(i));
        }
    }

    @Override
    public long calculateWriteWork() {
        int index;
        ArrayList toWrite = new ArrayList();
        toWrite.addAll(Arrays.asList(this.roots));
        for (index = 0; index < toWrite.size(); ++index) {
            ValueTreeNodeBaseImpl node = (ValueTreeNodeBaseImpl)toWrite.get(index);
            if (node.hasChildren() && node.hasCreatedChildren()) {
                toWrite.addAll(Arrays.asList(node.getChildren()));
            }
            if (!node.hasSubNodes() || !node.hasCreatedSubNodes()) continue;
            toWrite.addAll(Arrays.asList(node.getSubNodes()));
        }
        return index;
    }

    @Override
    public final T[] getChildren(T node) {
        return ((ValueTreeNodeBaseImpl)node).getChildren();
    }

    @Override
    public final T getParent(T node) {
        return (T)((ValueTreeNodeBaseImpl)node).getParent();
    }

    @Override
    public final T getRoot(T node) {
        return (T)((ValueTreeNodeBaseImpl)node).getRoot();
    }

    @Override
    public final T[] getSubNodes(T node) {
        return ((ValueTreeNodeBaseImpl)node).getSubNodes();
    }

    public boolean isModifiable() {
        return true;
    }

    @Override
    public V getTotal() {
        return this.total;
    }
}

