/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.collections;

import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.snapshot.util.ValueTreeNodeBase;

public abstract class ValueTreeNodeBaseImpl<K, V extends Value<V>>
implements ValueTreeNodeBase<K, V> {
    private K key;
    private ValueTreeNodeBaseImpl<K, V> parent;
    private ValueTreeNodeBaseImpl<K, V>[] children;
    private ValueTreeNodeBaseImpl<K, V>[] subNodes;
    private int depth;
    private int hash;

    protected ValueTreeNodeBaseImpl(ValueTreeNodeBaseImpl<K, V> parent, K key, boolean isSubNode) {
        this.parent = parent;
        this.key = key;
        this.depth = parent != null ? parent.getDepth() + (isSubNode ? 0 : 1) << 3 : 8;
        if (isSubNode) {
            this.depth |= 4;
        }
        if (parent != null) {
            this.hash = parent.hash * 31;
        }
        this.hash ^= key.hashCode() ^ this.depth >>> 3;
    }

    public void recalculateDepth() {
        this.depth = this.parent == null ? (this.depth &= 7) : this.parent.getDepth() + (this.isSubNode() ? 0 : 1) << 3 | this.depth & 7;
    }

    public final ValueTreeNodeBaseImpl<K, V>[] getChildren() {
        assert (this.hasCreatedChildren());
        return this.children;
    }

    @Override
    public final int getDepth() {
        return this.depth >>> 3;
    }

    public final ValueTreeNodeBaseImpl<K, V> getParent() {
        return this.parent;
    }

    public final ValueTreeNodeBaseImpl<K, V> getRoot() {
        if (this.parent == null) {
            return this;
        }
        ValueTreeNodeBaseImpl<K, V> curr = this.parent;
        ValueTreeNodeBaseImpl<K, V> next;
        while ((next = curr.parent) != null) {
            curr = next;
        }
        return curr;
    }

    public final ValueTreeNodeBaseImpl<K, V>[] getSubNodes() {
        assert (this.hasCreatedSubNodes());
        return this.subNodes;
    }

    @Override
    public final boolean hasChildren() {
        return (this.depth & 1) != 0;
    }

    @Override
    public final boolean hasCreatedChildren() {
        assert (this.hasChildren());
        return this.children != null;
    }

    @Override
    public final boolean hasCreatedSubNodes() {
        assert (this.hasSubNodes());
        return this.subNodes != null;
    }

    @Override
    public final boolean hasSubNodes() {
        return (this.depth & 2) != 0;
    }

    @Override
    public final boolean isSubNode() {
        return (this.depth & 4) != 0;
    }

    public final void setIsSubNode() {
        this.depth |= 4;
    }

    public final void setChildren(ValueTreeNodeBaseImpl<K, V>[] children) {
        assert (this.hasChildren() || children == null);
        this.children = children;
    }

    public final void setHasChildren() {
        this.depth |= 1;
    }

    public final void setHasNoChildren() {
        this.depth &= 0xFFFFFFFE;
        this.children = null;
    }

    @Override
    public final boolean hasSiblings() {
        assert (this.parent == null || this.parent.children.length >= 1);
        return this.parent != null && this.parent.children.length != 1;
    }

    public final void setHasSubNodes() {
        this.depth |= 2;
    }

    public final void setParent(ValueTreeNodeBaseImpl<K, V> parent) {
        this.parent = parent;
    }

    public final void setSubNodes(ValueTreeNodeBaseImpl<K, V>[] subNodes) {
        assert (this.hasSubNodes());
        this.subNodes = subNodes;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ValueTreeNodeBaseImpl) {
            ValueTreeNodeBaseImpl otherNode = (ValueTreeNodeBaseImpl)other;
            if (this.hash != otherNode.hash) {
                return false;
            }
            if (((this.depth ^ otherNode.depth) & 0xFFFFFFF8) != 0) {
                return false;
            }
            if (!this.key.equals(otherNode.key)) {
                return false;
            }
            ValueTreeNodeBaseImpl<K, V> thisParent = this.parent;
            ValueTreeNodeBaseImpl<K, V> otherParent = otherNode.parent;
            for (int i = (this.depth >>> 3) - 2; i >= 0; --i) {
                if (thisParent == otherParent) {
                    return true;
                }
                if (thisParent.hash != otherParent.hash) {
                    return false;
                }
                if (!thisParent.key.equals(otherParent.key)) {
                    return false;
                }
                thisParent = thisParent.parent;
                otherParent = otherParent.parent;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        return this.hash;
    }

    @Override
    public final K getKey() {
        return this.key;
    }

    @Override
    public final void fillInPathFromRoots(K[] path) {
        assert (path.length == this.getDepth());
        int index = path.length - 1;
        ValueTreeNodeBaseImpl<K, V> node = this;
        while (true) {
            path[index] = node.key;
            if (node.isSubNode()) {
                while ((node = node.getParent()).isSubNode()) {
                }
            }
            if (--index < 0) break;
            node = node.getParent();
        }
    }
}

