/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.collector;

import com.sap.jvm.profiling.snapshot.impl.collections.EntryHashSet;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.EntrySorter;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfAndTotalValueEntry;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.util.splitarray.SplitArrayObject;

public class SelfAndTotalValueStatisticCollector<K, V extends Value<V>> {
    private final EntryHashSet<K> set = new EntryHashSet();
    private V total;
    private final V empty;
    private EntrySorter<K> sorter;

    public SelfAndTotalValueStatisticCollector(V empty) {
        this.total = empty;
        this.empty = empty;
    }

    public void setSorter(EntrySorter<K> sorter) {
        this.sorter = sorter;
    }

    public void addSelf(K key, V value) {
        SelfAndTotalValueEntry<K, V> curr = (SelfAndTotalValueEntry<K, V>)this.set.get(key);
        if (curr == null) {
            curr = new SelfAndTotalValueEntry<K, V>(key, value, this.empty);
            this.set.add(curr);
        } else {
            curr.setSelf(((Value)curr.getSelf()).getSum(value));
        }
    }

    public void addTotal(K key, V value) {
        SelfAndTotalValueEntry<K, V> curr = (SelfAndTotalValueEntry<K, V>)this.set.get(key);
        if (curr == null) {
            curr = new SelfAndTotalValueEntry<K, V>(key, this.empty, value);
            this.set.add(curr);
        } else {
            curr.setTotal(((Value)curr.getTotal()).getSum(value));
        }
    }

    public void add(V value) {
        this.total = this.total.getSum(value);
    }

    public void add(SelfAndTotalValueStatisticCollector<K, V> other) {
        if (other == this) {
            return;
        }
        for (EntryHashSet.Entry<K> rawEntry : other.set.toArray()) {
            SelfAndTotalValueEntry entry = (SelfAndTotalValueEntry)rawEntry;
            this.addSelf(entry.getKey(), (Value)entry.getSelf());
            this.addTotal(entry.getKey(), (Value)entry.getTotal());
        }
        this.total = this.total.getSum(other.total);
    }

    public void fillStatistic(SelfAndTotalValueStatisticImpl<K, V> statistic) {
        EntryHashSet.Entry<K>[] entries = this.set.toArray();
        if (this.sorter != null) {
            this.sorter.sort(entries);
        }
        SplitArrayObject keys = new SplitArrayObject(0);
        SplitArrayObject selfs = new SplitArrayObject(0);
        SplitArrayObject totals = new SplitArrayObject(0);
        for (int i = 0; i < entries.length; ++i) {
            SelfAndTotalValueEntry entry = (SelfAndTotalValueEntry)entries[i];
            keys.add(entry.getKey());
            selfs.add(entry.getSelf());
            totals.add(entry.getTotal());
            entries[i] = null;
        }
        entries = null;
        statistic.initSelfAndTotal(keys.asList(), selfs.asList(), totals.asList(), this.total);
    }
}

