/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.collector;

import com.sap.jvm.profiling.snapshot.impl.tree.TreeCollector;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueTreeNodeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueTreeNodeBaseImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.Pruner;
import com.sap.jvm.profiling.snapshot.util.Value;

public class SelfAndTotalValueTreeCollector<K, V extends Value<V>>
extends TreeCollector<K, V, SelfAndTotalValueTreeNodeImpl<K, V>> {
    private Pruner<V> treePruner;
    private V total;

    public SelfAndTotalValueTreeCollector(V value) {
        this.total = value;
    }

    public void add(V value) {
        this.total = this.total.getSum(value);
    }

    public V getTotal() {
        return this.total;
    }

    @Override
    public void add(SelfAndTotalValueTreeCollector<K, V> other, SelfAndTotalValueTreeNodeImpl<K, V> startNode) {
        super.addImpl(other, startNode);
        this.total = this.total.getSum(other.total);
    }

    @Override
    protected void add(SelfAndTotalValueTreeNodeImpl<K, V> base, SelfAndTotalValueTreeNodeImpl<K, V> toAdd) {
        base.addSelf(toAdd.getSelf());
        base.addTotal(toAdd.getTotal());
    }

    @Override
    protected boolean shouldPrune(SelfAndTotalValueTreeNodeImpl<K, V> node) {
        if (this.treePruner == null) {
            return false;
        }
        SelfAndTotalValueTreeNodeImpl parent = (SelfAndTotalValueTreeNodeImpl)node.getParent();
        if (parent == null) {
            return false;
        }
        return this.treePruner.shouldPrune(node.getTotal(), parent.getTotal(), this.total);
    }

    @Override
    protected ValueTreeNodeBaseImpl<K, V>[] createArray(int size) {
        return new SelfAndTotalValueTreeNodeImpl[size];
    }

    public void prune(Pruner<V> pruner, int startDepth) {
        if (pruner != null) {
            this.treePruner = pruner;
            this.prune(startDepth);
        }
    }
}

