/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.collector;

import com.sap.jvm.profiling.snapshot.impl.collections.EntryHashSet;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfTotalAndOtherValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.EntrySorter;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfTotalAndOtherValueEntry;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.util.splitarray.SplitArrayObject;

public class SelfTotalAndOtherValueStatisticCollector<K, V extends Value<V>, O extends Value<O>> {
    private final EntryHashSet<K> set = new EntryHashSet();
    private V total;
    private O totalOther;
    private final V empty;
    private final O emptyOther;
    private EntrySorter<K> sorter;

    public SelfTotalAndOtherValueStatisticCollector(V empty, O emptyOther) {
        this.total = empty;
        this.totalOther = emptyOther;
        this.empty = empty;
        this.emptyOther = emptyOther;
    }

    public void setSorter(EntrySorter<K> sorter) {
        this.sorter = sorter;
    }

    public void addSelf(K key, V value) {
        SelfTotalAndOtherValueEntry<K, V, O> curr = (SelfTotalAndOtherValueEntry<K, V, O>)this.set.get(key);
        if (curr == null) {
            curr = new SelfTotalAndOtherValueEntry<K, V, O>(key, value, this.empty, this.emptyOther);
            this.set.add(curr);
        } else {
            curr.setSelf(((Value)curr.getSelf()).getSum(value));
        }
    }

    public void addTotal(K key, V value) {
        SelfTotalAndOtherValueEntry<K, V, O> curr = (SelfTotalAndOtherValueEntry<K, V, O>)this.set.get(key);
        if (curr == null) {
            curr = new SelfTotalAndOtherValueEntry<K, V, O>(key, this.empty, value, this.emptyOther);
            this.set.add(curr);
        } else {
            curr.setTotal(((Value)curr.getTotal()).getSum(value));
        }
    }

    public void addOther(K key, O otherToAdd) {
        SelfTotalAndOtherValueEntry<K, V, O> curr = (SelfTotalAndOtherValueEntry<K, V, O>)this.set.get(key);
        if (curr == null) {
            curr = new SelfTotalAndOtherValueEntry<K, V, O>(key, this.empty, this.empty, otherToAdd);
            this.set.add(curr);
        } else {
            curr.setOther(((Value)curr.getOther()).getSum(otherToAdd));
        }
    }

    public void add(V value, O otherToAdd) {
        this.total = this.total.getSum(value);
        this.totalOther = this.totalOther.getSum(otherToAdd);
    }

    public void add(SelfTotalAndOtherValueStatisticCollector<K, V, O> other) {
        if (other == this) {
            return;
        }
        for (EntryHashSet.Entry<K> rawEntry : other.set.toArray()) {
            SelfTotalAndOtherValueEntry entry = (SelfTotalAndOtherValueEntry)rawEntry;
            this.addSelf(entry.getKey(), (Value)entry.getSelf());
            this.addTotal(entry.getKey(), (Value)entry.getTotal());
            this.addOther(entry.getKey(), (Value)entry.getOther());
        }
        this.total = this.total.getSum(other.total);
        this.totalOther = this.totalOther.getSum(other.totalOther);
    }

    public void fillStatistic(SelfTotalAndOtherValueStatisticImpl<K, V, O> statistic) {
        EntryHashSet.Entry<K>[] entries = this.set.toArray();
        if (this.sorter != null) {
            this.sorter.sort(entries);
        }
        SplitArrayObject keys = new SplitArrayObject(0);
        SplitArrayObject others = new SplitArrayObject(0);
        SplitArrayObject selfs = new SplitArrayObject(0);
        SplitArrayObject totals = new SplitArrayObject(0);
        for (int i = 0; i < entries.length; ++i) {
            SelfTotalAndOtherValueEntry entry = (SelfTotalAndOtherValueEntry)entries[i];
            keys.add(entry.getKey());
            others.add(entry.getOther());
            selfs.add(entry.getSelf());
            totals.add(entry.getTotal());
            entries[i] = null;
        }
        entries = null;
        statistic.initSelfAndTotal(keys.asList(), selfs.asList(), totals.asList(), this.total);
        statistic.initOther(others.asList(), this.totalOther);
    }
}

