/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.util.collector;

import com.sap.jvm.profiling.snapshot.impl.collections.EntryHashSet;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.EntrySorter;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueEntry;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.profiling.util.splitarray.SplitArrayObject;

public class ValueStatisticCollector<K, V extends Value<V>> {
    private final EntryHashSet<K> set = new EntryHashSet();
    private V total;
    private EntrySorter<K> sorter;

    public ValueStatisticCollector(V empty) {
        this.total = empty;
    }

    public void setSorter(EntrySorter<K> sorter) {
        this.sorter = sorter;
    }

    public void add(K key, V value) {
        ValueEntry<K, V> curr = (ValueEntry<K, V>)this.set.get(key);
        if (curr == null) {
            curr = new ValueEntry<K, V>(key, value);
            this.set.add(curr);
        } else {
            curr.setValue(((Value)curr.getValue()).getSum(value));
        }
    }

    public void add(V value) {
        this.total = this.total.getSum(value);
    }

    public void add(ValueStatisticCollector<K, V> other) {
        if (other == this) {
            return;
        }
        for (EntryHashSet.Entry<K> rawEntry : other.set.toArray()) {
            ValueEntry entry = (ValueEntry)rawEntry;
            this.add(entry.getKey(), (Value)entry.getValue());
        }
        this.total = this.total.getSum(other.total);
    }

    public void fillStatistic(ValueStatisticImpl<K, V> statistic) {
        EntryHashSet.Entry<K>[] entries = this.set.toArray();
        if (this.sorter != null) {
            this.sorter.sort(entries);
        }
        SplitArrayObject keys = new SplitArrayObject(0);
        SplitArrayObject values = new SplitArrayObject(0);
        for (int i = 0; i < entries.length; ++i) {
            ValueEntry entry = (ValueEntry)entries[i];
            keys.add(entry.getKey());
            values.add(entry.getValue());
            entries[i] = null;
        }
        entries = null;
        statistic.initValues(keys.asList(), values.asList(), this.total);
    }
}

